@echo off

rem ==================
rem PROGRAM START CODE
rem ==================

cls
echo Sonic Duke Nukem Total Conversion (demo) --- For Duke Nukem 3D
echo.
echo Version 1.0
echo.
echo This batch file was made by Good Mush
echo.
echo This TC for Duke Nukem 3D converts the Duke sprites into all new sonic sprites. 
echo It adds new art and the very first level of the TC.
echo.
echo Note: This is the demo version of the TC, so will show signs of improvement.
echo.
echo This patch will place several new files in your directory.  The files are
echo rtiles005.art, rtiles009.art, rtiles014.art, atiles005.art, atiles009.art,
echo atiles014.art, e1l1.ma_, readme.tx_ and sd_off.huh
echo.
echo I hope you enjoy this Total Conversion!  ---  Good Mush.
echo.
pause

rem ==============
rem MAIN MENU CODE
rem ==============

:top
cls
echo Sonic Duke Nukem Total Conversion (demo) --- For Duke Nukem 3DD
echo.
echo Version 1.0
echo.
echo This batch file was made by Good Mush
echo.
echo Press the corresponding letter below to run that particular command:
echo (Press [CTRL]+[C] at any time to stop the program)
echo.
echo    A - Read This Warning Before Loading!
echo    B - Load The Patch Files
echo    C - Unload The Patch Files
echo    D - Delete All Patch Files
echo    E - Read The Text File
echo    F - Run Duke Nukem 3D
echo    G - Run Setup
echo    H - Exit
echo.
choice /n /c:abcdefgh
if errorlevel 8 goto end
if errorlevel 7 goto setup
if errorlevel 6 goto duke
if errorlevel 5 goto text
if errorlevel 4 goto delete files
if errorlevel 3 goto unloadfiles
if errorlevel 2 goto loadfiles
if errorlevel 1 goto warning

rem ============
rem WARNING CODE
rem ============

:warning
cls
echo.
echo +==========+
echo I          I
echo I WARNING! I
echo I          I
echo +==========+
echo.
echo If you loaded this graphics patch using another version of this batch
echo file, and you DID NOT unload those files before using this new batch 
echo echo file, YOU MUST DELETE THE LOADED FILES (echo rtiles005.art, rtiles009.art, rtiles014.art, atiles005.art, atiles009.art,
echo atiles014.art, e1l1.ma_, readme.tx_ and sd_off.huh), AND THEN LOAD THE FILES AGAIN!  This sets
echo a flag to determine whether the files are loaded or not, and it prevents 
echo you from having large problems in the future.
echo.
pause
goto top

rem ===================
rem LOAD ALL FILES CODE
rem ===================

:loadfiles
cls
echo.
echo What version of Duke Nukem 3D do you want to install to?
echo.
echo Make sure that you are installing to the correct version, as many problems
echo can be caused by not installing to the correct version!
echo.
echo   A - Version 1.3D
echo   B - Version 1.4 or 1.5
echo   C - Return to Main Menu
echo.
choice /n /c:abc
if errorlevel 3 goto top
if errorlevel 2 goto a1 atomic load
if errorlevel 1 goto r1 regular load

rem =====================
rem UNLOAD ALL FILES CODE
rem =====================

:unloadfiles
cls 
echo.
echo What version of Duke Nukem 3D are the patch files currently installed to?
echo.
echo Make sure that you enter the correct version, as many problems can be caused
echo by not selecting the correct version!
echo.
echo   A - Version 1.3D
echo   B - Version 1.4 or 1.5
echo   C - Return to Main Menu
echo.
choice /n /c:abc
if errorlevel 3 goto top
if errorlevel 2 goto a6 atomic unload
if errorlevel 1 goto r6 regular unload

rem ====================
rem REGULAR EDITION CODE
rem ====================

:r1 regular load
if not exist rtiles005.art echo Can't find rtiles005.art
if not exist rtiles009.art echo Can't find rtiles009.art
if not exist rtiles014.art echo Can't find rtiles014.art
if not exist e1l1.ma_ echo Can't find e1l1.ma_
if not exist readme.tx_ echp Can't find readme.tx_
if exist sd_on.huh goto r22 regular already loaded

echo Loading TC Files for Version 1.3D...
echo.
echo Checking for existing tiles005.art file...
echo.
if exist tiles005.art goto r2 regular backup t005 art
if not exist tiles005.art goto r3 regular t009 art check

:r2 regular backup t005 art
echo Backing up tiles005.art file (tiles005.bak)...
copy /y tiles005.art tiles005.bak
echo Done.
echo.

:r3 regular t009 art check
echo Checking for existing tiles009.art file...
echo.
if exist tiles009.art goto r4 regular t009 art backup
if not exist tiles009.art goto r5 regular initnew

:r4 regular t009 art backup
echo Backing up tiles009.art file (tiles009.bak)...
copy /y tiles009.art tiles009.bak
echo Done.
echo.

:r5 regular initnew
echo Initializing regular patch files...
copy /y rtiles005.art tiles005.art
copy /y rtiles009.art tiles009.art
copy /y rtiles014.art tiles014.art
copy /y e1l1.ma_ e1l1.map
copy /y readme.tx_ readme.txt
copy /y sd_off.huh sd_on.huh
erase sd_off.huh
echo Done.
echo.
echo You are now ready to play. I hope you enjoy this Total Conversion!
echo.
echo You can e-mail me at GoodMush@aol.com
echo.
echo For more updates, news etc. see our web site at:
echo www.dukeworld.com/sonicduke
echo.
echo Keep it real,
echo Good Mush
echo.
pause
goto top

rem =================================
rem REGULAR EDITION UNLOAD FILES CODE
rem =================================

:r6 regular unload
if exist sd_on.huh goto r7 regular not unloaded
if exist sd_off.huh goto r23 regular is unloaded

:r7 regular not unloaded
echo.
echo Checking for tiles005.bak file...
echo.
if exist tiles005.bak goto r8 regular restore t005 art
if not exist tiles005.bak goto r9 regular erase t005 art

:r8 regular restore t005 art
echo Restoring original tiles005.art file...
copy /y tiles005.bak tiles005.art
erase tiles005.bak
echo Done.
echo.
goto r10 regular art unload check

:r9 regular erase t005 art
erase tiles005.art

:r10 regular t009 art unload check
echo Checking for tiles009.bak file...
echo.
if exist tiles009.bak goto r11 regular t009 art restore
if not exist tiles009.bak goto r12 regular t009 art erase

:r11 regular t009 art restore
echo Restoring original tiles009.art file...
copy /y tiles009.bak tiles009.art
erase tiles009.bak
echo Done.
echo.
goto r13 regular t014 art unload check

:r12 regular t009 art erase
erase tiles009.art

:r13 regular t014 art unload check
echo Checking for tiles014.bak file...
echo.
if exist tiles014.bak goto r14 regular t014 art restore
if not exist tiles014.bak goto r15 regular t014 art erase

:r14 regular t014 art restore
echo Restoring original tiles014.art file...
copy /y tiles014.bak tiles014.art
erase tiles014.bak
echo Done.
echo.
goto r16 regular e1l1 map unload check

:r15 regular t014 art erase
erase tiles014.art

:r16 regular e1l1 map unload check
echo Checking for e1l1.bak file...
echo.
if exist e1l1.bak goto r17 regular e1l1 map restore
if not exist e1l1.bak goto r18 regular e1l1 map erase

:r17 regular e1l1 map restore
echo Restoring original e1l1.map file...
copy /y e1l1.bak e1l1.map
erase e1l1.bak
echo Done.
echo.
goto r19 regular readme txt unload check

:r18 regular e1l1 map erase
erase e1l1.map

:r19 regular readme txt unload check
echo Checking for readme.bak file...
echo.
if exist readme.bak goto r20 regular readme txt restore
if not exist readme.bak goto r21 regular readme txt erase

:r20 regular readme txt restore
echo Restoring original readme.txt file...
copy /y readme.bak readme.txt
erase readme.bak
echo Done.
echo.

:r21 regular readme txt erase
erase readme.txt
copy /y sd_on.huh sd_off.huh
erase sd_on.huh
pause
goto top

:r22 regular already loaded
echo You have already loaded the patch files.
echo.
pause
goto top

:r23 regular is unloaded
echo You have already unloaded the patch files.
echo.
pause
goto top


rem ===================
rem ATOMIC EDITION CODE
rem ===================

:a1 atomic load
if not exist atiles005.art echo Can't find atiles005.art
if not exist atiles009.art echo Can't find atiles009.art
if not exist atiles014.art echo Can't find atiles014.art
if not exist e1l1.ma_ echo Can't find e1l1.ma_
if not exist readme.tx_ echp Can't find readme.tx_
if exist sd_on.huh goto r22 regular already loaded

echo Loading TC Files for Version 1.4 or 1.5...
echo.
echo Checking for existing tiles005.art file...
echo.
if exist tiles005.art goto a2 atomic backup t005 art
if not exist tiles005.art goto a3 atomic t009 art check

:a2 atomic backup t005 art
echo Backing up tiles005.art file (tiles005.bak)...
copy /y tiles005.art tiles005.bak
echo Done.
echo.

:a3 atomic t009 art check
echo Checking for existing tiles009.art file...
echo.
if exist tiles009.art goto a4 atomic t009 art backup
if not exist tiles009.art goto a5 atomic initnew

:a4 atomic t009 art backup
echo Backing up tiles009.art file (tiles009.bak)...
copy /y tiles009.art tiles009.bak
echo Done.
echo.

:a5 regular initnew
echo Initializing regular patch files...
copy /y atiles005.art tiles005.art
copy /y atiles009.art tiles009.art
copy /y atiles014.art tiles014.art
copy /y e1l1.ma_ e1l1.map
copy /y readme.tx_ readme.txt
copy /y sd_off.huh sd_on.huh
erase sd_off.huh
echo Done.
echo.
echo You are now ready to play. I hope you enjoy this Total Conversion!
echo.
echo You can e-mail me at GoodMush@aol.com
echo.
echo For more updates, news etc. see our web site at:
echo www.dukeworld.com/sonicduke
echo.
echo Keep it real,
echo Good Mush
echo.
pause
goto top

rem ================================
rem ATOMIC EDITION UNLOAD FILES CODE
rem ================================

:a6 atomic unload
if exist sd_on.huh goto a7 atomic not unloaded
if exist sd_off.huh goto a23 unloaded atomic

:a7 atomic not unloaded
echo.
echo Checking for tiles005.bak file...
echo.
if exist tiles005.bak goto a8 atomic restore t005 art
if not exist tiles005.bak goto a9 atomic erase t005 art

:a8 atomic restore t005 art
echo Restoring original tiles005.art file...
copy /y tiles005.bak tiles005.art
erase tiles005.bak
echo Done.
echo.
goto a10 atomic art unload check

:a9 atomic erase t005 art
erase tiles005.art

:a10 atomic t009 art unload check
echo Checking for tiles009.bak file...
echo.
if exist tiles009.bak goto a11 atomic t009 art restore
if not exist tiles009.bak goto a12 atomic t009 art erase

:a11 atomic t009 art restore
echo Restoring original tiles009.art file...
copy /y tiles009.bak tiles009.art
erase tiles009.bak
echo Done.
echo.
goto a13 atomic t014 art unload check

:a12 atomic t009 art erase
erase tiles009.art

:a13 atomic t014 art unload check
echo Checking for tiles014.bak file...
echo.
if exist tiles014.bak goto a14 atomic t014 art restore
if not exist tiles014.bak goto a15 atomic t014 art erase

:a14 atomic t014 art restore
echo Restoring original tiles014.art file...
copy /y tiles014.bak tiles014.art
erase tiles014.bak
echo Done.
echo.
goto a16 atomic e1l1 map unload check

:a15 atomic t014 art erase
erase tiles014.art

:a16 atomic e1l1 map unload check
echo Checking for e1l1.bak file...
echo.
if exist e1l1.bak goto a17 atomic e1l1 map restore
if not exist e1l1.bak goto a18 atomic e1l1 map erase

:a17 atomic e1l1 map restore
echo Restoring original e1l1.map file...
copy /y e1l1.bak e1l1.map
erase e1l1.bak
echo Done.
echo.
goto a19 atomic readme txt unload check

:a18 atomic e1l1 map erase
erase e1l1.map

:a19 atomic readme txt unload check
echo Checking for readme.bak file...
echo.
if exist readme.bak goto a20 atomic readme txt restore
if not exist readme.bak goto a21 atomic readme txt erase

:a20 atomic readme txt restore
echo Restoring original readme.txt file...
copy /y readme.bak readme.txt
erase readme.bak
echo Done.
echo.

:a21 atomic readme txt erase
erase readme.txt
copy /y sd_on.huh sd_off.huh
erase sd_on.huh
pause
goto top

:a22 atomic already loaded
echo You have already loaded the patch files.
echo.
pause
goto top

:a23 unloaded atomic
echo You have already unloaded the patch files.
echo.
pause
goto top


rem =====================
rem DELETE ALL FILES CODE
rem =====================

:delete files
cls
echo.
echo Have you unloaded the patch files from your directory?
echo.
echo Unloading the patch files from your drive, ensures that all files
echo are deleted when you choose to do so.  If you are unsure if they
echo have been unloaded or not, press N, and then choose to unload the
echo files from the main menu.
echo.
echo Y - Yes, I have unloaded the patch files.
echo N - No, I have not unloaded the patch files.
echo.
choice /n /c:ny
if errorlevel 2 goto delete2
if errorlevel 1 goto top

:delete2
echo Deleting all Sonic Duke Nukem Total Conversion (demo) files...
erase rtiles005.art
erase rtiles009.art
erase rtiles014.art
erase atiles005.art
erase atiles009.art
erase atiles014.art
erase e1l1.ma_
erase readme.tx_
erase sd_on.huh
erase sd_off.huh
echo Done.
echo.
echo Type "erase sonicduke.bat" at the command line to delete this batch file.
echo.
pause
goto end

rem ==============
rem TEXT FILE CODE
rem ==============

:text
type readme.tx_ | more
pause 
goto top

rem =============================
rem DUKE NUKEM 3D EXECUTABLE CODE
rem =============================

:duke
duke3d
goto top

rem =====================
rem SETUP EXECTUABLE CODE
rem =====================

:setup
setup
goto top

rem ================
rem END PROGRAM CODE
rem ================

:end
cls
echo.
echo Sonic Duke Nukem Total Conversion (demo) --- For Duke Nukem 3D
echo.
echo www.dukeworld.com/sonicduke
echo.
echo Keep it real,
echo Good Mush
echo.
