;
; ⥬ । , (C) .⥪                     
;

       Include Support.inc
       Include Control.inc
       Include Global.inc
       Include Constant.inc

; $Log: memory.asm $
; Revision 1.2  1997/01/17 15:46:47  GLASS
; - 訡 墠⪨    樠樨 
;   訡  ⠥.
;
; Revision 1.1  1997/01/17 15:42:28  GLASS
; Initial revision
;

.data
;-----------------------;
__memFree   DB  FALSE   ; ਧ ஢ 樠樨 
;-----------------------;

.code
;ͻ
; 樠                                                  
;͹
; Call  Assembler                                                     
;ͼ
_memInit proc near Uses ax bx cx dx ds es

    mvs     ds,cs
    call    _errReset               ; । 訡.
    @if __memFree == FALSE then     ;᫨ 樠 맢
        mvs     es,cs               ;  ࠧ, 㬥 ࠧ
        mov     bx,1000h            ; , 뤥 ணࠬ,
        @int    4Ah,21h             ;  ᥣ.
        @if CF == 1 then
            @if  ax #= 8            ;᫨ 뤠 訡  墠⪥
                 call  __memError   ;,  ணࠬ 稫
                 jmp   short @@Exit ;  , 祬 ⥫.
            @endif
        @endif
        mov __memFree,TRUE
    @endif

@@Exit: ret
endp

;ͻ
; ࠡ 訡                                              
;͹
; Call  Assembler                                                     
;ͼ
__memError proc near Uses ds ax

    mvs     ds,cs
    call    _dosError
    @if _errDos == 08h then
        mov _errCode, EC_MEMLOW
    @else
        mov _errCode, EC_MEMDEF
    @endif
    mov     _errObject,    NIL
    mov     _errType,      ET_ERROR
    mov     _errAsk,       EA_ABEND
    mov     _errRecommend, ER_ABEND
    call    _errEntry
    ret
endp

;ͻ
; 易⥫쭮 ।                                     
;͹
; Call  Assembler                                                     
;͹
; In    AX । ࠧ                        
;Ķ
; Out   AX ᮤন ᥣ ।                
;ͼ
_memGrab proc near Uses bx dx es

    @if cs:__memFree == FALSE then
        call _memInit
        @if  cs:_errRecommend #= ER_CONT then
             mov  ax, NIL
             jmp  short @@Exit
        @endif
    @endif
    call    _errReset       ; । 訡.

    xor   dx,dx
    mov   bx,16             ;᫨ ࠧ 室 
    div   bx                ; ॢ  ࠣ.
    @if dx #= 0 then
        inc ax
    @endif
    mov   bx,ax
    @int  48h,21h           ;।  .
    @if CF == 1 then
        call    __memError
        mov     ax, NIL
        jmp     short @@Exit
    @endif

@@Exit: ret
endp

;ͻ
; 易⥫쭮 ।                                   
;͹
; Call  Assembler                                                     
;͹
; In    AX । ࠧ                        
;Ķ
; Out   AX ᮤন ᥣ ।    NIL      
;ͼ
_memAllocate proc near Uses bx dx es ds

    @if cs:__memFree == FALSE then
        push  ax                    ;᫨ 樠  
        push  cs                    ;஢, 㬥 ࠧ
        pop   es                    ; , 뤥 ணࠬ,
        mov   bx,1000h              ;  ᥣ.
        @int  4Ah,21h
        pop   ax
        @if CF == 1 then
            mov   ax,NIL
            jmp   short @@Exit
        @endif
        mov cs:__memFree,TRUE
    @endif

    xor   dx,dx
    mov   bx,16             ;᫨ ࠧ 室 
    div   bx                ; ॢ  ࠣ.
    @if dx #= 0 then
        inc   ax
    @endif
    mov   bx,ax
    @int  48h,21h           ;।  .
    @if CF == 1 then
        mov   ax, NIL
        jmp   short @@Exit
    @endif

@@Exit: ret
endp

;ͻ
; ᢮                                                 
;͹
; Call  Assembler                                                     
;͹
; In    AX । ࠧ ᥣ                     
;ͼ
_memFree proc near Uses ax bx dx es

    call  _errReset         ; । 訡.
    mov   es,ax
    @int  49h,21h           ;᢮  .
    @if CF == 1 then
        call    __memError
    @endif
    ret
endp

;ͻ
; ஢                                               
;͹
; Call  Assembler                                                     
;Ķ
; In    DS:SI - ⥫  室                             
;       ES:DI - ⥫  楫                              
;       CX    -                                            
;ͼ
_memCopy proc near Uses ax bx cx dx es ds di si

 call __qpiInstall
 @if  al == TRUE
      mov  bx,ds
      @if bx += 0C000h
         call __qpiCopyRom
         @if  al == TRUE
              ret
         @endif
      @endif
 @endif
 rep movsb
 ret
endp
end
