;
; ⮡ࠦ 樮쭮-ᨬ ଠ樨, (C) D.Steklenev       
;

    include support.inc
    include control.inc
    include global.inc
    include constant.inc

;ͻ
;   
;ͼ

country struc                   ; 樮쭠 ଠ
                                ; -----------------------
  cty_id_info   DB  0           ; 䨪 ଠ樨
  cty_size      DW  0           ;   ଠ樨
  cty_id        DW  0           ; 䨪 ࠭
  cty_page      DW  0           ;  ࠭
  cty_date      DW  0           ; ଠ 
                                ;
      cty_MDY   =   0           ;   ଠ :         //
      cty_DMY   =   1           ;   ய᪨ ଠ: //
      cty_YMD   =   2           ;   ᪨ ଠ:    //
                                ;
  cty_sym_many  DB  5 dup (0)   ;  ᨬ
  cty_sep_ths   DB  0,0         ; ⥫ 
  cty_sep_dec   DB  0,0         ; ⥫ 
  cty_sep_date  DB  0,0         ; ⥫ 
  cty_sep_time  DB  0,0         ; ⥫ ६
  cty_many      DB  0           ;  ଠ
                                ;
      cty_$nd   =   0           ;   $123.00
      cty_nd$   =   1           ;   123.00$
      cty_$_nd  =   2           ;   $ 123.00
      cty_nd_$  =   3           ;   123.00 $
      cty_n$d   =   4           ;   123$00
                                ;
  cty_many_dec  DB  0           ;  ᫥ ⮩  ⮨
  cty_time      DB  0           ; ଠ ६
                                ;
      cty_12s   =   0           ;   12-ᮢ ଠ  ᥪ㭤
      cty_24s   =   1           ;   24-ᮢ ଠ  ᥪ㭤
      cty_12    =   2           ;   12-ᮢ ଠ  ᥪ㭤
      cty_24    =   3           ;   24-ᮢ ଠ  ᥪ㭤
                                ;
  cty_upper_ptr DD  0           ; ⥫  㭪 ८ࠧ  
  cty_sep_data  DB  0,0         ; ⥫ ᯨ᪠ 
                DB  10 dup (0)  ;
ends

  cty_info_len  =   29h         ;   樮쭮 ଠ樨

.data
;ͻ
;   ᮮ饭 
;ͼ

msgTitle    DB  'Country Page Information Version 1.0'  ,CR,LF
            DB  'Copyright (C) 1994 Dmitry A. Steklenev',CR,LF,LF,0

errVersion  DB  'Error: Dos Version below 3.0'  ,0

xgaInfo     COUNTRY <>          ;樮쭮 ᨬ ଠ.

strDigit    DB  11 dup (0)

strMDY      DB  "MM/DD/YY",0    ;ଠ :         //
strDMY      DB  "DD/MM/YY",0    ;ய᪨ ଠ: //
strYMD      DB  "YY/MM/DD",0    ;᪨ ଠ:    //

str12s      DB  "10:00:00 pm",0 ;12-ᮢ ଠ  ᥪ㭤
str24s      DB  "22:00:00"   ,0 ;24-ᮢ ଠ  ᥪ㭤
str12       DB  "10:00 pm"   ,0 ;12-ᮢ ଠ  ᥪ㭤
str24       DB  "22:00"      ,0 ;24-ᮢ ଠ  ᥪ㭤

strNumeric  DB  "123,000.00" ,0 ;᫮ ଠ

strMany     DB  13 dup (0)      ; ଠ
strPage     DB   6 dup (0)      ; ࠭

msgCtyId    DB  "     Country Id: ",0
msgCtyPage  DB  "        Page Id: ",0
msgCtyDate  DB  "    Date format: ",0
msgCtyTime  DB  "    Time format: ",0
msgCtyNum   DB  " Numeric format: ",0
msgCtyMany  DB  "Currency format: ",0
msgCtyData  DB  " Data separator: ",0

.code
.startup
;ͻ
;  楤 
;ͼ
ctryInfo proc near

  @out msgTitle               ;뢥 ଠ  ணࠬ.

  @int 30h,21h
  @if  <ax -- 3> or <<al == 3> and <ah -- 30>>
       @out errVersion
       @quit 1
  @endif

  ;;   ଠ樨
  ;; -----------------------/

  mov   dx,0FFFFh
  mov   bx,dx
  mov   cx,cty_info_len
  lea   di,xgaInfo
  @int  6501h,21h

; lea dx,xgaInfo+7
; mov al,0
; @int 38h,21h

  ;; 뢥  ࠭
  ;; -----------------/

  @out  msgCtyId
  @dcv  xgaInfo.cty_id strDigit 10
  @out  si
  call  _dosEject

  ;; 뢥  ࠭
  ;; -------------------/

  @out  msgCtyPage
  @dcv  xgaInfo.cty_page strDigit 10
  @out  si
  call  _dosEject

  ;; 뢥 ଠ 
  ;; ------------------/

  @out  msgCtyDate
  mov   bx,xgaInfo.cty_date
  mov   al,xgaInfo.cty_sep_date

  @if     bx == cty_MDY               ;㧨 㪠⥫ 
          lea si,strMDY               ;ᮮ⢥騩 ଠ
  @elseif bx == cty_DMY               ;蠡 .
          lea si,strDMY
  @else
          lea si,strYMD
  @endif

  mov   [si][2],al                    ;⠭ ⥪騥
  mov   [si][5],al                    ;ࠧ⥫ .
  @out  si
  call  _dosEject

  ;; 뢥 ଠ ६
  ;; ---------------------/

  @out  msgCtyTime
  mov   bl,xgaInfo.cty_time
  mov   al,xgaInfo.cty_sep_time

  @if     bl == cty_12s               ;㧨 㪠⥫ 
          lea si,str12s               ;ᮮ⢥騩 ଠ
  @elseif bl == cty_24s               ;蠡 ६.
          lea si,str24s
  @elseif bl == cty_12
          lea si,str12
  @else
          lea si,str24
  @endif
                                      ;⠭ ࠧ⥫.
  mov   [si][2],al
  @if   <bl == cty_24s> or <bl == cty_12s>
        mov   [si][5],al
  @endif
  @out  si
  call  _dosEject

  ;; 뢥 ᫮ ଠ
  ;; ----------------------/

  @out  msgCtyNum
  mov   al,xgaInfo.cty_sep_ths
  mov   strNumeric[3],al
  mov   al,xgaInfo.cty_sep_dec
  mov   strNumeric[7],al
  @out  strNumeric
  call  _dosEject

  ;; 뢥  ଠ
  ;; ----------------------/

  @out  msgCtyMany
  lea   di,strMany
  mov   bl,xgaInfo.cty_many

  @if   <bl == cty_$nd> or <bl == cty_$_nd>
        lea  si,xgaInfo.cty_sym_many
        call _strCopy
  @endif
  @if   bl == cty_$_nd
        mov al," "
        stosb
  @endif

  mov al,"1"
  stosb
  mov al,"2"
  stosb
  mov al,"3"
  stosb

  @if bl == cty_n$d
      lea  si,xgaInfo.cty_sym_many
      call _strCopy
  @else
      mov  al,xgaInfo.cty_sep_dec
      stosb
  @endif

  mov al,"0"
  xor ch,ch
  mov cl,xgaInfo.cty_many_dec
  @if cl ++ 5
      mov cl,5
  @endif
  rep stosb

  @if bl == cty_nd_$
      mov al," "
      stosb
  @endif

  @if <bl == cty_nd$> or <bl == cty_nd_$>
      lea  si,xgaInfo.cty_sym_many
      call _strCopy
  @endif

  mov   @byte(di),0
  @out  strMany
  call  _dosEject

  ;; 뢥 ࠧ⥫ 
  ;; -------------------------/

  @out  msgCtyData
  mov   al,xgaInfo.cty_sep_data
  call  _dosChar
  call  _dosEject

  @quit 0

endp
end @startup
