/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.Camera;
import artofillusion.PluginRegistry;
import artofillusion.RenderListener;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.image.ComplexImage;
import artofillusion.image.filter.ImageFilter;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.SceneCamera;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.RepaintEvent;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BList;
import buoy.widget.BOutline;
import buoy.widget.BScrollPane;
import buoy.widget.BorderContainer;
import buoy.widget.ColumnContainer;
import buoy.widget.CustomWidget;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.WindowWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CameraFilterDialog
extends BDialog
implements RenderListener {
    private SceneCamera theCamera;
    private Scene theScene;
    private CoordinateSystem cameraCoords;
    private ImageFilter[] oldFilters;
    private FiltersPanel filtersPanel;
    private CustomWidget preview;
    private ComplexImage unfilteredImage;
    private Image displayImage;
    private boolean doneRendering;
    private boolean doneFiltering;
    private Map savedConfiguration;
    private Thread filterThread;
    private static Renderer previewRenderer = ArtOfIllusion.getPreferences().getTexturePreviewRenderer();
    private static HashMap<Renderer, Map<String, Object>> rendererConfiguration = new HashMap();
    private static final int PREVIEW_WIDTH = 200;
    private static final int PREVIEW_HEIGHT = 150;

    public CameraFilterDialog(WindowWidget parent, Scene scene, SceneCamera camera, CoordinateSystem cameraCoords) {
        super(parent, Translate.text("Filters"), true);
        this.theCamera = camera;
        this.theScene = scene;
        this.cameraCoords = cameraCoords;
        this.oldFilters = this.theCamera.getImageFilters();
        for (int i = 0; i < this.oldFilters.length; ++i) {
            this.oldFilters[i] = this.oldFilters[i].duplicate();
        }
        FormContainer content = new FormContainer(2, 2);
        this.setContent(content);
        LayoutInfo fillLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null);
        this.filtersPanel = new FiltersPanel(this.theCamera, new Runnable(){

            @Override
            public void run() {
                CameraFilterDialog.this.applyFilters();
            }
        });
        BorderContainer previewPanel = new BorderContainer();
        RowContainer okPanel = new RowContainer();
        content.add(this.filtersPanel, 0, 0, fillLayout);
        content.add(previewPanel, 1, 0, new LayoutInfo());
        content.add(okPanel, 0, 1, 2, 1, new LayoutInfo());
        this.preview = new CustomWidget();
        this.preview.addEventLink(RepaintEvent.class, (Object)this, "paintPreview");
        this.preview.setPreferredSize(new Dimension(200, 150));
        previewPanel.add(this.preview, BorderContainer.CENTER);
        previewPanel.add(Translate.button("configurePreview", this, "doConfigure"), BorderContainer.SOUTH, new LayoutInfo());
        okPanel.add(Translate.button("ok", this, "doOk"));
        okPanel.add(Translate.button("cancel", this, "doCancel"));
        this.savedConfiguration = previewRenderer.getConfiguration();
        Map<String, Object> recordedConfig = rendererConfiguration.get(previewRenderer);
        if (recordedConfig == null) {
            previewRenderer.configurePreview();
            recordedConfig = previewRenderer.getConfiguration();
            rendererConfiguration.put(previewRenderer, recordedConfig);
        }
        this.configureRenderer(recordedConfig, previewRenderer);
        this.renderPreview();
        this.pack();
        UIUtilities.centerDialog(this, parent);
        this.setVisible(true);
    }

    private void configureRenderer(Map config, Renderer renderer) {
        if (config == null) {
            return;
        }
        for (Map.Entry entry : config.entrySet()) {
            renderer.setConfiguration((String)entry.getKey(), entry.getValue());
        }
    }

    private void renderPreview() {
        Camera cam = this.theCamera.createCamera(200, 150, this.cameraCoords);
        SceneCamera renderCamera = this.theCamera.duplicate();
        renderCamera.setExtraRequiredComponents(-1);
        this.doneRendering = false;
        previewRenderer.renderScene(this.theScene, cam, this, renderCamera);
    }

    private void doOk() {
        ImageFilter[] filt = this.filtersPanel.filters.toArray(new ImageFilter[this.filtersPanel.filters.size()]);
        this.theCamera.setImageFilters(filt);
        this.configureRenderer(this.savedConfiguration, previewRenderer);
        this.dispose();
    }

    private void doCancel() {
        ImageFilter[] filt = this.theCamera.getImageFilters();
        for (int i = 0; i < filt.length; ++i) {
            filt[i].copy(this.oldFilters[i]);
        }
        this.configureRenderer(this.savedConfiguration, previewRenderer);
        this.dispose();
    }

    private void doConfigure() {
        final BorderContainer content = new BorderContainer();
        final BComboBox rendererChoice = new BComboBox();
        final List<Renderer> renderers = PluginRegistry.getPlugins(Renderer.class);
        for (int i = 0; i < renderers.size(); ++i) {
            rendererChoice.add(renderers.get(i).getName());
            if (previewRenderer != renderers.get(i)) continue;
            rendererChoice.setSelectedIndex(i);
        }
        RowContainer rc = new RowContainer();
        rc.add(Translate.label("Renderer", ":"));
        rc.add(rendererChoice);
        content.add(rc, BorderContainer.NORTH, new LayoutInfo());
        content.add(previewRenderer.getConfigPanel(), BorderContainer.CENTER);
        rendererChoice.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                Renderer newRenderer = (Renderer)renderers.get(rendererChoice.getSelectedIndex());
                Map<String, Object> recordedConfig = (Map<String, Object>)rendererConfiguration.get(newRenderer);
                if (recordedConfig == null) {
                    newRenderer.configurePreview();
                    recordedConfig = newRenderer.getConfiguration();
                    rendererConfiguration.put(newRenderer, recordedConfig);
                }
                CameraFilterDialog.this.configureRenderer(recordedConfig, newRenderer);
                content.add(newRenderer.getConfigPanel(), BorderContainer.CENTER);
                UIUtilities.findWindow(content).pack();
            }
        });
        PanelDialog dlg = new PanelDialog((WindowWidget)this, Translate.text("configurePreview"), content);
        if (!dlg.clickedOk()) {
            return;
        }
        this.configureRenderer(this.savedConfiguration, previewRenderer);
        previewRenderer = renderers.get(rendererChoice.getSelectedIndex());
        this.savedConfiguration = previewRenderer.getConfiguration();
        previewRenderer.recordConfiguration();
        rendererConfiguration.put(previewRenderer, previewRenderer.getConfiguration());
        this.renderPreview();
        this.preview.repaint();
    }

    private void paintPreview(RepaintEvent ev) {
        Graphics2D g = ev.getGraphics();
        if (this.displayImage != null) {
            g.drawImage(this.displayImage, 0, 0, null);
        }
        String message = null;
        if (!this.doneRendering) {
            message = "Rendering Preview...";
        } else if (!this.doneFiltering) {
            message = "Applying Filter...";
        }
        if (message != null) {
            FontMetrics fm = g.getFontMetrics();
            int width = fm.stringWidth(message);
            g.setColor(Color.red);
            g.drawString(message, (200 - width) / 2, 75);
        }
    }

    private synchronized void applyFilters() {
        this.preview.repaint();
        if (this.filterThread != null) {
            this.filterThread.interrupt();
        }
        this.filterThread = new Thread(){

            @Override
            public void run() {
                if (CameraFilterDialog.this.unfilteredImage == null) {
                    return;
                }
                ComplexImage img = CameraFilterDialog.this.unfilteredImage.duplicate();
                for (int i = 0; i < CameraFilterDialog.this.filtersPanel.filters.size(); ++i) {
                    ((ImageFilter)CameraFilterDialog.this.filtersPanel.filters.get(i)).filterImage(img, CameraFilterDialog.this.theScene, CameraFilterDialog.this.theCamera, CameraFilterDialog.this.cameraCoords);
                }
                if (CameraFilterDialog.this.filtersPanel.filters.size() > 0) {
                    img.rebuildImage();
                }
                if (CameraFilterDialog.this.filterThread == Thread.currentThread()) {
                    CameraFilterDialog.this.displayImage = img.getImage();
                }
                CameraFilterDialog.this.preview.repaint();
            }
        };
        this.filterThread.start();
    }

    @Override
    public void imageUpdated(Image image) {
        this.displayImage = image;
        this.preview.repaint();
    }

    @Override
    public void statusChanged(String status) {
    }

    @Override
    public void imageComplete(ComplexImage image) {
        this.unfilteredImage = image;
        this.displayImage = image.getImage();
        this.doneFiltering = false;
        this.doneRendering = true;
        this.applyFilters();
        this.doneFiltering = true;
    }

    @Override
    public void renderingCanceled() {
    }

    public static class FiltersPanel
    extends FormContainer {
        private BScrollPane editorPane;
        private BList allFiltersList;
        private BList cameraFiltersList;
        private BButton addButton;
        private BButton deleteButton;
        private BButton upButton;
        private BButton downButton;
        private Class[] filterClasses;
        private ArrayList<ImageFilter> filters;
        Runnable filterChangedCallback;

        public FiltersPanel(SceneCamera camera, Runnable filterChangedCallback) {
            super(1, 2);
            this.filterChangedCallback = filterChangedCallback;
            this.filters = new ArrayList();
            ImageFilter[] oldFilters = camera.getImageFilters();
            for (int i = 0; i < oldFilters.length; ++i) {
                this.filters.add(oldFilters[i]);
            }
            LayoutInfo fillLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null);
            FormContainer listsPanel = new FormContainer(3, 1);
            this.editorPane = new BScrollPane();
            this.editorPane.setPreferredViewSize(new Dimension(200, 150));
            this.add(listsPanel, 0, 0, fillLayout);
            this.add(BOutline.createBevelBorder(this.editorPane, false), 0, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, new Insets(2, 2, 2, 2), null));
            this.allFiltersList = new BList();
            listsPanel.add(UIUtilities.createScrollingList(this.allFiltersList), 0, 0, fillLayout);
            ColumnContainer buttonsPanel = new ColumnContainer();
            listsPanel.add(buttonsPanel, 1, 0);
            this.cameraFiltersList = new BList();
            listsPanel.add(UIUtilities.createScrollingList(this.cameraFiltersList), 2, 0, fillLayout);
            buttonsPanel.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(2, 2, 2, 2), null));
            this.addButton = Translate.button("add", " >>", this, "doAdd");
            buttonsPanel.add(this.addButton);
            this.deleteButton = Translate.button("delete", this, "doDelete");
            buttonsPanel.add(this.deleteButton);
            this.upButton = Translate.button("moveUp", this, "doMoveUp");
            buttonsPanel.add(this.upButton);
            this.downButton = Translate.button("moveDown", this, "doMoveDown");
            buttonsPanel.add(this.downButton);
            this.allFiltersList.addEventLink(SelectionChangedEvent.class, (Object)this, "updateComponents");
            this.cameraFiltersList.addEventLink(SelectionChangedEvent.class, (Object)this, "updateComponents");
            this.allFiltersList.setMultipleSelectionEnabled(false);
            this.cameraFiltersList.setMultipleSelectionEnabled(false);
            List<ImageFilter> filters = PluginRegistry.getPlugins(ImageFilter.class);
            this.filterClasses = new Class[filters.size()];
            for (int i = 0; i < this.filterClasses.length; ++i) {
                this.filterClasses[i] = filters.get(i).getClass();
                try {
                    this.allFiltersList.add(((ImageFilter)this.filterClasses[i].newInstance()).getName());
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.rebuildFilterList();
            if (this.cameraFiltersList.getItemCount() > 0) {
                this.cameraFiltersList.setSelected(0, true);
            }
            ((BScrollPane)this.cameraFiltersList.getParent()).setPreferredViewSize(this.allFiltersList.getPreferredSize());
            this.updateComponents();
        }

        public ArrayList<ImageFilter> getFilters() {
            return this.filters;
        }

        private void updateComponents() {
            this.addButton.setEnabled(this.allFiltersList.getSelectedIndex() > -1);
            int selection = this.cameraFiltersList.getSelectedIndex();
            this.deleteButton.setEnabled(selection > -1);
            this.upButton.setEnabled(selection > 0);
            this.downButton.setEnabled(selection > -1 && selection < this.filters.size() - 1);
            if (selection > -1) {
                this.editorPane.setContent(this.filters.get(this.cameraFiltersList.getSelectedIndex()).getConfigPanel(this.filterChangedCallback));
            } else {
                this.editorPane.setContent(null);
            }
            this.editorPane.layoutChildren();
        }

        private void rebuildFilterList() {
            this.cameraFiltersList.removeAll();
            for (int i = 0; i < this.filters.size(); ++i) {
                this.cameraFiltersList.add(this.filters.get(i).getName());
            }
        }

        private void doAdd() {
            int sel = this.allFiltersList.getSelectedIndex();
            if (sel == -1) {
                return;
            }
            try {
                this.filters.add((ImageFilter)this.filterClasses[sel].newInstance());
                this.rebuildFilterList();
                this.cameraFiltersList.setSelected(this.filters.size() - 1, true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.updateComponents();
            this.filterChangedCallback.run();
        }

        private void doDelete() {
            int sel = this.cameraFiltersList.getSelectedIndex();
            if (sel == -1) {
                return;
            }
            this.filters.remove(sel);
            this.rebuildFilterList();
            this.updateComponents();
            this.filterChangedCallback.run();
        }

        private void doMoveUp() {
            int sel = this.cameraFiltersList.getSelectedIndex();
            if (sel < 1) {
                return;
            }
            ImageFilter filt = this.filters.get(sel);
            this.filters.remove(sel);
            this.filters.add(sel - 1, filt);
            this.rebuildFilterList();
            this.cameraFiltersList.setSelected(sel - 1, true);
            this.updateComponents();
            this.filterChangedCallback.run();
        }

        private void doMoveDown() {
            int sel = this.cameraFiltersList.getSelectedIndex();
            if (sel == -1 || sel == this.filters.size() - 1) {
                return;
            }
            ImageFilter filt = this.filters.get(sel);
            this.filters.remove(sel);
            this.filters.add(sel + 1, filt);
            this.rebuildFilterList();
            this.cameraFiltersList.setSelected(sel + 1, true);
            this.updateComponents();
            this.filterChangedCallback.run();
        }
    }
}

