/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.CurveEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.UndoRecord;
import artofillusion.WireframeMesh;
import artofillusion.math.Vec2;
import artofillusion.object.Curve;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.UIUtilities;
import buoy.event.WidgetMouseEvent;
import buoy.widget.RowContainer;
import java.awt.Color;
import java.awt.Point;

public class CurveViewer
extends MeshViewer {
    boolean draggingSelectionBox;
    boolean dragging;
    int deselect;

    public CurveViewer(MeshEditController window, RowContainer p) {
        super(window, p);
    }

    @Override
    protected void drawObject() {
        int i;
        if (!this.showMesh) {
            return;
        }
        MeshVertex[] v = ((Mesh)((Object)this.getController().getObject().getObject())).getVertices();
        boolean[] selected = this.controller.getSelection();
        WireframeMesh wireframe = this.getController().getObject().getObject().getWireframeMesh();
        for (i = 0; i < wireframe.from.length; ++i) {
            this.renderLine(wireframe.vert[wireframe.from[i]], wireframe.vert[wireframe.to[i]], this.theCamera, lineColor);
        }
        for (i = 0; i < v.length; ++i) {
            if (selected[i] || !(this.theCamera.getObjectToView().timesZ(v[i].r) > this.theCamera.getClipDistance())) continue;
            Vec2 p = this.theCamera.getObjectToScreen().timesXY(v[i].r);
            double z = this.theCamera.getObjectToView().timesZ(v[i].r);
            this.renderBox((int)p.x - 2, (int)p.y - 2, 5, 5, z, lineColor);
        }
        Color col = this.currentTool.hilightSelection() ? highlightColor : lineColor;
        for (int i2 = 0; i2 < v.length; ++i2) {
            if (!selected[i2] || !(this.theCamera.getObjectToView().timesZ(v[i2].r) > this.theCamera.getClipDistance())) continue;
            Vec2 p = this.theCamera.getObjectToScreen().timesXY(v[i2].r);
            double z = this.theCamera.getObjectToView().timesZ(v[i2].r);
            this.renderBox((int)p.x - 2, (int)p.y - 2, 5, 5, z, col);
        }
    }

    @Override
    protected void mousePressed(WidgetMouseEvent e) {
        int y;
        int x;
        Vec2 pos;
        int i;
        boolean wantHandleClicks;
        MeshVertex[] v = ((Curve)this.getController().getObject().getObject()).getVertices();
        this.requestFocus();
        this.sentClick = false;
        this.deselect = -1;
        this.dragging = false;
        this.clickPoint = e.getPoint();
        this.activeTool = this.metaTool != null && UIUtilities.mouseButtonThree(e) ? this.metaTool : (this.altTool != null && UIUtilities.mouseButtonTwo(e) ? this.altTool : this.currentTool);
        if ((this.activeTool.whichClicks() & 1) != 0) {
            this.activeTool.mousePressed(e, this);
            this.dragging = true;
            this.sentClick = true;
        }
        boolean allowSelectionChange = this.activeTool.allowSelectionChanges();
        boolean bl = wantHandleClicks = (this.activeTool.whichClicks() & 4) != 0;
        if (!allowSelectionChange && !wantHandleClicks) {
            return;
        }
        Point p = e.getPoint();
        boolean[] selected = this.controller.getSelection();
        for (i = 0; i < v.length; ++i) {
            if (!selected[i]) continue;
            pos = this.theCamera.getObjectToScreen().timesXY(v[i].r);
            x = (int)pos.x;
            y = (int)pos.y;
            if (x >= p.x - 2 && x <= p.x + 2 && y >= p.y - 2 && y <= p.y + 2) break;
        }
        if (i < v.length) {
            if (e.isShiftDown() && allowSelectionChange) {
                this.deselect = i;
            }
            if (wantHandleClicks) {
                this.activeTool.mousePressedOnHandle(e, this, 0, i);
                this.sentClick = true;
            }
            return;
        }
        int j = -1;
        double nearest = Double.MAX_VALUE;
        for (i = 0; i < v.length; ++i) {
            double z;
            pos = this.theCamera.getObjectToScreen().timesXY(v[i].r);
            x = (int)pos.x;
            y = (int)pos.y;
            if (x < p.x - 2 || x > p.x + 2 || y < p.y - 2 || y > p.y + 2 || !((z = this.theCamera.getObjectToView().timesZ(v[i].r)) > 0.0) || !(z < nearest)) continue;
            nearest = z;
            j = i;
        }
        if (j > -1) {
            if (allowSelectionChange) {
                boolean[] oldSelection = (boolean[])selected.clone();
                if (!e.isShiftDown()) {
                    for (i = 0; i < selected.length; ++i) {
                        selected[i] = false;
                    }
                }
                selected[j] = true;
                ((CurveEditorWindow)this.controller).findSelectionDistance();
                this.currentTool.getWindow().setUndoRecord(new UndoRecord(this.currentTool.getWindow(), false, 15, new Object[]{this.controller, this.controller.getSelectionMode(), oldSelection}));
                this.controller.setSelection(selected);
                this.activeTool.getWindow().updateMenus();
            }
            if (e.isShiftDown()) {
                this.repaint();
            } else if (wantHandleClicks) {
                this.activeTool.mousePressedOnHandle(e, this, 0, j);
                this.sentClick = true;
            }
            return;
        }
        if (allowSelectionChange) {
            this.draggingSelectionBox = true;
            this.beginDraggingSelection(p, false);
        }
    }

    @Override
    protected void mouseDragged(WidgetMouseEvent e) {
        if (!this.dragging) {
            Point p = e.getPoint();
            if (Math.abs(p.x - this.clickPoint.x) < 2 && Math.abs(p.y - this.clickPoint.y) < 2) {
                return;
            }
        }
        this.dragging = true;
        this.deselect = -1;
        super.mouseDragged(e);
    }

    @Override
    protected void mouseReleased(WidgetMouseEvent e) {
        int i;
        MeshVertex[] v = ((Curve)this.getController().getObject().getObject()).getVertices();
        this.moveToGrid(e);
        this.endDraggingSelection();
        boolean[] selected = this.controller.getSelection();
        boolean[] oldSelection = (boolean[])selected.clone();
        if (this.draggingSelectionBox && !e.isShiftDown() && !e.isControlDown()) {
            for (i = 0; i < selected.length; ++i) {
                selected[i] = false;
            }
        }
        if (this.selectBounds != null) {
            boolean newsel = !e.isControlDown();
            for (i = 0; i < v.length; ++i) {
                Vec2 pos = this.theCamera.getObjectToScreen().timesXY(v[i].r);
                int x = (int)pos.x;
                int y = (int)pos.y;
                if (!this.selectionRegionContains(new Point(x, y))) continue;
                selected[i] = newsel;
            }
        }
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        if (this.sentClick) {
            if (!this.dragging) {
                Point p = e.getPoint();
                e.translatePoint(this.clickPoint.x - p.x, this.clickPoint.y - p.y);
            }
            this.activeTool.mouseReleased(e, this);
        }
        if (this.deselect > -1) {
            selected[this.deselect] = false;
        }
        ((CurveEditorWindow)this.controller).findSelectionDistance();
        for (int k = 0; k < selected.length; ++k) {
            if (selected[k] == oldSelection[k]) continue;
            this.currentTool.getWindow().setUndoRecord(new UndoRecord(this.currentTool.getWindow(), false, 15, new Object[]{this.controller, this.controller.getSelectionMode(), oldSelection}));
            break;
        }
        this.controller.setSelection(selected);
        this.activeTool.getWindow().updateMenus();
    }
}

