/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.LayoutWindow;
import artofillusion.MeshEditorWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Compound3DManipulator;
import artofillusion.ui.EditingTool;
import artofillusion.ui.Translate;
import buoy.event.KeyPressedEvent;
import buoy.event.ToolTipEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BToolTip;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public class MoveScaleRotateObjectTool
extends EditingTool {
    private boolean dragInProgress;
    private boolean draggingObjects;
    private ArrayList<ObjectInfo> objects;
    private CoordinateSystem[] originalCoords;
    private Object3D[] originalObjects;
    private ObjectInfo clickedObject;
    private Point clickPoint;
    private Vec3[] rotationCenter;
    private UndoRecord undo;
    private final Compound3DManipulator manipulator;
    private boolean tooltipsEnabled;
    private boolean tooltipsAdded;
    private boolean applyToChildren = true;
    private int scaleAround = 0;
    private int rotateAround = 1;
    private static BToolTip ROTATE_TIP = new BToolTip(Translate.text("moveScaleRotateObjectTool.rotateTipText"));
    private static BToolTip MOVE_TIP = new BToolTip(Translate.text("moveScaleRotateObjectTool.moveTipText"));
    private static BToolTip SCALE_TIP = new BToolTip(Translate.text("moveScaleRotateObjectTool.scaleTipText"));
    private static final int POSITIONS_FIXED = 0;
    private static final int POSITIONS_SCALE = 1;
    private static final int OBJECT_CENTER = 0;
    private static final int PARENT_CENTER = 1;
    private static final int SELECTION_CENTER = 2;

    public MoveScaleRotateObjectTool(LayoutWindow fr) {
        super(fr);
        this.initButton("moveScaleRotate");
        this.manipulator = new Compound3DManipulator();
        this.manipulator.addEventLink(Compound3DManipulator.HandlePressedEvent.class, (Object)this, "handlePressed");
        this.manipulator.addEventLink(Compound3DManipulator.HandleDraggedEvent.class, (Object)this, "handleDragged");
        this.manipulator.addEventLink(Compound3DManipulator.HandleReleasedEvent.class, (Object)this, "handleReleased");
    }

    @Override
    public int whichClicks() {
        return 3;
    }

    @Override
    public boolean allowSelectionChanges() {
        return !this.dragInProgress;
    }

    @Override
    public String getToolTipText() {
        return Translate.text("moveScaleRotateObjectTool.tipText");
    }

    @Override
    public LayoutWindow getWindow() {
        return (LayoutWindow)this.theWindow;
    }

    @Override
    public void drawOverlay(ViewerCanvas view) {
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        if (!this.dragInProgress && this.manipulator.getViewMode() == Compound3DManipulator.NPQ_MODE && selectionBounds != null) {
            ObjectInfo firstObj = this.getWindow().getSelectedObjects().iterator().next();
            CoordinateSystem coords = firstObj.getCoords();
            this.manipulator.setNPQAxes(coords.getUpDirection().cross(coords.getZDirection()), coords.getUpDirection(), coords.getZDirection());
        }
        this.manipulator.draw(view, selectionBounds);
        if (!this.dragInProgress) {
            if (selectionBounds != null) {
                this.theWindow.setHelpText(Translate.text("moveScaleRotateObjectTool.helpText"));
            } else {
                this.theWindow.setHelpText(Translate.text("moveScaleRotateObjectTool.errorText"));
            }
        }
    }

    @Override
    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        this.dragInProgress = false;
        this.draggingObjects = false;
        if (selectionBounds != null) {
            this.dragInProgress = this.manipulator.mousePressed(e, view, selectionBounds);
        }
    }

    @Override
    public void mousePressedOnObject(WidgetMouseEvent e, ViewerCanvas view, int obj) {
        this.draggingObjects = true;
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        Rectangle screenBounds = this.manipulator.findScreenBounds(selectionBounds, view.getCamera());
        Compound3DManipulator compound3DManipulator = this.manipulator;
        compound3DManipulator.getClass();
        this.handlePressed(new Compound3DManipulator.HandlePressedEvent(compound3DManipulator, view, Compound3DManipulator.MOVE, Compound3DManipulator.ALL, screenBounds, selectionBounds, e));
        this.clickedObject = view.getScene().getObject(obj);
        this.clickPoint = e.getPoint();
    }

    @Override
    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        if (this.draggingObjects) {
            BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
            Rectangle screenBounds = this.manipulator.findScreenBounds(selectionBounds, view.getCamera());
            Point dragPoint = e.getPoint();
            int dx = dragPoint.x - this.clickPoint.x;
            int dy = dragPoint.y - this.clickPoint.y;
            if (e.isShiftDown() && !e.isControlDown()) {
                if (Math.abs(dx) > Math.abs(dy)) {
                    dy = 0;
                } else {
                    dx = 0;
                }
            }
            Vec3 v = e.isControlDown() ? view.getCamera().getCameraCoordinates().getZDirection().times((double)(-dy) * 0.01) : view.getCamera().findDragVector(this.clickedObject.getCoords().getOrigin(), dx, dy);
            Compound3DManipulator compound3DManipulator = this.manipulator;
            compound3DManipulator.getClass();
            this.handleDragged(new Compound3DManipulator.HandleDraggedEvent(compound3DManipulator, view, Compound3DManipulator.MOVE, Compound3DManipulator.ALL, screenBounds, selectionBounds, e, Mat4.translation(v.x, v.y, v.z)));
        } else {
            this.manipulator.mouseDragged(e, view);
        }
    }

    @Override
    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        if (this.draggingObjects) {
            this.handleReleased(null);
        } else {
            this.manipulator.mouseReleased(e, view);
        }
    }

    protected void handlePressed(Compound3DManipulator.HandlePressedEvent ev) {
        int i;
        this.objects = new ArrayList();
        int[] sel = this.applyToChildren ? this.getWindow().getSelectionWithChildren() : this.getWindow().getSelectedIndices();
        for (i = 0; i < sel.length; ++i) {
            this.objects.add(this.theWindow.getScene().getObject(sel[i]));
        }
        this.originalCoords = new CoordinateSystem[this.objects.size()];
        for (i = 0; i < this.originalCoords.length; ++i) {
            this.originalCoords[i] = this.objects.get(i).getCoords();
        }
        if (ev.getHandleType() == Compound3DManipulator.SCALE) {
            this.originalObjects = new Object3D[this.objects.size()];
            for (i = 0; i < this.originalObjects.length; ++i) {
                this.originalObjects[i] = this.objects.get(i).getObject();
            }
        }
        if (ev.getHandleType() == Compound3DManipulator.ROTATE) {
            this.manipulator.setRotateAroundSelectionCenter(this.rotateAround == 2);
            this.rotationCenter = new Vec3[this.objects.size()];
            for (i = 0; i < this.rotationCenter.length; ++i) {
                ObjectInfo parent = this.objects.get(i);
                this.rotationCenter[i] = this.rotateAround == 2 ? new Vec3() : this.originalCoords[i].getOrigin();
                if (this.rotateAround != 1) continue;
                while (parent.getParent() != null) {
                    parent = parent.getParent();
                    if (!parent.selected) continue;
                    this.rotationCenter[i] = parent.getCoords().getOrigin();
                }
            }
        }
    }

    protected void handleDragged(Compound3DManipulator.HandleDraggedEvent ev) {
        if (this.undo == null) {
            this.undo = new UndoRecord(this.theWindow, false);
            for (int i = 0; i < this.originalCoords.length; ++i) {
                this.originalCoords[i] = this.originalCoords[i].duplicate();
                this.undo.addCommand(1, new Object[]{this.objects.get(i).getCoords(), this.originalCoords[i]});
                if (ev.getHandleType() != Compound3DManipulator.SCALE) continue;
                this.originalObjects[i] = this.originalObjects[i].duplicate();
                this.undo.addCommand(0, new Object[]{this.objects.get(i).getObject(), this.originalObjects[i]});
            }
        }
        this.transformObjects(ev);
        this.theWindow.setModified();
        this.theWindow.updateImage();
        if (ev.getHandleType() == Compound3DManipulator.MOVE) {
            Vec3 drag = ev.getTransform().times(new Vec3());
            this.theWindow.setHelpText(Translate.text("reshapeMeshTool.dragText", (Object)((double)Math.round(drag.x * 100000.0) / 100000.0 + ", " + (double)Math.round(drag.y * 100000.0) / 100000.0 + ", " + (double)Math.round(drag.z * 100000.0) / 100000.0)));
        } else if (ev.getHandleType() == Compound3DManipulator.ROTATE) {
            this.theWindow.setHelpText(Translate.text("rotateMeshTool.dragText", (Object)Double.toString((double)Math.round(ev.getRotationAngle() * 100000.0 * 180.0 / Math.PI) / 100000.0)));
        } else if (ev.getAxis() == Compound3DManipulator.UV && !ev.getMouseEvent().isShiftDown()) {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", (Object)((double)Math.round(ev.getPrimaryScale() * 100000.0) / 100000.0 + ", " + (double)Math.round(ev.getSecondaryScale() * 100000.0) / 100000.0)));
        } else {
            this.theWindow.setHelpText(Translate.text("scaleMeshTool.dragText", (Object)Double.toString((double)Math.round(ev.getPrimaryScale() * 100000.0) / 100000.0)));
        }
    }

    protected void handleReleased(Compound3DManipulator.HandleReleasedEvent ev) {
        if (this.undo != null) {
            this.theWindow.setUndoRecord(this.undo);
        }
        this.theWindow.updateImage();
        this.undo = null;
        this.rotationCenter = null;
        this.dragInProgress = false;
    }

    private void transformObjects(Compound3DManipulator.HandleDraggedEvent ev) {
        for (int i = 0; i < this.objects.size(); ++i) {
            Mat4 transform = ev.getTransform();
            if (ev.getHandleType() == Compound3DManipulator.SCALE) {
                if (this.scaleAround == 1) {
                    CoordinateSystem coords = this.originalCoords[i].duplicate();
                    coords.transformOrigin(transform);
                    this.objects.get(i).getCoords().copyCoords(coords);
                }
                double xscale = 1.0;
                double yscale = 1.0;
                double zscale = 1.0;
                Vec3 xdir = this.originalCoords[i].fromLocal().timesDirection(transform.timesDirection(new Vec3(1.0, 0.0, 0.0)));
                Vec3 ydir = this.originalCoords[i].fromLocal().timesDirection(transform.timesDirection(new Vec3(0.0, 1.0, 0.0)));
                Vec3 zdir = this.originalCoords[i].fromLocal().timesDirection(transform.timesDirection(new Vec3(0.0, 0.0, 1.0)));
                xdir.normalize();
                ydir.normalize();
                zdir.normalize();
                if (ev.getMouseEvent().isShiftDown()) {
                    yscale = zscale = ev.getPrimaryScale();
                    xscale = zscale;
                } else if (ev.getAxis() == Compound3DManipulator.UV) {
                    Vec3 uDir = this.manipulator.getAxisDirection(Compound3DManipulator.U, ev.getView());
                    Vec3 vDir = this.manipulator.getAxisDirection(Compound3DManipulator.V, ev.getView());
                    double xudot = Math.abs(xdir.dot(uDir));
                    double yudot = Math.abs(ydir.dot(uDir));
                    double zudot = Math.abs(zdir.dot(uDir));
                    double xvdot = Math.abs(xdir.dot(vDir));
                    double yvdot = Math.abs(ydir.dot(vDir));
                    double zvdot = Math.abs(zdir.dot(vDir));
                    if (xudot >= yudot && xudot >= zudot) {
                        xscale = ev.getPrimaryScale();
                        if (yvdot >= zvdot) {
                            yscale = ev.getSecondaryScale();
                        } else {
                            zscale = ev.getSecondaryScale();
                        }
                    } else if (yudot >= xudot && yudot >= zudot) {
                        yscale = ev.getPrimaryScale();
                        if (xvdot >= zvdot) {
                            xscale = ev.getSecondaryScale();
                        } else {
                            zscale = ev.getSecondaryScale();
                        }
                    } else {
                        zscale = ev.getPrimaryScale();
                        if (xvdot >= yvdot) {
                            xscale = ev.getSecondaryScale();
                        } else {
                            yscale = ev.getSecondaryScale();
                        }
                    }
                } else {
                    Vec3 scaleDir = this.manipulator.getAxisDirection(ev.getAxis(), ev.getView());
                    double xdot = Math.abs(xdir.dot(scaleDir));
                    double ydot = Math.abs(ydir.dot(scaleDir));
                    double zdot = Math.abs(zdir.dot(scaleDir));
                    if (xdot >= ydot && xdot >= zdot) {
                        xscale = ev.getPrimaryScale();
                    } else if (ydot >= xdot && ydot >= zdot) {
                        yscale = ev.getPrimaryScale();
                    } else {
                        zscale = ev.getPrimaryScale();
                    }
                }
                Vec3 size = this.originalObjects[i].getBounds().getSize();
                size.x *= xscale;
                size.y *= yscale;
                size.z *= zscale;
                this.objects.get(i).getObject().setSize(size.x, size.y, size.z);
                this.getWindow().getScene().objectModified(this.objects.get(i).getObject());
                continue;
            }
            if (ev.getHandleType() == Compound3DManipulator.ROTATE) {
                Vec3 center = this.rotationCenter[i];
                transform = Mat4.translation(center.x, center.y, center.z).times(transform.times(Mat4.translation(-center.x, -center.y, -center.z)));
            }
            CoordinateSystem coords = this.originalCoords[i].duplicate();
            coords.transformCoordinates(transform);
            this.objects.get(i).getCoords().copyCoords(coords);
        }
    }

    @Override
    public void keyPressed(KeyPressedEvent e, ViewerCanvas view) {
        int i;
        Vec3 v;
        double dy;
        double dx;
        if (e.getKeyCode() == 87 && e.getModifiersEx() == 0) {
            Compound3DManipulator.ViewMode mode = this.manipulator.getViewMode();
            if (mode == Compound3DManipulator.XYZ_MODE) {
                this.manipulator.setViewMode(Compound3DManipulator.UV_MODE);
            } else if (mode == Compound3DManipulator.UV_MODE) {
                this.manipulator.setViewMode(Compound3DManipulator.NPQ_MODE);
            } else {
                this.manipulator.setViewMode(Compound3DManipulator.XYZ_MODE);
            }
            this.theWindow.updateImage();
            return;
        }
        if (e.getKeyCode() == 112) {
            boolean bl = this.tooltipsEnabled = !this.tooltipsEnabled;
            if (this.tooltipsEnabled && !this.tooltipsAdded) {
                ViewerCanvas[] allViews = ((MeshEditorWindow)this.theWindow).getAllViews();
                for (int i2 = 0; i2 < allViews.length; ++i2) {
                    allViews[i2].addEventLink(ToolTipEvent.class, (Object)this, "showToolTip");
                }
                this.tooltipsAdded = true;
            }
            if (!this.tooltipsEnabled) {
                BToolTip.hide();
            }
            return;
        }
        int key = e.getKeyCode();
        if (key == 38) {
            dx = 0.0;
            dy = -1.0;
        } else if (key == 40) {
            dx = 0.0;
            dy = 1.0;
        } else if (key == 37) {
            dx = -1.0;
            dy = 0.0;
        } else if (key == 39) {
            dx = 1.0;
            dy = 0.0;
        } else {
            return;
        }
        e.consume();
        int[] sel = this.applyToChildren ? this.getWindow().getSelectionWithChildren() : this.getWindow().getSelectedIndices();
        if (sel.length == 0) {
            return;
        }
        if (view.getSnapToGrid()) {
            double scale = view.getGridSpacing() * view.getScale();
            if (!e.isAltDown()) {
                scale /= (double)view.getSnapToSubdivisions();
            }
            dx *= scale;
            dy *= scale;
        } else if (e.isAltDown()) {
            dx *= 10.0;
            dy *= 10.0;
        }
        Camera cam = view.getCamera();
        CoordinateSystem cameraCoords = cam.getCameraCoordinates();
        Scene theScene = this.theWindow.getScene();
        if (e.isControlDown()) {
            v = cameraCoords.getZDirection().times(-dy * 0.01);
        } else {
            Vec3 origin = theScene.getObject(sel[0]).getCoords().getOrigin();
            if (Math.abs(origin.minus(cameraCoords.getOrigin()).dot(cameraCoords.getZDirection())) < 1.0E-10) {
                origin = origin.plus(cameraCoords.getZDirection().times(cam.getClipDistance()));
            }
            v = cam.findDragVector(origin, dx, dy);
        }
        this.undo = new UndoRecord(this.getWindow(), false);
        this.theWindow.setUndoRecord(this.undo);
        ArrayList<ObjectInfo> toMove = new ArrayList<ObjectInfo>();
        for (i = 0; i < sel.length; ++i) {
            toMove.add(theScene.getObject(sel[i]));
        }
        for (i = 0; i < toMove.size(); ++i) {
            CoordinateSystem c = ((ObjectInfo)toMove.get(i)).getCoords();
            this.undo.addCommand(1, new Object[]{c, c.duplicate()});
            c.setOrigin(c.getOrigin().plus(v));
        }
        this.theWindow.getScene().applyTracksAfterModification(toMove);
        this.theWindow.updateImage();
        this.undo = null;
    }

    private void showToolTip(ToolTipEvent ev) {
        if (!this.tooltipsEnabled) {
            return;
        }
        ViewerCanvas view = (ViewerCanvas)ev.getWidget();
        Compound3DManipulator.HandleType type = this.manipulator.getHandleTypeAtLocation(ev.getPoint(), view, this.findSelectionBounds(view.getCamera()));
        if (type == Compound3DManipulator.MOVE) {
            MOVE_TIP.processEvent(ev);
        } else if (type == Compound3DManipulator.ROTATE) {
            ROTATE_TIP.processEvent(ev);
        } else if (type == Compound3DManipulator.SCALE) {
            SCALE_TIP.processEvent(ev);
        } else {
            BToolTip.hide();
        }
    }

    protected BoundingBox findSelectionBounds(Camera cam) {
        boolean anything = false;
        BoundingBox bounds = null;
        for (ObjectInfo info : this.getWindow().getSelectedObjects()) {
            BoundingBox objBounds = info.getBounds().transformAndOutset(info.getCoords().fromLocal());
            bounds = !anything ? objBounds : bounds.merge(objBounds);
            anything = true;
        }
        return bounds == null ? null : bounds.transformAndOutset(cam.getWorldToView());
    }

    @Override
    public void iconDoubleClicked() {
        BCheckBox childrenBox = new BCheckBox(Translate.text("applyToUnselectedChildren"), this.applyToChildren);
        BComboBox centerChoice = new BComboBox(new String[]{Translate.text("individualObjectCenters"), Translate.text("parentObject"), Translate.text("centerOfSelection")});
        centerChoice.setSelectedIndex(this.rotateAround);
        RowContainer rotateRow = new RowContainer();
        rotateRow.add(Translate.label("rotateAround"));
        rotateRow.add(centerChoice);
        BComboBox scaleChoice = new BComboBox(new String[]{Translate.text("remainFixed"), Translate.text("scaleWithObjects")});
        scaleChoice.setSelectedIndex(this.scaleAround);
        RowContainer scaleRow = new RowContainer();
        scaleRow.add(Translate.label("objectPositions"));
        scaleRow.add(scaleChoice);
        ComponentsDialog dlg = new ComponentsDialog(this.theFrame, Translate.text("moveRotateResizeToolTitle"), new Widget[]{childrenBox, rotateRow, scaleRow}, new String[]{null, null, null});
        if (!dlg.clickedOk()) {
            return;
        }
        this.applyToChildren = childrenBox.getState();
        this.rotateAround = centerChoice.getSelectedIndex();
        this.scaleAround = scaleChoice.getSelectedIndex();
    }
}

