/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.Camera;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.WidgetMouseEvent;
import java.awt.Point;
import java.awt.Rectangle;

public class MoveViewTool
extends EditingTool {
    private Point clickPoint;
    private Mat4 viewToWorld;
    private Vec3 clickPos;
    private Vec3 oldRotCenter;
    private Vec3 oldCamPos;
    private boolean controlDown;
    private CoordinateSystem oldCoords;
    private double oldScale;
    private double oldDist;
    private int selectedNavigation;

    public MoveViewTool(EditingWindow fr) {
        super(fr);
        this.initButton("moveView");
    }

    @Override
    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("moveViewTool.helpText"));
    }

    @Override
    public int whichClicks() {
        return 1;
    }

    @Override
    public boolean hilightSelection() {
        return true;
    }

    @Override
    public String getToolTipText() {
        return Translate.text("moveViewTool.tipText");
    }

    @Override
    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        Camera cam = view.getCamera();
        this.controlDown = e.isControlDown();
        this.selectedNavigation = view.getNavigationMode();
        this.clickPoint = e.getPoint();
        this.clickPos = cam.convertScreenToWorld(this.clickPoint, view.getDistToPlane());
        this.oldCoords = cam.getCameraCoordinates().duplicate();
        this.oldCamPos = this.oldCoords.getOrigin();
        this.oldRotCenter = new Vec3(view.getRotationCenter());
        this.oldScale = view.getScale();
        this.oldDist = view.getDistToPlane();
        view.setRotationCenter(this.oldCoords.getOrigin().plus(this.oldCoords.getZDirection().times(this.oldDist)));
        if (this.theWindow != null && this.theWindow.getToolPalette().getSelectedTool() == this && UIUtilities.mouseButtonOne(e)) {
            if (view.getNavigationMode() > 3) {
                view.setNavigationMode(0);
            } else if (view.getNavigationMode() > 1) {
                view.setNavigationMode(view.getNavigationMode() - 2, true);
            }
        }
        view.mouseDown = true;
        view.moving = true;
    }

    @Override
    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        if (this.theWindow != null && this.theWindow.getToolPalette().getSelectedTool() == this && UIUtilities.mouseButtonOne(e)) {
            this.dragMoveModel(e, view);
        } else {
            switch (view.getNavigationMode()) {
                case 0: 
                case 1: {
                    this.dragMoveModel(e, view);
                    break;
                }
                case 2: 
                case 3: {
                    this.dragMoveTravel(e, view);
                    break;
                }
            }
        }
        if (view.getBoundCamera() != null) {
            view.getBoundCamera().getCoords().copyCoords(view.getCamera().getCameraCoordinates());
        }
        view.frustumShape.update();
        if (ArtOfIllusion.getPreferences().getDrawActiveFrustum() || ArtOfIllusion.getPreferences().getDrawCameraFrustum() && view.getBoundCamera() != null) {
            this.theWindow.updateImage();
        } else {
            view.repaint();
        }
        view.viewChanged(false);
    }

    private void dragMoveTravel(WidgetMouseEvent e, ViewerCanvas view) {
        Camera cam = view.getCamera();
        CoordinateSystem coords = this.oldCoords.duplicate();
        Point dragPoint = e.getPoint();
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (this.controlDown) {
            Vec3 hDir;
            if (view.getNavigationMode() == 3) {
                hDir = new Vec3(coords.getZDirection().x, 0.0, coords.getZDirection().z);
                hDir.normalize();
            } else {
                hDir = coords.getZDirection();
            }
            Vec3 newPos = this.oldCamPos.plus(hDir.times((double)(-dy) * 0.04 * this.oldDist / cam.getDistToScreen()));
            coords.setOrigin(newPos);
            cam.setCameraCoordinates(coords);
            view.setRotationCenter(newPos.plus(coords.getZDirection().times(this.oldDist)));
        } else {
            if (e.isShiftDown()) {
                if (Math.abs(dx) > Math.abs(dy)) {
                    dy = 0;
                } else {
                    dx = 0;
                }
            }
            Vec3 vDir = view.getNavigationMode() == 3 ? new Vec3(0.0, 1.0, 0.0) : coords.getUpDirection();
            Vec3 hMove = cam.findDragVector(this.clickPos, (double)dx, 0.0);
            Mat4 m = Mat4.translation(-hMove.x, 0.0, -hMove.z);
            coords.transformOrigin(m);
            Vec3 newPos = coords.getOrigin().plus(vDir.times((double)dy * 0.01 * view.getDistToPlane() / cam.getDistToScreen()));
            coords.setOrigin(newPos);
            cam.setCameraCoordinates(coords);
            view.setRotationCenter(newPos.plus(coords.getZDirection().times(view.getDistToPlane())));
        }
    }

    private void dragMoveModel(WidgetMouseEvent e, ViewerCanvas view) {
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (this.controlDown) {
            double newDist;
            Rectangle bounds = view.getBounds();
            if (view.isPerspective()) {
                newDist = this.oldDist * Math.pow(0.9900990099009901, dy);
            } else {
                double newScale = this.oldScale * Math.pow(1.01, dy);
                view.setScale(newScale);
                cam.setScreenParamsParallel(newScale, bounds.width, bounds.height);
                newDist = cam.getDistToScreen() * 100.0 / newScale;
            }
            view.setDistToPlane(newDist);
            CoordinateSystem coords = view.getCamera().getCameraCoordinates();
            Vec3 newPos = view.getRotationCenter().plus(coords.getZDirection().times(-newDist));
            coords.setOrigin(newPos);
            view.getCamera().setCameraCoordinates(coords);
        } else {
            if (e.isShiftDown()) {
                if (Math.abs(dx) > Math.abs(dy)) {
                    dy = 0;
                } else {
                    dx = 0;
                }
            }
            Vec3 move = cam.findDragVector(this.clickPos, dx, dy);
            if (view.isPerspective()) {
                move = move.times(this.oldDist / view.getDistToPlane());
            }
            Mat4 m = Mat4.translation(-move.x, -move.y, -move.z);
            CoordinateSystem newCoords = this.oldCoords.duplicate();
            newCoords.transformOrigin(m);
            cam.setCameraCoordinates(newCoords);
            view.setRotationCenter(newCoords.getOrigin().plus(newCoords.getZDirection().times(this.oldDist)));
        }
    }

    @Override
    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        view.mouseDown = false;
        view.moving = false;
        view.setNavigationMode(this.selectedNavigation);
        if (this.theWindow != null) {
            ObjectInfo bound = view.getBoundCamera();
            if (bound != null) {
                bound.getCoords().copyCoords(view.getCamera().getCameraCoordinates());
                UndoRecord undo = new UndoRecord(this.theWindow, false, 1, new Object[]{bound.getCoords(), this.oldCoords});
                this.moveChildren(bound, bound.getCoords().fromLocal().times(this.oldCoords.toLocal()), undo);
                this.theWindow.setUndoRecord(undo);
            }
            this.theWindow.updateImage();
        }
        view.viewChanged(false);
    }

    private void moveChildren(ObjectInfo parent, Mat4 transform, UndoRecord undo) {
        for (int i = 0; i < parent.getChildren().length; ++i) {
            CoordinateSystem coords = parent.getChildren()[i].getCoords();
            CoordinateSystem oldCoords = coords.duplicate();
            coords.transformCoordinates(transform);
            undo.addCommand(1, new Object[]{coords, oldCoords});
            this.moveChildren(parent.getChildren()[i], transform, undo);
        }
    }
}

