/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.LayoutWindow;
import artofillusion.ListChangeListener;
import artofillusion.PluginRegistry;
import artofillusion.Property;
import artofillusion.Scene;
import artofillusion.SceneChangedEvent;
import artofillusion.UndoRecord;
import artofillusion.material.Material;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.Texture;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.PropertyEditor;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSelector;
import buoy.event.FocusLostEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WidgetEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.BTextField;
import buoy.widget.ColumnContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;

public class ObjectPropertiesPanel
extends ColumnContainer {
    private LayoutWindow window;
    private BTextField nameField;
    private ValueField xPosField;
    private ValueField yPosField;
    private ValueField zPosField;
    private ValueField xRotField;
    private ValueField yRotField;
    private ValueField zRotField;
    private BComboBox textureChoice;
    private BComboBox materialChoice;
    private PropertyEditor[] propEditor;
    private ObjectInfo[] objects;
    private Property[] properties;
    private Object3D[] previousObjects;
    private boolean ignoreNextChange;
    private Widget lastEventSource;
    private ActionProcessor paramChangeProcessor;

    public ObjectPropertiesPanel(LayoutWindow window) {
        this.window = window;
        this.nameField = new BTextField();
        this.xPosField = new ValueField(0.0, 0, 1);
        this.yPosField = new ValueField(0.0, 0, 1);
        this.zPosField = new ValueField(0.0, 0, 1);
        this.xRotField = new ValueField(0.0, 0, 1);
        this.yRotField = new ValueField(0.0, 0, 1);
        this.zRotField = new ValueField(0.0, 0, 1);
        this.textureChoice = new BComboBox();
        this.materialChoice = new BComboBox();
        this.paramChangeProcessor = new ActionProcessor();
        this.rebuildContents();
        window.addEventLink(SceneChangedEvent.class, (Object)this, "rebuildContents");
        this.nameField.addEventLink(FocusLostEvent.class, (Object)this, "nameChanged");
        this.nameField.addEventLink(KeyPressedEvent.class, (Object)this, "nameChanged");
        this.xPosField.addEventLink(ValueChangedEvent.class, (Object)this, "coordinatesChanged");
        this.yPosField.addEventLink(ValueChangedEvent.class, (Object)this, "coordinatesChanged");
        this.zPosField.addEventLink(ValueChangedEvent.class, (Object)this, "coordinatesChanged");
        this.xRotField.addEventLink(ValueChangedEvent.class, (Object)this, "coordinatesChanged");
        this.yRotField.addEventLink(ValueChangedEvent.class, (Object)this, "coordinatesChanged");
        this.zRotField.addEventLink(ValueChangedEvent.class, (Object)this, "coordinatesChanged");
        this.textureChoice.addEventLink(ValueChangedEvent.class, (Object)this, "textureChanged");
        this.materialChoice.addEventLink(ValueChangedEvent.class, (Object)this, "materialChanged");
        ListChangeListener listener = new ListChangeListener(){

            @Override
            public void itemAdded(int index, Object obj) {
                ObjectPropertiesPanel.this.rebuildContents();
            }

            @Override
            public void itemRemoved(int index, Object obj) {
                ObjectPropertiesPanel.this.rebuildContents();
            }

            @Override
            public void itemChanged(int index, Object obj) {
                ObjectPropertiesPanel.this.rebuildContents();
            }
        };
        window.getScene().addTextureListener(listener);
        window.getScene().addMaterialListener(listener);
    }

    protected void rebuildContents() {
        int i;
        if (this.ignoreNextChange) {
            this.ignoreNextChange = false;
            return;
        }
        if (this.lastEventSource == this.nameField) {
            this.nameChanged(new FocusLostEvent(this.nameField, false));
        }
        Scene scene = this.window.getScene();
        int[] sel = this.window.getSelectedIndices();
        this.objects = new ObjectInfo[sel.length];
        for (int i2 = 0; i2 < sel.length; ++i2) {
            this.objects[i2] = scene.getObject(sel[i2]);
        }
        boolean objectsChanged = this.previousObjects == null || this.objects.length != this.previousObjects.length;
        for (i = 0; i < this.objects.length && !objectsChanged; objectsChanged |= this.objects[i].getObject() != this.previousObjects[i], ++i) {
        }
        if (objectsChanged) {
            this.previousObjects = new Object3D[this.objects.length];
            for (i = 0; i < this.objects.length; ++i) {
                this.previousObjects[i] = this.objects[i].getObject();
            }
        }
        if (this.objects.length == 0) {
            if (objectsChanged) {
                this.removeAll();
                this.add(Translate.label("noObjectsSelected"));
                UIUtilities.applyDefaultBackground(this);
                UIUtilities.applyDefaultFont(this);
                if (this.getParent() != null) {
                    this.getParent().layoutChildren();
                }
                this.repaint();
            }
            return;
        }
        if (this.objects.length == 1) {
            this.nameField.setText(this.objects[0].getName());
        }
        Vec3 origin = this.objects[0].getCoords().getOrigin();
        this.xPosField.setValue(origin.x);
        this.yPosField.setValue(origin.y);
        this.zPosField.setValue(origin.z);
        double[] angles = this.objects[0].getCoords().getRotationAngles();
        this.xRotField.setValue(angles[0]);
        this.yRotField.setValue(angles[1]);
        this.zRotField.setValue(angles[2]);
        for (int i3 = 1; i3 < this.objects.length; ++i3) {
            origin = this.objects[i3].getCoords().getOrigin();
            this.checkFieldValue(this.xPosField, origin.x);
            this.checkFieldValue(this.yPosField, origin.y);
            this.checkFieldValue(this.zPosField, origin.z);
            angles = this.objects[i3].getCoords().getRotationAngles();
            this.checkFieldValue(this.xRotField, angles[0]);
            this.checkFieldValue(this.yRotField, angles[1]);
            this.checkFieldValue(this.zRotField, angles[2]);
        }
        Texture tex = this.objects[0].getObject().getTexture();
        boolean canSetTexture = this.objects[0].getObject().canSetTexture();
        boolean sameTexture = true;
        for (int i4 = 1; i4 < this.objects.length; ++i4) {
            Texture thisTex = this.objects[i4].getObject().getTexture();
            if (thisTex != tex) {
                sameTexture = false;
            }
            canSetTexture &= this.objects[i4].getObject().canSetTexture();
        }
        if (canSetTexture) {
            Vector<String> names = new Vector<String>();
            int selected = -1;
            for (int i5 = 0; i5 < scene.getNumTextures(); ++i5) {
                names.add(scene.getTexture(i5).getName());
                if (scene.getTexture(i5) != tex) continue;
                selected = i5;
            }
            if (!sameTexture) {
                selected = names.size();
                names.add("");
            } else if (tex instanceof LayeredTexture) {
                selected = names.size();
                names.add(Translate.text("layeredTexture"));
            }
            for (Texture texture : PluginRegistry.getPlugins(Texture.class)) {
                try {
                    Method mtd = texture.getClass().getMethod("getTypeName", new Class[0]);
                    names.add(Translate.text("newTextureOfType", mtd.invoke(null, null)));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.textureChoice.setModel(new DefaultComboBoxModel(names));
            this.textureChoice.setSelectedIndex(selected);
        }
        Material mat = this.objects[0].getObject().getMaterial();
        boolean canSetMaterial = this.objects[0].getObject().canSetMaterial();
        boolean sameMaterial = true;
        for (int i6 = 1; i6 < this.objects.length; ++i6) {
            Material thisMat = this.objects[i6].getObject().getMaterial();
            if (thisMat != mat) {
                sameMaterial = false;
            }
            canSetMaterial &= this.objects[i6].getObject().canSetMaterial();
        }
        if (canSetMaterial) {
            Vector<String> names = new Vector<String>();
            int selected = -1;
            for (int i7 = 0; i7 < scene.getNumMaterials(); ++i7) {
                names.add(scene.getMaterial(i7).getName());
                if (scene.getMaterial(i7) != mat) continue;
                selected = i7;
            }
            if (!sameMaterial) {
                selected = names.size();
                names.add("");
            } else if (mat == null) {
                selected = names.size();
            }
            names.add(Translate.text("none"));
            List<Material> materialTypes = PluginRegistry.getPlugins(Material.class);
            for (Material material : materialTypes) {
                try {
                    Method mtd = material.getClass().getMethod("getTypeName", new Class[0]);
                    names.add(Translate.text("newMaterialOfType", mtd.invoke(null, null)));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.materialChoice.setModel(new DefaultComboBoxModel(names));
            this.materialChoice.setSelectedIndex(selected);
        }
        Property[] oldProperties = this.properties;
        this.findProperties();
        boolean propertiesChanged = oldProperties == null || this.properties.length != oldProperties.length;
        for (int i8 = 0; i8 < this.properties.length && !propertiesChanged; ++i8) {
            propertiesChanged = !this.properties[i8].equals(oldProperties[i8]);
        }
        if (!objectsChanged && !propertiesChanged) {
            this.showParameterValues();
            return;
        }
        this.lastEventSource = null;
        this.removeAll();
        LayoutInfo fillLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(2, 2, 2, 2), null);
        if (this.objects.length == 1) {
            this.add(Translate.label("Name"));
            this.add(this.nameField, fillLayout);
        }
        this.add(Translate.label("Position"));
        FormContainer positions = new FormContainer(new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 1.0}, new double[1]);
        positions.add(new BLabel("X"), 0, 0);
        positions.add(this.xPosField, 1, 0, fillLayout);
        positions.add(new BLabel(" Y"), 2, 0);
        positions.add(this.yPosField, 3, 0, fillLayout);
        positions.add(new BLabel(" Z"), 4, 0);
        positions.add(this.zPosField, 5, 0, fillLayout);
        this.add(positions, fillLayout);
        this.add(Translate.label("Orientation"));
        FormContainer orientation = new FormContainer(new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 1.0}, new double[1]);
        orientation.add(new BLabel("X"), 0, 0);
        orientation.add(this.xRotField, 1, 0, fillLayout);
        orientation.add(new BLabel(" Y"), 2, 0);
        orientation.add(this.yRotField, 3, 0, fillLayout);
        orientation.add(new BLabel(" Z"), 4, 0);
        orientation.add(this.zRotField, 5, 0, fillLayout);
        this.add(orientation, fillLayout);
        if (canSetTexture) {
            this.add(Translate.label("Texture"));
            this.add(this.textureChoice, fillLayout);
        }
        if (canSetMaterial) {
            this.add(Translate.label("Material"));
            this.add(this.materialChoice, fillLayout);
        }
        LayoutInfo centerLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(2, 2, 2, 2), null);
        this.propEditor = new PropertyEditor[this.properties.length];
        for (int i9 = 0; i9 < this.propEditor.length; ++i9) {
            this.propEditor[i9] = new PropertyEditor(this.properties[i9], null);
            if (this.propEditor[i9].getLabel() != null) {
                this.add(new BLabel(this.propEditor[i9].getLabel()));
            }
            Widget widget = this.propEditor[i9].getWidget();
            widget.addEventLink(ValueChangedEvent.class, (Object)this, "parameterChanged");
            if (widget instanceof ValueSelector || widget instanceof BCheckBox || widget instanceof ValueField) {
                this.add(widget, centerLayout);
                continue;
            }
            this.add(widget, fillLayout);
        }
        this.showParameterValues();
        UIUtilities.applyDefaultBackground(this);
        UIUtilities.applyDefaultFont(this);
        if (this.getParent() != null) {
            this.getParent().layoutChildren();
        }
        this.repaint();
    }

    private void checkFieldValue(ValueField field, double value) {
        if (field.getValue() != value) {
            field.setValue(Double.NaN);
        }
    }

    private void findProperties() {
        this.properties = this.objects[0].getObject().getProperties();
        for (int i = 1; i < this.objects.length; ++i) {
            Property[] otherProperty = this.objects[i].getObject().getProperties();
            boolean same = this.properties.length == otherProperty.length;
            for (int j = 0; j < this.properties.length && same; ++j) {
                if (this.properties[j].equals(otherProperty[j])) continue;
                same = false;
            }
            if (same) continue;
            this.properties = new Property[0];
            return;
        }
    }

    private void showParameterValues() {
        int i;
        if (this.propEditor == null) {
            return;
        }
        Object[] values = new Object[this.propEditor.length];
        for (i = 0; i < values.length; ++i) {
            values[i] = this.objects[0].getObject().getPropertyValue(i);
        }
        for (i = 1; i < this.objects.length; ++i) {
            for (int j = 0; j < values.length; ++j) {
                if (values[j] == null || values[j].equals(this.objects[i].getObject().getPropertyValue(j))) continue;
                values[j] = null;
            }
        }
        for (i = 0; i < this.propEditor.length; ++i) {
            this.propEditor[i].setValue(values[i]);
        }
    }

    private void coordinatesChanged(ValueChangedEvent ev) {
        int i;
        UndoRecord undo = null;
        if (ev.getWidget() != this.lastEventSource) {
            this.ignoreNextChange = true;
            undo = new UndoRecord(this.window, false);
            for (i = 0; i < this.objects.length; ++i) {
                undo.addCommand(1, new Object[]{this.objects[i].getCoords(), this.objects[i].getCoords().duplicate()});
            }
        }
        for (i = 0; i < this.objects.length; ++i) {
            CoordinateSystem coords = this.objects[i].getCoords();
            Vec3 origin = coords.getOrigin();
            origin.x = this.getNewValue(origin.x, this.xPosField.getValue());
            origin.y = this.getNewValue(origin.y, this.yPosField.getValue());
            origin.z = this.getNewValue(origin.z, this.zPosField.getValue());
            coords.setOrigin(origin);
            double[] angles = coords.getRotationAngles();
            angles[0] = this.getNewValue(angles[0], this.xRotField.getValue());
            angles[1] = this.getNewValue(angles[1], this.yRotField.getValue());
            angles[2] = this.getNewValue(angles[2], this.zRotField.getValue());
            coords.setOrientation(angles[0], angles[1], angles[2]);
        }
        this.window.getScene().applyTracksAfterModification(Arrays.asList(this.objects));
        this.lastEventSource = ev.getWidget();
        if (undo != null) {
            this.window.setUndoRecord(undo);
        } else {
            this.window.setModified();
        }
        this.window.updateImage();
    }

    private double getNewValue(double oldval, double newval) {
        return Double.isNaN(newval) ? oldval : newval;
    }

    private void nameChanged(WidgetEvent ev) {
        this.lastEventSource = ev.getWidget();
        if (ev instanceof KeyPressedEvent && ((KeyPressedEvent)ev).getKeyCode() != 10) {
            return;
        }
        if (this.objects.length == 0 || this.objects[0].getName().equals(this.nameField.getText())) {
            return;
        }
        int which = this.window.getScene().indexOf(this.objects[0]);
        this.window.setUndoRecord(new UndoRecord(this.window, false, 6, new Object[]{which, this.objects[0].getName()}));
        this.window.setObjectName(which, this.nameField.getText());
        if (ev instanceof KeyPressedEvent) {
            this.window.getView().requestFocus();
        }
    }

    private void textureChanged() {
        int index = this.textureChoice.getSelectedIndex();
        Scene scene = this.window.getScene();
        Texture tex = null;
        if (index < scene.getNumTextures()) {
            tex = scene.getTexture(index);
        } else {
            List<Texture> textureTypes = PluginRegistry.getPlugins(Texture.class);
            if (index < scene.getNumTextures() + textureTypes.size()) {
                try {
                    tex = (Texture)textureTypes.get(index - scene.getNumTextures()).getClass().newInstance();
                    int j = 0;
                    String name = "";
                    while (scene.getTexture(name = "Untitled " + ++j) != null) {
                    }
                    tex.setName(name);
                    scene.addTexture(tex);
                    tex.edit(this.window, scene);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (tex != null) {
            UndoRecord undo = new UndoRecord(this.window, false);
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i].getObject().getTexture() == tex) continue;
                undo.addCommand(0, new Object[]{this.objects[i].getObject(), this.objects[i].getObject().duplicate()});
                this.objects[i].setTexture(tex, tex.getDefaultMapping(this.objects[i].getObject()));
            }
            this.window.setUndoRecord(undo);
            this.window.updateImage();
            this.window.getScore().tracksModified(false);
        }
    }

    private void materialChanged() {
        boolean noMaterial;
        int index = this.materialChoice.getSelectedIndex();
        Scene scene = this.window.getScene();
        Material mat = null;
        boolean bl = noMaterial = index == scene.getNumMaterials();
        if (index < scene.getNumMaterials()) {
            mat = scene.getMaterial(index);
        } else if (index > scene.getNumMaterials()) {
            List<Material> materialTypes = PluginRegistry.getPlugins(Material.class);
            try {
                mat = (Material)materialTypes.get(index - scene.getNumMaterials() - 1).getClass().newInstance();
                int j = 0;
                String name = "";
                while (scene.getMaterial(name = "Untitled " + ++j) != null) {
                }
                mat.setName(name);
                scene.addMaterial(mat);
                mat.edit(this.window, scene);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (noMaterial || mat != null) {
            UndoRecord undo = new UndoRecord(this.window, false);
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i].getObject().getMaterial() == mat) continue;
                undo.addCommand(0, new Object[]{this.objects[i].getObject(), this.objects[i].getObject().duplicate()});
                this.objects[i].setMaterial(mat, noMaterial ? null : mat.getDefaultMapping(this.objects[i].getObject()));
            }
            this.window.setUndoRecord(undo);
            this.window.updateImage();
            this.window.getScore().tracksModified(false);
        }
    }

    private void parameterChanged(final ValueChangedEvent ev) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ObjectPropertiesPanel.this.processParameterChange(ev);
            }
        };
        if (ev.isInProgress()) {
            this.paramChangeProcessor.addEvent(r);
        } else {
            EventQueue.invokeLater(r);
        }
    }

    private void processParameterChange(ValueChangedEvent ev) {
        UndoRecord undo = null;
        if (ev.getWidget() != this.lastEventSource) {
            this.ignoreNextChange = true;
            undo = new UndoRecord(this.window, false);
            for (int i = 0; i < this.objects.length; ++i) {
                undo.addCommand(0, new Object[]{this.objects[i].getObject(), this.objects[i].getObject().duplicate()});
            }
        }
        boolean changed = false;
        for (int i = 0; i < this.objects.length; ++i) {
            for (int j = 0; j < this.propEditor.length; ++j) {
                if (this.propEditor[j].getWidget() != ev.getSource()) continue;
                Object value = this.propEditor[j].getValue();
                if (this.objects[i].getObject().getPropertyValue(j).equals(value)) continue;
                this.objects[i].getObject().setPropertyValue(j, value);
                changed = true;
            }
            this.window.getScene().objectModified(this.objects[i].getObject());
        }
        this.lastEventSource = ev.getWidget();
        if (undo != null && changed) {
            this.window.setUndoRecord(undo);
        } else if (!ev.isInProgress() && changed) {
            this.window.setModified();
        }
        this.window.updateImage();
        this.window.getScore().tracksModified(false);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        return new Dimension(Math.max(pref.width, 180), Math.max(pref.height, 200));
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension();
    }
}

