/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Scene;
import artofillusion.object.ObjectInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.util.ArrayList;
import java.util.List;

public class ObjectSet {
    private String name;
    private int[] objectIDs;

    public ObjectSet(String name, int[] objectIDs) {
        this.name = name;
        this.objectIDs = (int[])objectIDs.clone();
    }

    public ObjectSet(String name, ObjectInfo[] objects) {
        this.name = name;
        this.objectIDs = new int[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            this.objectIDs[i] = objects[i].getId();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int[] getObjectIDs() {
        return (int[])this.objectIDs.clone();
    }

    public List<ObjectInfo> getObjects(Scene scene) {
        ArrayList<ObjectInfo> list = new ArrayList<ObjectInfo>();
        for (int id : this.objectIDs) {
            ObjectInfo info = scene.getObjectById(id);
            if (info == null) continue;
            list.add(info);
        }
        return list;
    }

    static {
        new Encoder().setPersistenceDelegate(ObjectSet.class, new DefaultPersistenceDelegate(new String[]{"name", "objectIDs"}));
    }
}

