/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.math.RGBColor;

public class Property {
    private String name;
    private PropertyType type;
    private double min;
    private double max;
    private Object[] allowedValues;
    private Object defaultValue;
    public static final PropertyType DOUBLE = new PropertyType();
    public static final PropertyType INTEGER = new PropertyType();
    public static final PropertyType BOOLEAN = new PropertyType();
    public static final PropertyType STRING = new PropertyType();
    public static final PropertyType COLOR = new PropertyType();
    public static final PropertyType ENUMERATION = new PropertyType();

    public Property(String name, double min, double max, double defaultValue) {
        this.name = name;
        this.min = min;
        this.max = max;
        this.defaultValue = defaultValue;
        this.type = DOUBLE;
    }

    public Property(String name, int min, int max, int value) {
        this.name = name;
        this.min = min;
        this.max = max;
        this.defaultValue = value;
        this.type = INTEGER;
    }

    public Property(String name, boolean value) {
        this.name = name;
        this.defaultValue = value;
        this.type = BOOLEAN;
    }

    public Property(String name, String defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.type = STRING;
    }

    public Property(String name, RGBColor defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue.duplicate();
        this.type = COLOR;
    }

    public Property(String name, Object[] allowedValues, Object defaultValue) {
        this.name = name;
        this.allowedValues = (Object[])allowedValues.clone();
        this.defaultValue = defaultValue;
        this.type = ENUMERATION;
    }

    public String getName() {
        return this.name;
    }

    public PropertyType getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public double getMinimum() {
        return this.min;
    }

    public double getMaximum() {
        return this.max;
    }

    public Object[] getAllowedValues() {
        return (Object[])this.allowedValues.clone();
    }

    public boolean isLegalValue(Object value) {
        if (this.type == DOUBLE) {
            if (value instanceof Double) {
                double val = (Double)value;
                return val >= this.min && val <= this.max;
            }
        } else if (this.type == INTEGER) {
            if (value instanceof Integer) {
                int val = (Integer)value;
                return (double)val >= this.min && (double)val <= this.max;
            }
        } else {
            if (this.type == BOOLEAN) {
                return value instanceof Boolean;
            }
            if (this.type == STRING) {
                return value instanceof String;
            }
            if (this.type == COLOR) {
                return value instanceof RGBColor;
            }
            if (this.type == ENUMERATION) {
                for (int i = 0; i < this.allowedValues.length; ++i) {
                    if (this.allowedValues[i] != value) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Property)) {
            return false;
        }
        Property prop = (Property)obj;
        if (prop.type != this.type || !prop.name.equals(this.name)) {
            return false;
        }
        if (this.type == BOOLEAN || this.type == STRING || this.type == COLOR) {
            return true;
        }
        if (this.type == DOUBLE || this.type == INTEGER) {
            return prop.min == this.min && prop.max == this.max;
        }
        if (prop.allowedValues.length != this.allowedValues.length) {
            return false;
        }
        for (int i = 0; i < this.allowedValues.length; ++i) {
            if (prop.allowedValues[i].equals(this.allowedValues[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.type.hashCode();
    }

    public static class PropertyType {
        private PropertyType() {
        }
    }
}

