/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.Camera;
import artofillusion.LayoutWindow;
import artofillusion.RenderListener;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.image.ComplexImage;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.object.SpotLight;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.UIUtilities;
import artofillusion.view.ViewerOrientationControl;
import buoy.event.MouseClickedEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Vector;

public class SceneViewer
extends ViewerCanvas {
    Scene theScene;
    EditingWindow parentFrame;
    private Vector<ObjectInfo> cameras;
    boolean draggingBox;
    boolean draggingSelectionBox;
    boolean squareBox;
    boolean sentClick;
    boolean dragging;
    Point clickPoint;
    Point dragPoint;
    ObjectInfo clickedObject;
    int deselect;

    public SceneViewer(Scene s, RowContainer p, EditingWindow fr) {
        this(s, p, fr, false);
    }

    public SceneViewer(Scene s, RowContainer p, EditingWindow fr, boolean forceSoftwareRendering) {
        super(ArtOfIllusion.getPreferences().getUseOpenGL() && SceneViewer.isOpenGLAvailable() && !forceSoftwareRendering);
        this.theScene = s;
        this.parentFrame = fr;
        this.addEventLink(MouseClickedEvent.class, (Object)this, "mouseClicked");
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        this.cameras = new Vector();
        this.buildChoices(p);
        this.rebuildCameraList();
        this.setRenderMode(ArtOfIllusion.getPreferences().getDefaultDisplayMode());
    }

    public EditingWindow getEditingWindow() {
        return this.parentFrame;
    }

    @Override
    public Scene getScene() {
        return this.theScene;
    }

    public void rebuildCameraList() {
        this.cameras.clear();
        this.cameras.addAll(this.theScene.getCameras());
        for (ObjectInfo info : this.theScene.getAllObjects()) {
            Object3D obj = info.getObject();
            if (!(obj instanceof DirectionalLight) && !(obj instanceof SpotLight)) continue;
            this.cameras.add(info);
        }
        for (Widget w : this.getViewerControlWidgets().values()) {
            if (!(w instanceof ViewerOrientationControl.OrientationChoice)) continue;
            ((ViewerOrientationControl.OrientationChoice)w).rebuildCameraList();
        }
    }

    public ObjectInfo[] getCameras() {
        return this.cameras.toArray(new ObjectInfo[this.cameras.size()]);
    }

    @Override
    public void setOrientation(int which) {
        super.setOrientation(which);
        if (which > 5 && which < 6 + this.cameras.size()) {
            double projectionDist;
            double workingDepth;
            ObjectInfo nextCamera = this.cameras.elementAt(which - 6);
            CoordinateSystem nextCoords = nextCamera.coords.duplicate();
            if (nextCamera.getObject() instanceof SceneCamera) {
                workingDepth = ((SceneCamera)nextCamera.getObject()).getDistToPlane();
            } else if (nextCamera.getObject() instanceof SpotLight) {
                workingDepth = ((SpotLight)nextCamera.getObject()).getDistToPlane();
            } else if (nextCamera.getObject() instanceof DirectionalLight) {
                workingDepth = ((DirectionalLight)nextCamera.getObject()).getDistToPlane();
            } else {
                return;
            }
            Vec3 nextCenter = nextCoords.getOrigin().plus(nextCoords.getZDirection().times(workingDepth));
            if (this.boundCamera != null && this.boundCamera.getObject() instanceof SceneCamera) {
                double innerAngle = (Math.PI - Math.toRadians(((SceneCamera)this.boundCamera.getObject()).getFieldOfView())) / 2.0;
                projectionDist = Math.tan(innerAngle) * (double)this.getBounds().height / 2.0 / 100.0;
            } else {
                projectionDist = this.theCamera.getDistToScreen();
            }
            double nextScale = this.perspective ? 100.0 : 100.0 * projectionDist / workingDepth;
            this.animation.start(nextCoords, nextCenter, nextScale, which, this.navigation);
        } else {
            this.boundCamera = null;
            if (which > 5) {
                this.orientation = Integer.MAX_VALUE;
            }
            this.viewChanged(false);
        }
    }

    @Override
    public void finishAnimation(int which, boolean persp, int navi) {
        if (which > 5 && which < 6 + this.cameras.size()) {
            this.boundCamera = this.cameras.elementAt(which - 6);
        }
        this.orientation = which;
        this.perspective = persp;
        this.navigation = navi;
    }

    @Override
    public double[] estimateDepthRange() {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        Mat4 toView = this.theCamera.getWorldToView();
        for (ObjectInfo info : this.theScene.getObjects()) {
            BoundingBox bounds = info.getBounds().transformAndOutset(toView.times(info.getCoords().fromLocal()));
            if (bounds.minz < min) {
                min = bounds.minz;
            }
            if (!(bounds.maxz > max)) continue;
            max = bounds.maxz;
        }
        return new double[]{min, max};
    }

    @Override
    public Vec3 getDefaultRotationCenter() {
        int[] selection = null;
        if (this.parentFrame instanceof LayoutWindow) {
            selection = ((LayoutWindow)this.parentFrame).getSelectedIndices();
        }
        if (selection == null || selection.length == 0) {
            CoordinateSystem coords = this.theCamera.getCameraCoordinates();
            double distToCenter = -coords.getZDirection().dot(coords.getOrigin());
            return coords.getOrigin().plus(coords.getZDirection().times(distToCenter));
        }
        BoundingBox bounds = null;
        for (int i = 0; i < selection.length; ++i) {
            ObjectInfo info = this.theScene.getObject(selection[i]);
            BoundingBox objBounds = info.getBounds().transformAndOutset(info.getCoords().fromLocal());
            bounds = i == 0 ? objBounds : bounds.merge(objBounds);
        }
        return bounds.getCenter();
    }

    @Override
    public void viewChanged(boolean selectionOnly) {
        super.viewChanged(selectionOnly);
        if (this.renderMode == 5 && !selectionOnly) {
            Renderer rend = ArtOfIllusion.getPreferences().getObjectPreviewRenderer();
            if (rend == null) {
                return;
            }
            this.adjustCamera(true);
            Camera cam = this.theCamera.duplicate();
            rend.configurePreview();
            Rectangle bounds = this.getBounds();
            SceneCamera sceneCamera = new SceneCamera();
            sceneCamera.setFieldOfView(Math.atan(0.5 * (double)bounds.height / cam.getViewToScreen().m33) * 360.0 / Math.PI);
            this.adjustCamera(this.isPerspective());
            RenderListener listener = new RenderListener(){

                @Override
                public void imageUpdated(Image image) {
                    SceneViewer.this.renderedImage = image;
                    SceneViewer.this.getCanvasDrawer().imageChanged(SceneViewer.this.renderedImage);
                    SceneViewer.this.repaint();
                }

                @Override
                public void statusChanged(String status) {
                }

                @Override
                public void imageComplete(ComplexImage image) {
                    SceneViewer.this.renderedImage = image.getImage();
                    SceneViewer.this.getCanvasDrawer().imageChanged(SceneViewer.this.renderedImage);
                    SceneViewer.this.repaint();
                }

                @Override
                public void renderingCanceled() {
                }
            };
            rend.renderScene(this.theScene, cam, listener, sceneCamera);
        }
    }

    @Override
    public synchronized void updateImage() {
        if (this.renderMode == 5) {
            if (this.renderedImage != null && this.renderedImage.getWidth(null) > 0) {
                this.drawImage(this.renderedImage, 0, 0);
            } else {
                this.viewChanged(false);
            }
        } else {
            super.updateImage();
            Vec3 viewdir = this.theCamera.getViewToWorld().timesDirection(Vec3.vz());
            for (ObjectInfo obj : this.theScene.getObjects()) {
                if (obj == this.boundCamera || !obj.isVisible()) continue;
                this.theCamera.setObjectTransform(obj.getCoords().fromLocal());
                obj.getObject().renderObject(obj, this, viewdir);
            }
        }
        if (this.currentTool.hilightSelection()) {
            ArrayList<Rectangle> selectedBoxes = new ArrayList<Rectangle>();
            ArrayList<Rectangle> parentSelectedBoxes = new ArrayList<Rectangle>();
            for (ObjectInfo obj : this.theScene.getObjects()) {
                ArrayList<Rectangle> boxes;
                int hsize;
                if (obj.isLocked()) continue;
                if (obj.selected) {
                    hsize = 4;
                    boxes = selectedBoxes;
                } else {
                    if (!obj.parentSelected) continue;
                    hsize = 2;
                    boxes = parentSelectedBoxes;
                }
                this.theCamera.setObjectTransform(obj.getCoords().fromLocal());
                Rectangle bounds = this.theCamera.findScreenBounds(obj.getBounds());
                if (bounds == null) continue;
                boxes.add(new Rectangle(bounds.x, bounds.y, hsize, hsize));
                boxes.add(new Rectangle(bounds.x + bounds.width - hsize + 1, bounds.y, hsize, hsize));
                boxes.add(new Rectangle(bounds.x, bounds.y + bounds.height - hsize + 1, hsize, hsize));
                boxes.add(new Rectangle(bounds.x + bounds.width - hsize + 1, bounds.y + bounds.height - hsize + 1, hsize, hsize));
                boxes.add(new Rectangle(bounds.x + (bounds.width - hsize) / 2, bounds.y, hsize, hsize));
                boxes.add(new Rectangle(bounds.x, bounds.y + (bounds.height - hsize) / 2, hsize, hsize));
                boxes.add(new Rectangle(bounds.x + (bounds.width - hsize) / 2, bounds.y + bounds.height - hsize + 1, hsize, hsize));
                boxes.add(new Rectangle(bounds.x + bounds.width - hsize + 1, bounds.y + (bounds.height - hsize) / 2, hsize, hsize));
            }
            this.drawBoxes(selectedBoxes, handleColor);
            this.drawBoxes(parentSelectedBoxes, highlightColor);
        }
        this.currentTool.drawOverlay(this);
        if (this.activeTool != null) {
            this.activeTool.drawOverlay(this);
        }
        for (ViewerCanvas v : this.parentFrame.getAllViews()) {
            v.drawOverlay(this);
        }
        if (this.showAxes) {
            this.drawCoordinateAxes();
        }
        this.drawBorder();
    }

    public void beginDraggingBox(Point p, boolean square) {
        this.draggingBox = true;
        this.clickPoint = p;
        this.squareBox = square;
        this.dragPoint = null;
    }

    @Override
    protected void mousePressed(WidgetMouseEvent e) {
        ObjectInfo info;
        int i;
        boolean wantHandleClicks;
        Rectangle bounds = null;
        this.requestFocus();
        this.sentClick = false;
        this.deselect = -1;
        this.dragging = true;
        this.clickPoint = e.getPoint();
        this.clickedObject = null;
        this.activeTool = this.metaTool != null && UIUtilities.mouseButtonThree(e) ? this.metaTool : (this.altTool != null && UIUtilities.mouseButtonTwo(e) ? this.altTool : this.currentTool);
        if ((this.activeTool.whichClicks() & 1) != 0) {
            this.moveToGrid(e);
            this.activeTool.mousePressed(e, this);
            this.sentClick = true;
        }
        boolean allowSelectionChange = this.activeTool.allowSelectionChanges();
        boolean bl = wantHandleClicks = (this.activeTool.whichClicks() & 4) != 0;
        if (!allowSelectionChange && !wantHandleClicks) {
            return;
        }
        Point p = e.getPoint();
        int[] sel = this.theScene.getSelection();
        for (i = 0; i < sel.length; ++i) {
            info = this.theScene.getObject(sel[i]);
            this.theCamera.setObjectTransform(info.getCoords().fromLocal());
            bounds = this.theCamera.findScreenBounds(info.getBounds());
            if (info.isLocked() || bounds == null || !this.pointInRectangle(p, bounds)) continue;
            this.clickedObject = info;
            break;
        }
        if (i < sel.length) {
            if (e.isShiftDown() && allowSelectionChange) {
                this.deselect = sel[i];
            }
            if ((this.activeTool.whichClicks() & 4) != 0) {
                int j = p.x <= bounds.x + 4 ? 0 : (p.x >= bounds.x + (bounds.width - 4) / 2 && p.x <= bounds.x + (bounds.width - 4) / 2 + 4 ? 1 : (p.x >= bounds.x + bounds.width - 4 ? 2 : -1));
                int k = p.y <= bounds.y + 4 ? 0 : (p.y >= bounds.y + (bounds.height - 4) / 2 && p.y <= bounds.y + (bounds.height - 4) / 2 + 4 ? 1 : (p.y >= bounds.y + bounds.height - 4 ? 2 : -1));
                if (k == 0) {
                    this.moveToGrid(e);
                    this.activeTool.mousePressedOnHandle(e, this, sel[i], j);
                    this.sentClick = true;
                    return;
                }
                if (j == 0 && k == 1) {
                    this.moveToGrid(e);
                    this.activeTool.mousePressedOnHandle(e, this, sel[i], 3);
                    this.sentClick = true;
                    return;
                }
                if (j == 2 && k == 1) {
                    this.moveToGrid(e);
                    this.activeTool.mousePressedOnHandle(e, this, sel[i], 4);
                    this.sentClick = true;
                    return;
                }
                if (k == 2) {
                    this.moveToGrid(e);
                    this.activeTool.mousePressedOnHandle(e, this, sel[i], j + 5);
                    this.sentClick = true;
                    return;
                }
            }
            this.moveToGrid(e);
            this.dragging = false;
            if ((this.activeTool.whichClicks() & 2) != 0) {
                this.activeTool.mousePressedOnObject(e, this, sel[i]);
                this.sentClick = true;
            }
            return;
        }
        if (!allowSelectionChange) {
            return;
        }
        int j = -1;
        int minarea = Integer.MAX_VALUE;
        Vec3 cameraPosition = this.theCamera.getCameraCoordinates().getOrigin();
        Vec3 cameraAxis = this.theCamera.getCameraCoordinates().getZDirection();
        for (i = 0; i < this.theScene.getNumObjects(); ++i) {
            info = this.theScene.getObject(i);
            if (!info.isVisible() || info.isLocked() || !this.inFront(info, cameraPosition, cameraAxis)) continue;
            this.theCamera.setObjectTransform(info.getCoords().fromLocal());
            bounds = this.theCamera.findScreenBounds(info.getBounds());
            if (bounds == null || !this.pointInRectangle(p, bounds) || bounds.width * bounds.height >= minarea) continue;
            j = i;
            minarea = bounds.width * bounds.height;
        }
        if (j > -1) {
            info = this.theScene.getObject(j);
            if (!e.isShiftDown()) {
                if (this.parentFrame instanceof LayoutWindow) {
                    ((LayoutWindow)this.parentFrame).clearSelection();
                } else {
                    this.theScene.clearSelection();
                }
            }
            if (this.parentFrame instanceof LayoutWindow) {
                this.parentFrame.setUndoRecord(new UndoRecord(this.parentFrame, false, 16, new Object[]{sel}));
                ((LayoutWindow)this.parentFrame).addToSelection(j);
            } else {
                this.theScene.addToSelection(j);
            }
            this.parentFrame.updateMenus();
            this.parentFrame.updateImage();
            this.moveToGrid(e);
            if ((this.activeTool.whichClicks() & 2) != 0 && !e.isShiftDown()) {
                this.sentClick = true;
                this.activeTool.mousePressedOnObject(e, this, j);
            }
            this.clickedObject = info;
            return;
        }
        if (allowSelectionChange) {
            this.moveToGrid(e);
            this.draggingSelectionBox = true;
            this.beginDraggingBox(p, false);
        }
        this.sentClick = false;
    }

    private boolean pointInRectangle(Point p, Rectangle r) {
        return r.x - 1 <= p.x && r.y - 1 <= p.y && r.x + r.width + 1 >= p.x && r.y + r.height + 1 >= p.y;
    }

    private boolean inFront(ObjectInfo info, Vec3 cameraPosition, Vec3 cameraAxis) {
        if (this.isPerspective()) {
            Vec3 difference = info.getCoords().getOrigin().minus(cameraPosition);
            double projectionDist = difference.dot(cameraAxis);
            return projectionDist > 0.0;
        }
        return true;
    }

    @Override
    protected void mouseDragged(WidgetMouseEvent e) {
        this.mousePoint = e.getPoint();
        this.moveToGrid(e);
        if (!this.dragging) {
            Point p = e.getPoint();
            if (Math.abs(p.x - this.clickPoint.x) < 2 && Math.abs(p.y - this.clickPoint.y) < 2) {
                return;
            }
        }
        this.dragging = true;
        this.deselect = -1;
        if (this.draggingBox) {
            if (this.dragPoint != null) {
                this.drawDraggedShape(new Rectangle(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y)));
            }
            this.dragPoint = e.getPoint();
            if (this.squareBox) {
                if (Math.abs(this.dragPoint.x - this.clickPoint.x) > Math.abs(this.dragPoint.y - this.clickPoint.y)) {
                    this.dragPoint.y = this.dragPoint.y < this.clickPoint.y ? this.clickPoint.y - Math.abs(this.dragPoint.x - this.clickPoint.x) : this.clickPoint.y + Math.abs(this.dragPoint.x - this.clickPoint.x);
                } else {
                    this.dragPoint.x = this.dragPoint.x < this.clickPoint.x ? this.clickPoint.x - Math.abs(this.dragPoint.y - this.clickPoint.y) : this.clickPoint.x + Math.abs(this.dragPoint.y - this.clickPoint.y);
                }
            }
            this.drawDraggedShape(new Rectangle(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y)));
        }
        if (this.sentClick) {
            this.activeTool.mouseDragged(e, this);
        }
    }

    @Override
    protected void mouseReleased(WidgetMouseEvent e) {
        int[] newSelection;
        int i;
        int[] sel = this.theScene.getSelection();
        this.moveToGrid(e);
        if (this.sentClick) {
            if (!this.dragging) {
                Point p = e.getPoint();
                e.translatePoint(this.clickPoint.x - p.x, this.clickPoint.y - p.y);
            }
            this.activeTool.mouseReleased(e, this);
        }
        int[] oldSelection = this.theScene.getSelection();
        if (this.draggingSelectionBox) {
            this.dragPoint = e.getPoint();
            Rectangle r = new Rectangle(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
            if (!e.isShiftDown()) {
                if (this.parentFrame instanceof LayoutWindow) {
                    ((LayoutWindow)this.parentFrame).clearSelection();
                } else {
                    this.theScene.clearSelection();
                }
                this.parentFrame.updateMenus();
            }
            Vec3 cameraPosition = this.theCamera.getCameraCoordinates().getOrigin();
            Vec3 cameraAxis = this.theCamera.getCameraCoordinates().getZDirection();
            for (i = 0; i < this.theScene.getNumObjects(); ++i) {
                int j;
                ObjectInfo info = this.theScene.getObject(i);
                if (!info.isVisible() || info.isLocked() || !this.inFront(info, cameraPosition, cameraAxis)) continue;
                this.theCamera.setObjectTransform(info.getCoords().fromLocal());
                Rectangle b = this.theCamera.findScreenBounds(info.getBounds());
                if (b == null || b.x >= r.x + r.width || b.y >= r.y + r.height || r.x >= b.x + b.width || r.y >= b.y + b.height) continue;
                if (!e.isShiftDown()) {
                    if (this.parentFrame instanceof LayoutWindow) {
                        ((LayoutWindow)this.parentFrame).addToSelection(i);
                    } else {
                        this.theScene.addToSelection(i);
                    }
                    this.parentFrame.updateMenus();
                    continue;
                }
                for (j = 0; j < sel.length && sel[j] != i; ++j) {
                }
                if (j != sel.length) continue;
                if (this.parentFrame instanceof LayoutWindow) {
                    ((LayoutWindow)this.parentFrame).addToSelection(i);
                } else {
                    this.theScene.addToSelection(i);
                }
                this.parentFrame.updateMenus();
            }
            if (this.currentTool.hilightSelection()) {
                this.parentFrame.updateImage();
            }
        }
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        if (this.deselect > -1) {
            if (this.parentFrame instanceof LayoutWindow) {
                ((LayoutWindow)this.parentFrame).removeFromSelection(this.deselect);
            } else {
                this.theScene.removeFromSelection(this.deselect);
            }
            this.parentFrame.updateMenus();
            this.parentFrame.updateImage();
        }
        boolean changed = oldSelection.length != (newSelection = this.theScene.getSelection()).length;
        for (i = 0; i < newSelection.length && !changed; ++i) {
            changed = oldSelection[i] != newSelection[i];
        }
        if (changed) {
            this.parentFrame.setUndoRecord(new UndoRecord(this.parentFrame, false, 16, new Object[]{oldSelection}));
        }
        this.dragging = false;
    }

    public void mouseClicked(MouseClickedEvent e) {
        if (e.getClickCount() == 2 && (this.activeTool.whichClicks() & 2) != 0 && this.clickedObject != null && this.clickedObject.getObject().isEditable()) {
            final Object3D obj = this.clickedObject.getObject();
            this.parentFrame.setUndoRecord(new UndoRecord(this.parentFrame, false, 0, new Object[]{obj, obj.duplicate()}));
            obj.edit(this.parentFrame, this.clickedObject, new Runnable(){

                @Override
                public void run() {
                    SceneViewer.this.theScene.objectModified(obj);
                    SceneViewer.this.parentFrame.updateImage();
                    SceneViewer.this.parentFrame.updateMenus();
                }
            });
        }
    }

    private void moveChildren(ObjectInfo obj, Mat4 transform, UndoRecord undo) {
        CoordinateSystem coords = obj.getCoords();
        CoordinateSystem oldCoords = coords.duplicate();
        coords.transformCoordinates(transform);
        undo.addCommand(1, new Object[]{coords, oldCoords});
        for (int i = 0; i < obj.getChildren().length; ++i) {
            this.moveChildren(obj.getChildren()[i], transform, undo);
        }
    }
}

