/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.Joint;
import artofillusion.animation.Keyframe;
import artofillusion.animation.ObjectRef;
import artofillusion.animation.ObjectRefSelector;
import artofillusion.animation.RotationKeyframe;
import artofillusion.animation.Skeleton;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.WeightTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.BTextField;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Map;

public class RotationTrack
extends Track {
    private ObjectInfo info;
    private boolean quaternion;
    private Timecourse tc;
    private int smoothingMethod;
    private int mode;
    private int relCoords;
    private int joint;
    private ObjectRef relObject;
    private WeightTrack theWeight;
    private boolean enablex;
    private boolean enabley;
    private boolean enablez;
    public static final int ABSOLUTE = 0;
    public static final int RELATIVE = 1;
    public static final int WORLD = 0;
    public static final int PARENT = 1;
    public static final int OBJECT = 2;
    public static final int LOCAL = 3;

    public RotationTrack(ObjectInfo info) {
        this(info, "Rotation", true, true, true, true);
    }

    public RotationTrack(ObjectInfo info, String name, boolean useQuaternion, boolean affectX, boolean affectY, boolean affectZ) {
        super(name);
        this.info = info;
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.tc.setSubdivideAdaptively(!useQuaternion);
        this.smoothingMethod = 2;
        this.mode = 0;
        this.relCoords = 1;
        this.relObject = new ObjectRef();
        this.theWeight = new WeightTrack(this);
        this.quaternion = useQuaternion;
        this.enablex = affectX;
        this.enabley = affectY;
        this.enablez = affectZ;
        this.joint = -1;
    }

    @Override
    public void apply(double time) {
        Joint j;
        RotationKeyframe rot = (RotationKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        double weight = this.theWeight.getWeight(time);
        if (rot == null) {
            return;
        }
        Mat4 pre = null;
        Mat4 post = null;
        if (this.relCoords == 1 && this.info.getParent() != null) {
            pre = this.info.getParent().getCoords().toLocal();
            post = this.info.getParent().getCoords().fromLocal();
        } else if (this.relCoords == 2) {
            CoordinateSystem coords = this.relObject.getCoords();
            if (coords != null) {
                pre = coords.toLocal();
                post = coords.fromLocal();
            }
        } else if (this.mode == 1 && this.relCoords == 3) {
            pre = this.info.getCoords().fromLocal();
            post = this.info.getCoords().toLocal();
        }
        rot.applyToCoordinates(this.info.getCoords(), weight, pre, post, this.mode == 1, this.enablex, this.enabley, this.enablez);
        Joint joint = j = this.joint > -1 ? this.info.getSkeleton().getJoint(this.joint) : null;
        if (j != null && this.mode == 0) {
            if (this.info.getPose() != null && !this.info.getPose().equals(this.info.getObject().getPoseKeyframe())) {
                this.info.getObject().applyPoseKeyframe(this.info.getPose());
                j = this.info.getSkeleton().getJoint(this.joint);
            }
            Mat4 m = this.info.getCoords().fromLocal().times(j.coords.toLocal().times(this.info.getCoords().toLocal()));
            this.info.getCoords().transformAxes(m);
        }
    }

    @Override
    public Track duplicate(Object obj) {
        RotationTrack t = new RotationTrack((ObjectInfo)obj);
        t.name = this.name;
        t.enabled = this.enabled;
        t.quantized = this.quantized;
        t.mode = this.mode;
        t.relCoords = this.relCoords;
        t.smoothingMethod = this.smoothingMethod;
        t.quaternion = this.quaternion;
        t.tc = this.tc.duplicate((ObjectInfo)obj);
        t.relObject = this.relObject.duplicate();
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        t.enablex = this.enablex;
        t.enabley = this.enabley;
        t.enablez = this.enablez;
        t.joint = this.joint;
        return t;
    }

    @Override
    public void copy(Track tr) {
        RotationTrack t = (RotationTrack)tr;
        this.name = t.name;
        this.enabled = t.enabled;
        this.quantized = t.quantized;
        this.mode = t.mode;
        this.relCoords = t.relCoords;
        this.smoothingMethod = t.smoothingMethod;
        this.quaternion = t.quaternion;
        this.tc = t.tc.duplicate(this.info);
        this.relObject = t.relObject.duplicate();
        this.theWeight = (WeightTrack)t.theWeight.duplicate(this);
        this.enablex = t.enablex;
        this.enabley = t.enabley;
        this.enablez = t.enablez;
        this.joint = t.joint;
    }

    @Override
    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    @Override
    public Timecourse getTimecourse() {
        return this.tc;
    }

    @Override
    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        ((RotationKeyframe)k).setUseQuaternion(this.quaternion);
        this.tc.addTimepoint(k, time, s);
    }

    @Override
    public Keyframe setKeyframe(double time, Scene sc) {
        CoordinateSystem coords;
        Joint j;
        RotationKeyframe r = null;
        CoordinateSystem c = null;
        if (this.joint > -1 && this.mode == 0 && (j = this.info.getSkeleton().getJoint(this.joint)) != null) {
            c = new ObjectRef(this.info, j).getCoords().duplicate();
        }
        if (c == null) {
            c = this.info.getCoords().duplicate();
        }
        if (this.relCoords == 1 && this.info.getParent() != null) {
            c.transformAxes(this.info.getParent().getCoords().toLocal());
            r = new RotationKeyframe(c);
        } else if (this.relCoords == 2 && (coords = this.relObject.getCoords()) != null) {
            c.transformAxes(coords.toLocal());
            r = new RotationKeyframe(c);
        }
        if (r == null) {
            r = new RotationKeyframe(c);
        }
        r.setUseQuaternion(this.quaternion);
        this.tc.addTimepoint(r, time, new Smoothness());
        return r;
    }

    @Override
    public Keyframe setKeyframeIfModified(double time, Scene sc) {
        double[] q2;
        double[] q1;
        double dot;
        CoordinateSystem coords;
        CoordinateSystem c;
        if (this.tc.getTimes().length == 0) {
            return this.setKeyframe(time, sc);
        }
        RotationKeyframe rot = (RotationKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        RotationKeyframe current = null;
        Joint j = this.joint > -1 && this.mode == 0 ? this.info.getSkeleton().getJoint(this.joint) : null;
        CoordinateSystem coordinateSystem = c = j == null ? this.info.getCoords() : new ObjectRef(this.info, j).getCoords();
        if (this.relCoords == 1 && this.info.getParent() != null) {
            c = c.duplicate();
            c.transformAxes(this.info.getParent().getCoords().toLocal());
        } else if (this.relCoords == 2 && (coords = this.relObject.getCoords()) != null) {
            c = c.duplicate();
            c.transformAxes(coords.toLocal());
        }
        current = new RotationKeyframe(c);
        if (this.quaternion ? 1.0 - (dot = (q1 = rot.getQuaternion())[0] * (q2 = current.getQuaternion())[0] + q1[1] * q2[1] + q1[2] * q2[2] + q1[3] * q2[3]) < 1.0E-10 : !(this.enablex && !(Math.abs(rot.x - current.x) < 1.0E-10) || this.enabley && !(Math.abs(rot.y - current.y) < 1.0E-10) || this.enablez && !(Math.abs(rot.z - current.z) < 1.0E-10))) {
            return null;
        }
        return this.setKeyframe(time, sc);
    }

    @Override
    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    @Override
    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    @Override
    public boolean isNullTrack() {
        return this.tc.getTimes().length == 0;
    }

    public boolean affectsX() {
        return this.enablex || this.quaternion;
    }

    public boolean affectsY() {
        return this.enabley || this.quaternion;
    }

    public boolean affectsZ() {
        return this.enablez || this.quaternion;
    }

    @Override
    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    @Override
    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo;
    }

    @Override
    public Object getParent() {
        return this.info;
    }

    @Override
    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    @Override
    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public boolean isRelative() {
        return this.mode == 1;
    }

    public void setRelative(boolean rel) {
        this.mode = rel ? 1 : 0;
    }

    public boolean getUseQuaternion() {
        return this.quaternion;
    }

    public void setUseQuaternion(boolean use) {
        Keyframe[] val = this.tc.getValues();
        this.quaternion = use;
        this.tc.setSubdivideAdaptively(!this.quaternion);
        for (int i = 0; i < val.length; ++i) {
            RotationKeyframe v = (RotationKeyframe)val[i];
            v.setUseQuaternion(use);
        }
    }

    public int getCoordinateSystem() {
        return this.relCoords;
    }

    public void setCoordinateSystem(int system) {
        this.relCoords = system;
    }

    public ObjectRef getCoordsObject() {
        return this.relObject;
    }

    public void setCoordsObject(ObjectRef obj) {
        this.relObject = obj;
        this.relCoords = 2;
    }

    public int getApplyToJoint() {
        return this.joint;
    }

    public void setApplyToJoint(int jointID) {
        this.joint = jointID;
    }

    @Override
    public String[] getValueNames() {
        return new String[]{"X Angle", "Y Angle", "Z Angle"};
    }

    @Override
    public double[] getDefaultGraphValues() {
        return this.info.getCoords().getRotationAngles();
    }

    @Override
    public double[][] getValueRange() {
        double[][] range = new double[3][2];
        for (int i = 0; i < range.length; ++i) {
            range[i][0] = -1.7976931348623157E308;
            range[i][1] = Double.MAX_VALUE;
        }
        return range;
    }

    @Override
    public ObjectInfo[] getDependencies() {
        if (this.relCoords == 2) {
            ObjectInfo relInfo = this.relObject.getObject();
            if (relInfo != null) {
                return new ObjectInfo[]{relInfo};
            }
        } else if (this.relCoords == 1 && this.info.getParent() != null) {
            return new ObjectInfo[]{this.info.getParent()};
        }
        return new ObjectInfo[0];
    }

    @Override
    public void deleteDependencies(ObjectInfo obj) {
        if (this.relObject.getObject() == obj) {
            this.relObject = new ObjectRef();
        }
    }

    @Override
    public void updateObjectReferences(Map<ObjectInfo, ObjectInfo> objectMap) {
        if (objectMap.containsKey(this.relObject.getObject())) {
            ObjectInfo newObject = objectMap.get(this.relObject.getObject());
            this.relObject = this.relObject.getJoint() == null ? new ObjectRef(newObject) : new ObjectRef(newObject, newObject.getSkeleton().getJoint(this.relObject.getJoint().id));
        }
    }

    @Override
    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(1);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.smoothingMethod);
        out.writeInt(this.mode);
        out.writeInt(this.relCoords);
        out.writeInt(this.joint);
        out.writeBoolean(this.quaternion);
        out.writeBoolean(this.enablex);
        out.writeBoolean(this.enabley);
        out.writeBoolean(this.enablez);
        out.writeInt(t.length);
        for (int i = 0; i < t.length; ++i) {
            RotationKeyframe k = (RotationKeyframe)v[i];
            out.writeDouble(t[i]);
            k.writeToStream(out);
            s[i].writeToStream(out);
        }
        if (this.relCoords == 2) {
            this.relObject.writeToStream(out);
        }
        this.theWeight.writeToStream(out, scene);
    }

    @Override
    public void initFromStream(DataInputStream in, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.smoothingMethod = in.readInt();
        this.mode = in.readInt();
        this.relCoords = in.readInt();
        this.joint = version == 0 ? -1 : in.readInt();
        this.quaternion = in.readBoolean();
        this.enablex = in.readBoolean();
        this.enabley = in.readBoolean();
        this.enablez = in.readBoolean();
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        for (int i = 0; i < keys; ++i) {
            t[i] = in.readDouble();
            RotationKeyframe k = new RotationKeyframe(in, this.info);
            k.setUseQuaternion(this.quaternion);
            v[i] = k;
            s[i] = new Smoothness(in);
        }
        this.tc = new Timecourse(v, t, s);
        this.tc.setSubdivideAdaptively(!this.quaternion);
        this.relObject = this.relCoords == 2 ? new ObjectRef(in, scene) : new ObjectRef();
        this.theWeight.initFromStream(in, scene);
    }

    @Override
    public void editKeyframe(LayoutWindow win, int which) {
        RotationKeyframe key = (RotationKeyframe)this.tc.getValues()[which];
        Smoothness s = this.tc.getSmoothness()[which];
        double time = this.tc.getTimes()[which];
        ValueField xField = new ValueField(key.x, 0, 5);
        ValueField yField = new ValueField(key.y, 0, 5);
        ValueField zField = new ValueField(key.z, 0, 5);
        ValueField timeField = new ValueField(time, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, s.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, s.getRightSmoothness());
        final BCheckBox sameBox = new BCheckBox(Translate.text("separateSmoothness"), !s.isForceSame());
        sameBox.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        s2Slider.setEnabled(sameBox.getState());
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("editKeyframe"), new Widget[]{xField, yField, zField, timeField, sameBox, new BLabel(Translate.text("Smoothness") + ':'), s1Slider, s2Slider}, new String[]{"X", "Y", "Z", Translate.text("Time"), null, null, "(" + Translate.text("left") + ")", "(" + Translate.text("right") + ")"});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.info)}));
        key.set(xField.getValue(), yField.getValue(), zField.getValue());
        if (sameBox.getState()) {
            s.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            s.setSmoothness(s1Slider.getValue());
        }
        this.moveKeyframe(which, timeField.getValue());
    }

    @Override
    public void edit(LayoutWindow win) {
        Skeleton s = this.info.getSkeleton();
        Joint[] j = s == null ? null : s.getJoints();
        BTextField nameField = new BTextField(this.getName());
        BComboBox smoothChoice = new BComboBox(new String[]{Translate.text("Discontinuous"), Translate.text("Linear"), Translate.text("Interpolating"), Translate.text("Approximating")});
        smoothChoice.setSelectedIndex(this.smoothingMethod);
        final BComboBox modeChoice = new BComboBox(new String[]{Translate.text("Absolute"), Translate.text("Relative")});
        modeChoice.setSelectedIndex(this.mode);
        final BComboBox coordsChoice = new BComboBox(new String[]{Translate.text("World"), Translate.text("Parent"), Translate.text("OtherObject")});
        if (this.mode == 1) {
            coordsChoice.add(Translate.text("Local"));
        }
        coordsChoice.setSelectedIndex(this.relCoords);
        BComboBox jointChoice = new BComboBox();
        jointChoice.add(Translate.text("objectOrigin"));
        if (j != null) {
            int i;
            for (i = 0; i < j.length; ++i) {
                jointChoice.add(j[i].name);
            }
            for (i = 0; i < j.length; ++i) {
                if (j[i].id != this.joint) continue;
                jointChoice.setSelectedIndex(i + 1);
            }
        }
        final ObjectRefSelector objSelector = new ObjectRefSelector(this.relObject, win, Translate.text("positionRelativeTo"), this.info);
        objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
        modeChoice.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                int sel = modeChoice.getSelectedIndex();
                if (sel == 0 && coordsChoice.getItemCount() == 4) {
                    coordsChoice.remove(3);
                }
                if (sel == 1 && coordsChoice.getItemCount() == 3) {
                    coordsChoice.add(Translate.text("Local"));
                }
                objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
            }
        });
        coordsChoice.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
            }
        });
        final BCheckBox isoBox = new BCheckBox(Translate.text("isotropicRotations"), this.quaternion);
        RowContainer row = new RowContainer();
        final BCheckBox xbox = new BCheckBox("X", this.enablex);
        row.add(xbox);
        final BCheckBox ybox = new BCheckBox("Y", this.enabley);
        row.add(ybox);
        final BCheckBox zbox = new BCheckBox("Z", this.enablez);
        row.add(zbox);
        isoBox.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                xbox.setEnabled(!isoBox.getState());
                ybox.setEnabled(!isoBox.getState());
                zbox.setEnabled(!isoBox.getState());
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("rotationTrackTitle"), new Widget[]{nameField, smoothChoice, modeChoice, jointChoice, coordsChoice, objSelector, isoBox, row}, new String[]{Translate.text("trackName"), Translate.text("SmoothingMethod"), Translate.text("trackMode"), Translate.text("applyTo"), Translate.text("CoordinateSystem"), "", null, Translate.text("trackAffects")});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 2, new Object[]{this.info, this.info.duplicate()}));
        this.setName(nameField.getText());
        this.smoothingMethod = smoothChoice.getSelectedIndex();
        this.mode = modeChoice.getSelectedIndex();
        this.relCoords = coordsChoice.getSelectedIndex();
        this.relObject = objSelector.getSelection();
        this.joint = jointChoice.getSelectedIndex() == 0 ? -1 : j[jointChoice.getSelectedIndex() - 1].id;
        this.setUseQuaternion(isoBox.getState());
        this.enablex = xbox.getState();
        this.enabley = ybox.getState();
        this.enablez = zbox.getState();
    }
}

