/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.animation.Keyframe;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ScalarKeyframe
implements Keyframe {
    public double val;

    public ScalarKeyframe(double d) {
        this.val = d;
    }

    @Override
    public Keyframe duplicate() {
        return new ScalarKeyframe(this.val);
    }

    @Override
    public Keyframe duplicate(Object owner) {
        return new ScalarKeyframe(this.val);
    }

    @Override
    public double[] getGraphValues() {
        return new double[]{this.val};
    }

    @Override
    public void setGraphValues(double[] values) {
        if (values.length == 1) {
            this.val = values[0];
        }
    }

    @Override
    public Keyframe blend(Keyframe o2, double weight1, double weight2) {
        return new ScalarKeyframe(weight1 * this.val + weight2 * ((ScalarKeyframe)o2).val);
    }

    @Override
    public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
        return new ScalarKeyframe(weight1 * this.val + weight2 * ((ScalarKeyframe)o2).val + weight3 * ((ScalarKeyframe)o3).val);
    }

    @Override
    public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
        return new ScalarKeyframe(weight1 * this.val + weight2 * ((ScalarKeyframe)o2).val + weight3 * ((ScalarKeyframe)o3).val + weight4 * ((ScalarKeyframe)o4).val);
    }

    @Override
    public boolean equals(Keyframe k) {
        if (!(k instanceof ScalarKeyframe)) {
            return false;
        }
        ScalarKeyframe key = (ScalarKeyframe)k;
        return key.val == this.val;
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeDouble(this.val);
    }

    public ScalarKeyframe(DataInputStream in, Object parent) throws IOException {
        this.val = in.readDouble();
    }
}

