/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import buoy.event.RepaintEvent;
import buoy.widget.CustomWidget;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.text.NumberFormat;

public class VerticalAxis
extends CustomWidget {
    private double minValue;
    private double maxValue;
    private double vscale;
    private double[] tickPos;
    private NumberFormat nf = NumberFormat.getNumberInstance();
    private boolean lineAtBottom;
    private Rectangle lastBounds;
    public static final int TICK_SIZE = 6;

    public VerticalAxis() {
        this.setGraphRange(0.0, 1.0);
        this.setPreferredSize(new Dimension(50, 0));
        this.addEventLink(RepaintEvent.class, (Object)this, "paint");
    }

    public void setGraphRange(double min, double max) {
        Rectangle dim = this.getBounds();
        this.minValue = min;
        this.maxValue = max;
        this.vscale = (double)dim.height / (max - min);
        double height = dim.height;
        if (height <= 0.0) {
            return;
        }
        double increment = Math.pow(10.0, Math.floor(Math.log(max - min) / Math.log(10.0)));
        double pixels = height * increment / (max - min);
        if (pixels < 20.0) {
            while (pixels < 20.0) {
                pixels *= 5.0;
                increment *= 5.0;
            }
        } else if ((max - min) / increment < 4.0) {
            increment *= 0.5;
        }
        double lowest = Math.ceil(min / increment) * increment;
        int num = (int)Math.ceil((max - lowest) / increment) + 1;
        this.tickPos = new double[num];
        for (int i = 0; i < num; ++i) {
            this.tickPos[i] = lowest + (double)i * increment;
        }
    }

    public void showLineAtBottom(boolean show) {
        this.lineAtBottom = show;
    }

    private void paint(RepaintEvent ev) {
        Graphics2D g = ev.getGraphics();
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int labelOffset = (fm.getMaxAscent() + fm.getMaxDescent()) / 2;
        Rectangle dim = this.getBounds();
        if (this.lastBounds == null || dim.width != this.lastBounds.width || dim.height != this.lastBounds.height) {
            this.setGraphRange(this.minValue, this.maxValue);
        }
        if (this.tickPos == null) {
            return;
        }
        if (this.tickPos.length > 1) {
            this.nf.setMaximumFractionDigits((int)Math.max(0.0, 1.0 - Math.log(this.tickPos[1] - this.tickPos[0]) / Math.log(10.0)));
        } else {
            this.nf.setMaximumFractionDigits(3);
        }
        for (int i = 0; i < this.tickPos.length; ++i) {
            int y = dim.height - (int)Math.round(this.vscale * (this.tickPos[i] - this.minValue));
            g.drawLine(dim.width - 6, y, dim.width, y);
            String s = this.nf.format(this.tickPos[i]);
            int x = dim.width - 6 - 2 - fm.stringWidth(s);
            g.drawString(s, x, y + labelOffset);
        }
        if (this.lineAtBottom) {
            g.drawLine(0, dim.height - 1, dim.width, dim.height - 1);
        }
    }
}

