/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.animation.distortion.Distortion;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;

public class TwistDistortion
extends Distortion {
    private int axis;
    private double angle;
    private Mat4 preTransform;
    private Mat4 postTransform;
    private boolean forward;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;

    public TwistDistortion(int axis, double angle, boolean forward, Mat4 preTransform, Mat4 postTransform) {
        this.axis = axis;
        this.angle = angle;
        this.forward = forward;
        this.preTransform = preTransform;
        this.postTransform = postTransform;
    }

    @Override
    public boolean isIdenticalTo(Distortion d) {
        if (!(d instanceof TwistDistortion)) {
            return false;
        }
        TwistDistortion s = (TwistDistortion)d;
        if (this.previous != null && !this.previous.isIdenticalTo(s.previous)) {
            return false;
        }
        if (this.previous == null && s.previous != null) {
            return false;
        }
        if (this.axis != s.axis || this.angle != s.angle || this.forward != s.forward) {
            return false;
        }
        if (this.preTransform == s.preTransform && this.postTransform == s.postTransform) {
            return true;
        }
        return this.preTransform != null && this.preTransform.equals(s.preTransform) && this.postTransform != null && this.postTransform.equals(s.postTransform);
    }

    @Override
    public Distortion duplicate() {
        TwistDistortion d = new TwistDistortion(this.axis, this.angle, this.forward, this.preTransform, this.postTransform);
        if (this.previous != null) {
            d.previous = this.previous.duplicate();
        }
        return d;
    }

    @Override
    public Mesh transform(Mesh obj) {
        double s;
        double c;
        int i;
        if (this.previous != null) {
            obj = this.previous.transform(obj);
        }
        Mesh newmesh = (Mesh)((Object)obj.duplicate());
        MeshVertex[] vert = newmesh.getVertices();
        Vec3[] newvert = new Vec3[vert.length];
        for (int i2 = 0; i2 < newvert.length; ++i2) {
            newvert[i2] = vert[i2].r;
            if (this.preTransform == null) continue;
            this.preTransform.transform(newvert[i2]);
        }
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int i3 = 0; i3 < newvert.length; ++i3) {
            double value = this.axis == 0 ? newvert[i3].x : (this.axis == 1 ? newvert[i3].y : newvert[i3].z);
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        if (min >= max) {
            return obj;
        }
        if (!this.forward) {
            double temp = min;
            min = max;
            max = temp;
        }
        double scale = this.angle * (Math.PI / 180);
        if (this.axis == 0) {
            for (i = 0; i < newvert.length; ++i) {
                c = Math.cos(scale * (newvert[i].x - min));
                s = Math.sin(scale * (newvert[i].x - min));
                newvert[i].set(newvert[i].x, newvert[i].y * c - newvert[i].z * s, newvert[i].y * s + newvert[i].z * c);
            }
        } else if (this.axis == 1) {
            for (i = 0; i < newvert.length; ++i) {
                c = Math.cos(scale * (newvert[i].y - min));
                s = Math.sin(scale * (newvert[i].y - min));
                newvert[i].set(newvert[i].x * c - newvert[i].z * s, newvert[i].y, newvert[i].x * s + newvert[i].z * c);
            }
        } else {
            for (i = 0; i < newvert.length; ++i) {
                c = Math.cos(scale * (newvert[i].z - min));
                s = Math.sin(scale * (newvert[i].z - min));
                newvert[i].set(newvert[i].x * c - newvert[i].y * s, newvert[i].x * s + newvert[i].y * c, newvert[i].z);
            }
        }
        if (this.postTransform != null) {
            for (i = 0; i < newvert.length; ++i) {
                this.postTransform.transform(newvert[i]);
            }
        }
        newmesh.setVertexPositions(newvert);
        return newmesh;
    }
}

