/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class ComplexImage {
    private Image img;
    private float[][] pixelData;
    private int[] intImage;
    private int width;
    private int height;
    public static final int BLUE = 1;
    public static final int GREEN = 2;
    public static final int RED = 4;
    public static final int ALPHA = 8;
    public static final int DEPTH = 16;
    public static final int OBJECT = 32;
    public static final int NOISE = 64;

    public ComplexImage(Image image) {
        this.img = image;
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.pixelData = new float[7][];
    }

    public void setComponentValues(int component, float[] values) {
        this.pixelData[this.getComponentIndex((int)component)] = values;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Image getImage() {
        return this.img;
    }

    public boolean hasFloatData(int component) {
        return this.pixelData[this.getComponentIndex(component)] != null;
    }

    public float getPixelComponent(int x, int y, int component) {
        int index = this.getComponentIndex(component);
        if (this.pixelData[index] != null) {
            return this.pixelData[index][x + y * this.width];
        }
        if (this.intImage == null) {
            try {
                PixelGrabber pg = new PixelGrabber(this.img, 0, 0, -1, -1, true);
                pg.grabPixels();
                this.intImage = (int[])pg.getPixels();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        return (float)(this.intImage[x + y * this.width] >> index * 8 & 0xFF) * 0.003921569f;
    }

    public ComplexImage duplicate() {
        ComplexImage ci = new ComplexImage(this.img.getScaledInstance(this.img.getWidth(null), -1, 8));
        ci.intImage = this.intImage;
        for (int i = 0; i < this.pixelData.length; ++i) {
            if (this.pixelData[i] == null) continue;
            ci.pixelData[i] = new float[this.pixelData[i].length];
            System.arraycopy(this.pixelData[i], 0, ci.pixelData[i], 0, this.pixelData[i].length);
        }
        return ci;
    }

    public void rebuildImage() {
        int[] newimage = new int[this.width * this.height];
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                int red = this.floatToInt(this.getPixelComponent(i, j, 4));
                int green = this.floatToInt(this.getPixelComponent(i, j, 2));
                int blue = this.floatToInt(this.getPixelComponent(i, j, 1));
                int alpha = this.floatToInt(this.getPixelComponent(i, j, 8));
                newimage[i + j * this.width] = (alpha << 24) + (red << 16) + (green << 8) + blue;
            }
        }
        this.intImage = newimage;
        MemoryImageSource imageSource = new MemoryImageSource(this.width, this.height, this.intImage, 0, this.width);
        this.img = Toolkit.getDefaultToolkit().createImage(imageSource);
    }

    private int getComponentIndex(int component) {
        int index = 0;
        while ((component >> index & 1) == 0) {
            ++index;
        }
        return index;
    }

    private int floatToInt(float f) {
        int i = (int)(f * 255.0f);
        if (i < 0) {
            i = 0;
        }
        if (i > 255) {
            i = 255;
        }
        return i;
    }
}

