/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.Scene;
import artofillusion.image.ImageMap;
import artofillusion.image.ImagesDialog;
import artofillusion.math.RGBColor;
import artofillusion.ui.ColorChooser;
import artofillusion.ui.Translate;
import buoy.event.MouseClickedEvent;
import buoy.event.RepaintEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.CustomWidget;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ImageOrColor {
    private ImageMap map;
    private RGBColor color;

    public ImageOrColor(RGBColor theColor) {
        this.color = theColor.duplicate();
    }

    public ImageOrColor(RGBColor scaleColor, ImageMap theMap) {
        this.color = scaleColor.duplicate();
        this.map = theMap;
    }

    public ImageMap getImage() {
        return this.map;
    }

    public RGBColor getColor() {
        return this.color;
    }

    public void getColor(RGBColor theColor, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        if (this.map == null) {
            theColor.copy(this.color);
        } else {
            this.map.getColor(theColor, wrapx, wrapy, x, y, xsize, ysize);
            theColor.multiply(this.color);
        }
    }

    public void getAverageColor(RGBColor theColor) {
        if (this.map == null) {
            theColor.copy(this.color);
        } else {
            theColor.setRGB(this.map.getAverageComponent(0), this.map.getAverageComponent(1), this.map.getAverageComponent(2));
            theColor.multiply(this.color);
        }
    }

    public ImageOrColor duplicate() {
        ImageOrColor copy = new ImageOrColor(this.color);
        copy.map = this.map;
        return copy;
    }

    public void copy(ImageOrColor obj) {
        this.map = obj.map;
        this.color.copy(obj.color);
    }

    public ImageOrColor(DataInputStream in, Scene theScene) throws IOException {
        int index = in.readInt();
        if (index > -1) {
            this.map = theScene.getImage(index);
        }
        this.color = new RGBColor(in);
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        if (this.map == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(theScene.indexOf(this.map));
        }
        this.color.writeToFile(out);
    }

    public Widget getEditingPanel(final WindowWidget parent, final Scene theScene) {
        final RowContainer row = new RowContainer();
        final CustomWidget preview = new CustomWidget();
        preview.setPreferredSize(new Dimension(50, 50));
        preview.addEventLink(RepaintEvent.class, new Object(){

            void processEvent(RepaintEvent ev) {
                Graphics2D g = ev.getGraphics();
                if (ImageOrColor.this.map != null) {
                    g.drawImage(ImageOrColor.this.map.getPreview(), 0, 0, null);
                } else {
                    g.drawRect(1, 1, 48, 48);
                }
            }
        });
        preview.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent(MouseClickedEvent ev) {
                ImagesDialog dlg = new ImagesDialog(parent, theScene, ImageOrColor.this.map);
                ImageOrColor.this.map = dlg.getSelection();
                preview.repaint();
                row.dispatchEvent(new ValueChangedEvent(row));
            }
        });
        final Widget colorPatch = this.color.getSample(50, 50);
        colorPatch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent(MouseClickedEvent ev) {
                new ColorChooser((Widget)parent, Translate.text("Color"), ImageOrColor.this.color);
                colorPatch.setBackground(ImageOrColor.this.color.getColor());
                colorPatch.repaint();
                row.dispatchEvent(new ValueChangedEvent(row));
            }
        });
        row.add(preview);
        row.add(colorPatch);
        return row;
    }
}

