/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image.filter;

import artofillusion.Property;
import artofillusion.Scene;
import artofillusion.image.ComplexImage;
import artofillusion.image.filter.ImageFilter;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.SceneCamera;
import artofillusion.ui.Translate;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class BlurFilter
extends ImageFilter {
    @Override
    public String getName() {
        return Translate.text("Blur");
    }

    @Override
    public void filterImage(ComplexImage image, Scene scene, SceneCamera camera, CoordinateSystem cameraPos) {
        int radius = (int)(0.5 * (Double)this.getPropertyValue(0) * (double)image.getHeight());
        if (radius < 1) {
            return;
        }
        float[] mask = this.createMask(radius);
        this.filterComponent(image, 4, radius, mask);
        this.filterComponent(image, 2, radius, mask);
        this.filterComponent(image, 1, radius, mask);
    }

    private void filterComponent(ComplexImage image, int component, int radius, float[] mask) {
        Thread currentThread = Thread.currentThread();
        int maskWidth = 2 * radius + 1;
        int width = image.getWidth();
        int height = image.getHeight();
        float[] blur = new float[width * height];
        for (int i = 0; i < width; ++i) {
            if (currentThread.isInterrupted()) {
                return;
            }
            for (int j = 0; j < height; ++j) {
                float value = image.getPixelComponent(i, j, component);
                if (value == 0.0f) continue;
                int basex = i - radius;
                int basey = j - radius;
                int xstart = basex < 0 ? -basex : 0;
                int ystart = basey < 0 ? -basey : 0;
                int xend = basex + maskWidth >= width ? width - basex : maskWidth;
                int yend = basey + maskWidth >= height ? height - basey : maskWidth;
                for (int y = ystart; y < yend; ++y) {
                    int maskBase = y * maskWidth;
                    int imageBase = basex + (basey + y) * width;
                    for (int x = xstart; x < xend; ++x) {
                        int n = imageBase + x;
                        blur[n] = blur[n] + mask[maskBase + x] * value;
                    }
                }
            }
        }
        image.setComponentValues(component, blur);
    }

    private float[] createMask(int radius) {
        int size = 2 * radius + 1;
        int radius2 = radius * radius;
        float[] mask = new float[size * size];
        for (int i = 0; i < radius; ++i) {
            for (int j = 0; j < radius; ++j) {
                float value;
                int dist2 = i * i + j * j;
                if (dist2 > radius2) continue;
                float d = (float)dist2 / (float)radius2;
                mask[radius - i + (radius - j) * size] = value = d * (d - 2.0f) + 1.0f;
                mask[radius + i + (radius - j) * size] = value;
                mask[radius - i + (radius + j) * size] = value;
                mask[radius + i + (radius + j) * size] = value;
            }
        }
        double sum = 0.0;
        for (int i = 0; i < mask.length; ++i) {
            sum += (double)mask[i];
        }
        float scale = (float)(1.0 / sum);
        int i = 0;
        while (i < mask.length) {
            int n = i++;
            mask[n] = mask[n] * scale;
        }
        return mask;
    }

    @Override
    public Property[] getProperties() {
        return new Property[]{new Property(Translate.text("Radius"), 0.0, 1.0, 0.05)};
    }

    @Override
    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeDouble(((Integer)this.getPropertyValue(0)).intValue());
    }

    @Override
    public void initFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.setPropertyValue(0, in.readDouble());
    }
}

