/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image.filter;

import artofillusion.Property;
import artofillusion.Scene;
import artofillusion.image.ComplexImage;
import artofillusion.image.filter.ImageFilter;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.SceneCamera;
import artofillusion.ui.Translate;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class NoiseReductionFilter
extends ImageFilter {
    @Override
    public String getName() {
        return Translate.text("NoiseReduction");
    }

    @Override
    public void filterImage(final ComplexImage image, Scene scene, SceneCamera camera, CoordinateSystem cameraPos) {
        int width = image.getWidth();
        int height = image.getHeight();
        float[][] cu = new float[width - 1][height];
        float[][] cv = new float[width][height - 1];
        int iterations = (Integer)this.getPropertyValue(0);
        for (int i = 0; i < iterations; ++i) {
            ConductivityFunction fn = new ConductivityFunction(){

                @Override
                public float evaluate(int x1, int y1, int x2, int y2) {
                    float object1 = image.getPixelComponent(x1, y1, 32);
                    if (object1 != image.getPixelComponent(x2, y2, 32) || object1 == 0.0f) {
                        return 0.0f;
                    }
                    float err = image.getPixelComponent(x1, y1, 64) + image.getPixelComponent(x2, y2, 64);
                    if ((double)err < 1.0E-6) {
                        return 0.0f;
                    }
                    float dred = image.getPixelComponent(x1, y1, 4) - image.getPixelComponent(x2, y2, 4);
                    float dgreen = image.getPixelComponent(x1, y1, 2) - image.getPixelComponent(x2, y2, 2);
                    float dblue = image.getPixelComponent(x1, y1, 1) - image.getPixelComponent(x2, y2, 1);
                    float d = (dred * dred + dgreen * dgreen + dblue * dblue) / err;
                    return (float)Math.exp((double)(-d) * 0.2);
                }
            };
            NoiseReductionFilter.calcConductivity(width, height, cu, cv, fn);
            NoiseReductionFilter.filterImageComponent(image, cu, cv, 4);
            NoiseReductionFilter.filterImageComponent(image, cu, cv, 2);
            NoiseReductionFilter.filterImageComponent(image, cu, cv, 1);
            NoiseReductionFilter.filterImageComponent(image, cu, cv, 64);
        }
    }

    @Override
    public int getDesiredComponents() {
        return 103;
    }

    @Override
    public Property[] getProperties() {
        return new Property[]{new Property(this.getName(), 0, Integer.MAX_VALUE, 5)};
    }

    @Override
    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(0);
        out.writeInt((Integer)this.getPropertyValue(0));
    }

    @Override
    public void initFromStream(DataInputStream in, Scene theScene) throws IOException {
        short version = in.readShort();
        if (version != 0) {
            throw new IOException("Unknown version " + version);
        }
        this.setPropertyValue(0, in.readInt());
    }

    private static void calcConductivity(int width, int height, float[][] cu, float[][] cv, ConductivityFunction fn) {
        int j;
        int i;
        for (i = 0; i < width - 1; ++i) {
            for (j = 0; j < height; ++j) {
                cu[i][j] = fn.evaluate(i, j, i + 1, j);
            }
        }
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height - 1; ++j) {
                cv[i][j] = fn.evaluate(i, j, i, j + 1);
            }
        }
    }

    private static void filterImageComponent(ComplexImage image, float[][] cu, float[][] cv, int component) {
        float diff;
        int j;
        int i;
        int width = image.getWidth();
        int height = image.getHeight();
        float[] filtered = new float[width * height];
        for (i = 0; i < width - 1; ++i) {
            for (j = 0; j < height; ++j) {
                diff = cu[i][j] * (image.getPixelComponent(i + 1, j, component) - image.getPixelComponent(i, j, component));
                int n = i + j * width;
                filtered[n] = filtered[n] + diff;
                int n2 = i + 1 + j * width;
                filtered[n2] = filtered[n2] - diff;
            }
        }
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height - 1; ++j) {
                diff = cv[i][j] * (image.getPixelComponent(i, j + 1, component) - image.getPixelComponent(i, j, component));
                int n = i + j * width;
                filtered[n] = filtered[n] + diff;
                int n3 = i + (j + 1) * width;
                filtered[n3] = filtered[n3] - diff;
            }
        }
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                int index = i + j * width;
                filtered[i + j * width] = 0.1f * filtered[index] + image.getPixelComponent(i, j, component);
            }
        }
        image.setComponentValues(component, filtered);
    }

    private static interface ConductivityFunction {
        public float evaluate(int var1, int var2, int var3, int var4);
    }
}

