/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.keystroke;

import artofillusion.ApplicationPreferences;
import artofillusion.SafeFileOutputStream;
import artofillusion.keystroke.KeystrokeRecord;
import artofillusion.script.ScriptRunner;
import artofillusion.ui.EditingWindow;
import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class KeystrokeManager {
    private static ArrayList<KeystrokeRecord> records = new ArrayList();
    private static HashMap<Integer, ArrayList<KeystrokeRecord>> keyIndex = new HashMap();
    private static final String KEYSTROKE_FILENAME = "keystrokes.xml";

    public static KeystrokeRecord[] getAllRecords() {
        return records.toArray(new KeystrokeRecord[records.size()]);
    }

    public static void setAllRecords(KeystrokeRecord[] allRecords) {
        records.clear();
        Collections.addAll(records, allRecords);
        KeystrokeManager.recordModified();
    }

    public static void addRecord(KeystrokeRecord record) {
        records.add(record);
        KeystrokeManager.recordModified();
    }

    public static void removeRecord(KeystrokeRecord record) {
        records.remove(record);
        KeystrokeManager.recordModified();
    }

    public static void recordModified() {
        keyIndex = null;
    }

    public static void executeKeystrokes(KeyEvent event, EditingWindow window) {
        ArrayList<KeystrokeRecord> list;
        if (keyIndex == null) {
            keyIndex = new HashMap(records.size());
            for (KeystrokeRecord record : records) {
                ArrayList<KeystrokeRecord> list2 = keyIndex.get(record.getKeyCode());
                if (list2 == null) {
                    list2 = new ArrayList(1);
                    keyIndex.put(record.getKeyCode(), list2);
                }
                list2.add(record);
            }
        }
        if ((list = keyIndex.get(event.getKeyCode())) == null) {
            return;
        }
        for (KeystrokeRecord record : list) {
            if (record.getModifiers() != event.getModifiers()) continue;
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("window", window);
            ScriptRunner.executeScript(record.getLanguage(), record.getScript(), variables);
            event.consume();
        }
    }

    public static void loadRecords() {
        try {
            File dir = ApplicationPreferences.getPreferencesDirectory();
            File inputFile = new File(dir, KEYSTROKE_FILENAME);
            InputStream in = inputFile.exists() ? new BufferedInputStream(new FileInputStream(inputFile)) : KeystrokeManager.class.getResourceAsStream("/keystrokes.xml");
            KeystrokeManager.addRecordsFromXML(in);
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void addRecordsFromXML(InputStream in) throws Exception {
        HashMap<String, KeystrokeRecord> existing = new HashMap<String, KeystrokeRecord>();
        for (KeystrokeRecord record : records) {
            existing.put(record.getName(), record);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(in);
        NodeList keystrokes = doc.getElementsByTagName("keystroke");
        for (int i = 0; i < keystrokes.getLength(); ++i) {
            Node keystroke = keystrokes.item(i);
            String name = keystroke.getAttributes().getNamedItem("name").getNodeValue();
            String language = keystroke.getAttributes().getNamedItem("language") == null ? "BeanShell" : keystroke.getAttributes().getNamedItem("language").getNodeValue();
            int code = Integer.parseInt(keystroke.getAttributes().getNamedItem("code").getNodeValue());
            int modifiers = Integer.parseInt(keystroke.getAttributes().getNamedItem("modifiers").getNodeValue());
            String script = keystroke.getFirstChild().getNodeValue();
            if (existing.containsKey(name)) {
                records.remove(existing.get(name));
            }
            KeystrokeManager.addRecord(new KeystrokeRecord(code, modifiers, name, script, language));
        }
    }

    public static void saveRecords() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElement("keystrokes");
        doc.appendChild(root);
        for (KeystrokeRecord record : records) {
            Element recordElement = doc.createElement("keystroke");
            recordElement.setAttribute("name", record.getName());
            recordElement.setAttribute("language", record.getLanguage());
            recordElement.setAttribute("code", Integer.toString(record.getKeyCode()));
            recordElement.setAttribute("modifiers", Integer.toString(record.getModifiers()));
            Text scriptElement = doc.createTextNode(record.getScript());
            recordElement.appendChild(scriptElement);
            root.appendChild(recordElement);
        }
        File dir = ApplicationPreferences.getPreferencesDirectory();
        File outFile = new File(dir, KEYSTROKE_FILENAME);
        BufferedOutputStream out = new BufferedOutputStream(new SafeFileOutputStream(outFile, 0));
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(out);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        ((OutputStream)out).close();
    }
}

