/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.material;

import artofillusion.MaterialPreviewer;
import artofillusion.Scene;
import artofillusion.image.ImageMap;
import artofillusion.material.Material;
import artofillusion.material.Material3D;
import artofillusion.material.MaterialSpec;
import artofillusion.math.RGBColor;
import artofillusion.procedural.ColorModule;
import artofillusion.procedural.ImageModule;
import artofillusion.procedural.Link;
import artofillusion.procedural.Module;
import artofillusion.procedural.NumberModule;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.Procedure;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.procedural.ProcedureOwner;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSelector;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BDialog;
import buoy.widget.BorderContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ProceduralMaterial3D
extends Material3D
implements ProcedureOwner {
    private Procedure proc;
    private boolean shadows;
    private double stepSize;
    private double antialiasing;
    private ThreadLocal renderingProc;

    public ProceduralMaterial3D() {
        this.proc = this.createProcedure();
        this.shadows = true;
        this.stepSize = 0.1;
        this.antialiasing = 1.0;
        this.initThreadLocal();
    }

    private Procedure createProcedure() {
        return new Procedure(new OutputModule[]{new OutputModule(Translate.text("EmissiveColor"), Translate.text("black"), 0.0, new RGBColor(0.0f, 0.0f, 0.0f), 1), new OutputModule(Translate.text("TransparentColor"), Translate.text("white"), 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule(Translate.text("ScatteringColor"), Translate.text("gray"), 0.0, new RGBColor(0.5f, 0.5f, 0.5f), 1), new OutputModule(Translate.text("Transparency"), "0.5", 0.5, null, 0), new OutputModule(Translate.text("Scattering"), "0", 0.0, null, 0), new OutputModule(Translate.text("Density"), "1.0", 1.0, null, 0), new OutputModule(Translate.text("Eccentricity"), "0", 0.0, null, 0)});
    }

    private void initThreadLocal() {
        this.renderingProc = new ThreadLocal(){

            protected Object initialValue() {
                Procedure localProc = ProceduralMaterial3D.this.createProcedure();
                localProc.copy(ProceduralMaterial3D.this.proc);
                return localProc;
            }
        };
    }

    public static String getTypeName() {
        return "Procedural";
    }

    @Override
    public double getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(double step) {
        this.stepSize = step;
    }

    @Override
    public void getMaterialSpec(MaterialSpec spec, double x, double y, double z, double xsize, double ysize, double zsize, double t) {
        Procedure pr = (Procedure)this.renderingProc.get();
        OutputModule[] output = pr.getOutputModules();
        PointInfo info = new PointInfo();
        info.x = x;
        info.y = y;
        info.z = z;
        info.xsize = xsize * this.stepSize;
        info.ysize = ysize * this.stepSize;
        info.zsize = zsize * this.stepSize;
        info.t = t;
        info.param = null;
        pr.initForPoint(info);
        double density = output[5].getAverageValue(0, 0.0);
        double eccentricity = output[6].getAverageValue(0, 0.0);
        if (density < 0.0) {
            density = 0.0;
        }
        if (density > 1.0) {
            density = 1.0;
        }
        if (eccentricity < -1.0) {
            eccentricity = -1.0;
        }
        if (eccentricity > 1.0) {
            eccentricity = 1.0;
        }
        spec.eccentricity = eccentricity;
        output[0].getColor(0, spec.color, 0.0);
        if (density == 0.0) {
            spec.transparency.setRGB(1.0f, 1.0f, 1.0f);
            spec.scattering.setRGB(0.0f, 0.0f, 0.0f);
            return;
        }
        double scattering = output[4].getAverageValue(0, 0.0);
        if (scattering < 0.0) {
            scattering = 0.0;
        }
        if (scattering > 1.0) {
            scattering = 1.0;
        }
        output[1].getColor(0, spec.transparency, 0.0);
        spec.transparency.scale(output[3].getAverageValue(0, 0.0));
        double tr = spec.transparency.getRed();
        double tg = spec.transparency.getGreen();
        double tb = spec.transparency.getBlue();
        if (tr < 0.0) {
            tr = 0.0;
        }
        if (tg < 0.0) {
            tg = 0.0;
        }
        if (tb < 0.0) {
            tb = 0.0;
        }
        spec.transparency.setRGB((float)Math.pow(tr, density), (float)Math.pow(tg, density), (float)Math.pow(tb, density));
        output[2].getColor(0, spec.scattering, 0.0);
        spec.scattering.scale(density * scattering);
    }

    @Override
    public boolean usesImage(ImageMap image) {
        Module[] modules = this.proc.getModules();
        for (int i = 0; i < modules.length; ++i) {
            if (!(modules[i] instanceof ImageModule) || ((ImageModule)modules[i]).getMap() != image) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isScattering() {
        OutputModule[] output = this.proc.getOutputModules();
        return output[4].inputConnected(0);
    }

    @Override
    public boolean castsShadows() {
        return this.shadows;
    }

    @Override
    public Material duplicate() {
        ProceduralMaterial3D mat = new ProceduralMaterial3D();
        mat.proc.copy(this.proc);
        mat.setName(this.getName());
        mat.setIndexOfRefraction(this.indexOfRefraction());
        mat.shadows = this.shadows;
        mat.antialiasing = this.antialiasing;
        mat.stepSize = this.stepSize;
        return mat;
    }

    @Override
    public void edit(WindowWidget fr, Scene sc) {
        new ProcedureEditor(this.proc, this, sc);
    }

    public ProceduralMaterial3D(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.setName(in.readUTF());
        this.proc = this.createProcedure();
        this.setIndexOfRefraction(in.readDouble());
        this.shadows = in.readBoolean();
        this.antialiasing = in.readDouble();
        this.stepSize = in.readDouble();
        this.proc.readFromStream(in, theScene);
        if (version == 0) {
            OutputModule[] output = this.proc.getOutputModules();
            Module[] fromModule = new Module[output.length];
            int[] fromIndex = new int[output.length];
            for (int i = 0; i < output.length; ++i) {
                fromModule[i] = output[i].linkFrom[0];
                fromIndex[i] = output[i].linkFromIndex[0];
            }
            Link[] link = this.proc.getLinks();
            for (int i = link.length - 1; i >= 0; --i) {
                if (!(link[i].to.getModule() instanceof OutputModule)) continue;
                this.proc.deleteLink(i);
            }
            int[] newIndex = new int[]{0, 1, 5, 4, 2, 6};
            for (int i = 0; i < fromModule.length; ++i) {
                if (fromModule[i] == null) continue;
                this.proc.addLink(new Link(fromModule[i].getOutputPorts()[fromIndex[i]], output[newIndex[i]].getInputPorts()[0]));
            }
            if (!output[0].inputConnected(0)) {
                this.linkModuleToOutput(new ColorModule(new Point(800, 10), new RGBColor(1.0f, 1.0f, 1.0f)), output[0]);
            }
            if (output[1].inputConnected(0)) {
                this.linkModuleToOutput(new NumberModule(new Point(800, 115), 1.0), output[3]);
            }
            if (!output[5].inputConnected(0)) {
                this.linkModuleToOutput(new NumberModule(new Point(800, 185), 0.5), output[5]);
            }
        }
        this.initThreadLocal();
    }

    private void linkModuleToOutput(Module module, OutputModule output) {
        this.proc.addModule(module);
        this.proc.addLink(new Link(module.getOutputPorts()[0], output.getInputPorts()[0]));
    }

    @Override
    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(1);
        out.writeUTF(this.getName());
        out.writeDouble(this.indexOfRefraction());
        out.writeBoolean(this.shadows);
        out.writeDouble(this.antialiasing);
        out.writeDouble(this.stepSize);
        this.proc.writeToStream(out, theScene);
    }

    @Override
    public String getWindowTitle() {
        return "Procedural Material";
    }

    @Override
    public Object getPreview(ProcedureEditor editor) {
        BDialog dlg = new BDialog(editor.getParentFrame(), "Preview", false);
        BorderContainer content = new BorderContainer();
        final MaterialPreviewer preview = new MaterialPreviewer(null, this, 200, 160);
        content.add(preview, BorderContainer.CENTER);
        RowContainer row = new RowContainer();
        content.add(row, BorderContainer.SOUTH, new LayoutInfo());
        row.add(Translate.label("Time", ":"));
        final ValueSelector value = new ValueSelector(0.0, -1.7976931348623157E308, Double.MAX_VALUE, 0.01);
        final ActionProcessor processor = new ActionProcessor();
        row.add(value);
        value.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                processor.addEvent(new Runnable(){

                    @Override
                    public void run() {
                        preview.getScene().setTime(value.getValue());
                        preview.render();
                    }
                });
            }
        });
        dlg.setContent(content);
        dlg.pack();
        Rectangle parentBounds = editor.getParentFrame().getBounds();
        Rectangle location = dlg.getBounds();
        location.y = parentBounds.y;
        location.x = parentBounds.x + parentBounds.width;
        dlg.setBounds(location);
        dlg.setVisible(true);
        return preview;
    }

    @Override
    public void updatePreview(Object preview) {
        this.initThreadLocal();
        ((MaterialPreviewer)preview).render();
    }

    @Override
    public void disposePreview(Object preview) {
        UIUtilities.findWindow((MaterialPreviewer)preview).dispose();
    }

    @Override
    public boolean allowViewAngle() {
        return false;
    }

    @Override
    public boolean allowParameters() {
        return false;
    }

    @Override
    public boolean canEditName() {
        return true;
    }

    @Override
    public void acceptEdits(ProcedureEditor editor) {
        this.initThreadLocal();
        int i = editor.getScene().indexOf(this);
        if (i > -1) {
            editor.getScene().changeMaterial(i);
        }
    }

    @Override
    public void editProperties(ProcedureEditor editor) {
        ValueField refractField = new ValueField(this.indexOfRefraction(), 3);
        ValueField stepField = new ValueField(this.stepSize, 3);
        ValueField aliasField = new ValueField(this.antialiasing, 3);
        BCheckBox shadowBox = new BCheckBox(Translate.text("CastsShadows"), this.shadows);
        ComponentsDialog dlg = new ComponentsDialog(editor.getParentFrame(), Translate.text("editMaterialTitle"), new Widget[]{refractField, stepField, aliasField, shadowBox}, new String[]{Translate.text("IndexOfRefraction"), Translate.text("integrationStepSize"), Translate.text("Antialiasing"), ""});
        if (!dlg.clickedOk()) {
            return;
        }
        editor.saveState(false);
        this.setIndexOfRefraction(refractField.getValue());
        this.setStepSize(stepField.getValue());
        this.antialiasing = aliasField.getValue();
        this.shadows = shadowBox.getState();
        editor.updatePreview();
    }
}

