/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.math;

import java.util.Random;

public class FastRandom
extends Random {
    private long currentSeed;
    private static final long MULTIPLIER = 25214903917L;
    private static final long ADDEND = 11L;
    private static final long MASK = 0xFFFFFFFFFFFFL;

    public FastRandom(long seed) {
        super(seed);
    }

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed);
        this.currentSeed = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    @Override
    protected int next(int bits) {
        this.currentSeed = this.currentSeed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.currentSeed >>> 48 - bits);
    }
}

