/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.math;

import artofillusion.math.SimplexNoise;
import artofillusion.math.Vec3;

public class Noise {
    private static NoiseGenerator generator = new NoiseGenerator(){

        @Override
        public double getValue(double x, double y, double z) {
            return SimplexNoise.noise(x, y, z);
        }

        @Override
        public void getGradient(Vec3 gradient, double x, double y, double z) {
            SimplexNoise.noiseGradient(gradient, x, y, z);
        }

        @Override
        public void getVector(Vec3 v, double x, double y, double z) {
            SimplexNoise.noiseVector(v, x, y, z);
        }
    };

    public static double value(double x, double y, double z) {
        return generator.getValue(x, y, z);
    }

    public static void calcGradient(Vec3 gradient, double x, double y, double z) {
        generator.getGradient(gradient, x, y, z);
    }

    public static void calcVector(Vec3 v, double x, double y, double z) {
        generator.getVector(v, x, y, z);
    }

    public NoiseGenerator getGenerator() {
        return generator;
    }

    public void setGenerator(NoiseGenerator gen) {
        generator = gen;
    }

    public static interface NoiseGenerator {
        public double getValue(double var1, double var3, double var5);

        public void getGradient(Vec3 var1, double var2, double var4, double var6);

        public void getVector(Vec3 var1, double var2, double var4, double var6);
    }
}

