/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Scene;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.NullKeyframe;
import artofillusion.math.BoundingBox;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class NullObject
extends Object3D {
    static BoundingBox bounds;
    static WireframeMesh mesh;

    public NullObject() {
    }

    @Override
    public Object3D duplicate() {
        return new NullObject();
    }

    @Override
    public void copyObject(Object3D obj) {
    }

    @Override
    public BoundingBox getBounds() {
        return bounds;
    }

    @Override
    public void setSize(double xsize, double ysize, double zsize) {
    }

    @Override
    public boolean canSetTexture() {
        return false;
    }

    @Override
    public WireframeMesh getWireframeMesh() {
        return mesh;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    public NullObject(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
    }

    @Override
    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
    }

    @Override
    public Keyframe getPoseKeyframe() {
        return new NullKeyframe();
    }

    @Override
    public void applyPoseKeyframe(Keyframe k) {
    }

    static {
        double r = 0.25;
        bounds = new BoundingBox(-0.25, 0.25, -0.25, 0.25, -0.25, 0.25);
        Vec3[] vert = new Vec3[6];
        int[] from = new int[3];
        int[] to = new int[3];
        vert[0] = new Vec3(r, 0.0, 0.0);
        vert[1] = new Vec3(-r, 0.0, 0.0);
        vert[2] = new Vec3(0.0, r, 0.0);
        vert[3] = new Vec3(0.0, -r, 0.0);
        vert[4] = new Vec3(0.0, 0.0, r);
        vert[5] = new Vec3(0.0, 0.0, -r);
        from[0] = 0;
        to[0] = 1;
        from[1] = 2;
        to[1] = 3;
        from[2] = 4;
        to[2] = 5;
        mesh = new WireframeMesh(vert, from, to);
    }
}

