/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.math.FastMath;
import artofillusion.math.RGBColor;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.ProceduralModule;
import java.awt.Point;

public class HLSModule
extends ProceduralModule {
    RGBColor color = new RGBColor(0.0f, 0.0f, 0.0f);
    boolean colorOk;
    double lastBlur;

    public HLSModule(Point position) {
        super("HLS", new IOPort[]{new IOPort(0, 0, 2, new String[]{"Hue", "(1)"}), new IOPort(0, 0, 2, new String[]{"Lightness", "(1)"}), new IOPort(0, 0, 2, new String[]{"Saturation", "(1)"})}, new IOPort[]{new IOPort(1, 1, 3, new String[]{"Color"})}, position);
    }

    @Override
    public void init(PointInfo p) {
        this.colorOk = false;
    }

    @Override
    public void getColor(int which, RGBColor c, double blur) {
        float hueError;
        if (this.colorOk && blur == this.lastBlur) {
            c.copy(this.color);
            return;
        }
        this.colorOk = true;
        this.lastBlur = blur;
        float hue = this.linkFrom[0] == null ? 1.0f : (float)this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        float lightness = this.linkFrom[1] == null ? 1.0f : (float)this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        float saturation = this.linkFrom[2] == null ? 1.0f : (float)this.linkFrom[2].getAverageValue(this.linkFromIndex[2], blur);
        float f = hueError = this.linkFrom[0] == null ? 0.0f : (float)this.linkFrom[0].getValueError(this.linkFromIndex[0], blur) * 0.5f;
        if (saturation < 0.0f) {
            saturation = 0.0f;
        }
        if (saturation > 1.0f) {
            saturation = 1.0f;
        }
        if ((double)hueError == 0.0) {
            this.color.setHLS((hue - (float)FastMath.floor(hue)) * 360.0f, lightness, saturation);
        } else {
            if (hueError > 0.25f) {
                hueError = 0.25f;
            }
            float min = hue - hueError;
            float max = hue + hueError;
            min -= (float)FastMath.floor(min);
            max -= (float)FastMath.floor(max);
            this.color.setHSV(min * 360.0f, lightness, saturation);
            float r1 = this.color.getRed();
            float g1 = this.color.getGreen();
            float b1 = this.color.getBlue();
            this.color.setHSV(max * 360.0f, lightness, saturation);
            this.color.setRGB(0.5f * (r1 + this.color.getRed()), 0.5f * (g1 + this.color.getGreen()), 0.5f * (b1 + this.color.getBlue()));
        }
        c.copy(this.color);
    }
}

