/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.math.RGBColor;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.ProceduralModule;
import java.awt.Point;

public class RGBModule
extends ProceduralModule {
    RGBColor color = new RGBColor(0.0f, 0.0f, 0.0f);
    boolean colorOk;
    double lastBlur;

    public RGBModule(Point position) {
        super("RGB", new IOPort[]{new IOPort(0, 0, 2, new String[]{"Red", "(0)"}), new IOPort(0, 0, 2, new String[]{"Green", "(0)"}), new IOPort(0, 0, 2, new String[]{"Blue", "(0)"})}, new IOPort[]{new IOPort(1, 1, 3, new String[]{"Color"})}, position);
    }

    @Override
    public void init(PointInfo p) {
        this.colorOk = false;
    }

    @Override
    public void getColor(int which, RGBColor c, double blur) {
        if (this.colorOk && blur == this.lastBlur) {
            c.copy(this.color);
            return;
        }
        this.colorOk = true;
        this.lastBlur = blur;
        float red = this.linkFrom[0] == null ? 0.0f : (float)this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        float green = this.linkFrom[1] == null ? 0.0f : (float)this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        float blue = this.linkFrom[2] == null ? 0.0f : (float)this.linkFrom[2].getAverageValue(this.linkFromIndex[2], blur);
        this.color.setRGB(red, green, blue);
        c.copy(this.color);
    }
}

