/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.TransformDialog;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.ProceduralModule;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.ui.Translate;
import buoy.event.ValueChangedEvent;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TransformModule
extends ProceduralModule {
    boolean valueOk;
    boolean errorOk;
    boolean gradOk;
    CoordinateSystem coords = new CoordinateSystem(new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 1.0, 0.0));
    Vec3 grad1;
    Vec3 grad2;
    Vec3 grad3;
    Vec3 v;
    Vec3 tempVec;
    Mat4 trans;
    Mat4 gradTrans;
    double xscale = 1.0;
    double yscale = 1.0;
    double zscale = 1.0;
    double lastBlur;
    PointInfo point;

    public TransformModule(Point position) {
        super(Translate.text("menu.linearModule"), new IOPort[]{new IOPort(0, 0, 2, new String[]{"X", "(X)"}), new IOPort(0, 0, 2, new String[]{"Y", "(Y)"}), new IOPort(0, 0, 2, new String[]{"Z", "(Z)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"X"}), new IOPort(0, 1, 3, new String[]{"Y"}), new IOPort(0, 1, 3, new String[]{"Z"})}, position);
        this.updateTransforms();
        this.grad1 = new Vec3();
        this.grad2 = new Vec3();
        this.grad3 = new Vec3();
        this.v = new Vec3();
        this.tempVec = new Vec3();
    }

    public CoordinateSystem getCoordinates() {
        return this.coords;
    }

    public void setCoordinates(CoordinateSystem coords) {
        this.coords = coords;
        this.updateTransforms();
    }

    public double getXScale() {
        return this.xscale;
    }

    public void setXScale(double scale) {
        this.xscale = scale;
        this.updateTransforms();
    }

    public double getYScale() {
        return this.yscale;
    }

    public void setYScale(double scale) {
        this.yscale = scale;
        this.updateTransforms();
    }

    public double getZScale() {
        return this.zscale;
    }

    public void setZScale(double scale) {
        this.zscale = scale;
        this.updateTransforms();
    }

    private void updateTransforms() {
        this.trans = Mat4.scale(this.xscale, this.yscale, this.zscale).times(this.coords.fromLocal());
        this.gradTrans = this.coords.toLocal().times(Mat4.scale(this.xscale, this.yscale, this.zscale));
    }

    @Override
    public void init(PointInfo p) {
        this.point = p;
        this.gradOk = false;
        this.errorOk = false;
        this.valueOk = false;
    }

    @Override
    public double getAverageValue(int which, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.v.x = this.linkFrom[0] == null ? this.point.x : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
            this.v.y = this.linkFrom[1] == null ? this.point.y : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
            this.v.z = this.linkFrom[2] == null ? this.point.z : this.linkFrom[2].getAverageValue(this.linkFromIndex[2], blur);
            this.trans.transform(this.v);
            this.valueOk = true;
            this.lastBlur = blur;
        }
        if (which == 0) {
            return this.v.x;
        }
        if (which == 1) {
            return this.v.y;
        }
        return this.v.z;
    }

    @Override
    public double getValueError(int which, double blur) {
        if (!this.errorOk || blur != this.lastBlur) {
            this.tempVec.x = this.linkFrom[0] == null ? this.point.xsize * 0.5 + blur : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
            this.tempVec.y = this.linkFrom[1] == null ? this.point.ysize * 0.5 + blur : this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
            this.tempVec.z = this.linkFrom[2] == null ? this.point.zsize * 0.5 + blur : this.linkFrom[2].getValueError(this.linkFromIndex[2], blur);
            this.trans.transformDirection(this.tempVec);
            this.tempVec.x = Math.abs(this.tempVec.x);
            this.tempVec.y = Math.abs(this.tempVec.y);
            this.tempVec.z = Math.abs(this.tempVec.z);
            this.errorOk = true;
            this.lastBlur = blur;
        }
        if (which == 0) {
            return this.tempVec.x;
        }
        if (which == 1) {
            return this.tempVec.y;
        }
        return this.tempVec.z;
    }

    @Override
    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (!this.gradOk || blur != this.lastBlur) {
            if (this.linkFrom[0] == null) {
                this.grad1.set(this.trans.m11, 0.0, 0.0);
                this.grad2.set(this.trans.m21, 0.0, 0.0);
                this.grad3.set(this.trans.m31, 0.0, 0.0);
            } else {
                this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
                this.grad1.x = this.trans.m11 * grad.x;
                this.grad1.y = this.trans.m11 * grad.y;
                this.grad1.z = this.trans.m11 * grad.z;
                this.grad2.x = this.trans.m21 * grad.x;
                this.grad2.y = this.trans.m21 * grad.y;
                this.grad2.z = this.trans.m21 * grad.z;
                this.grad3.x = this.trans.m31 * grad.x;
                this.grad3.y = this.trans.m31 * grad.y;
                this.grad3.z = this.trans.m31 * grad.z;
            }
            if (this.linkFrom[1] == null) {
                this.grad1.y += this.trans.m12;
                this.grad2.y += this.trans.m22;
                this.grad3.y += this.trans.m32;
            } else {
                this.linkFrom[1].getValueGradient(this.linkFromIndex[1], grad, blur);
                this.grad1.x += this.trans.m12 * grad.x;
                this.grad1.y += this.trans.m12 * grad.y;
                this.grad1.z += this.trans.m12 * grad.z;
                this.grad2.x += this.trans.m22 * grad.x;
                this.grad2.y += this.trans.m22 * grad.y;
                this.grad2.z += this.trans.m22 * grad.z;
                this.grad3.x += this.trans.m32 * grad.x;
                this.grad3.y += this.trans.m32 * grad.y;
                this.grad3.z += this.trans.m32 * grad.z;
            }
            if (this.linkFrom[2] == null) {
                this.grad1.z += this.trans.m13;
                this.grad2.z += this.trans.m23;
                this.grad3.z += this.trans.m33;
            } else {
                this.linkFrom[2].getValueGradient(this.linkFromIndex[2], grad, blur);
                this.grad1.x += this.trans.m13 * grad.x;
                this.grad1.y += this.trans.m13 * grad.y;
                this.grad1.z += this.trans.m13 * grad.z;
                this.grad2.x += this.trans.m23 * grad.x;
                this.grad2.y += this.trans.m23 * grad.y;
                this.grad2.z += this.trans.m23 * grad.z;
                this.grad3.x += this.trans.m33 * grad.x;
                this.grad3.y += this.trans.m33 * grad.y;
                this.grad3.z += this.trans.m33 * grad.z;
            }
            this.gradOk = true;
            this.lastBlur = blur;
        }
        if (which == 0) {
            grad.set(this.grad1);
        } else if (which == 1) {
            grad.set(this.grad2);
        } else {
            grad.set(this.grad3);
        }
    }

    @Override
    public boolean edit(final ProcedureEditor editor, Scene theScene) {
        final Vec3 orig = this.coords.getOrigin();
        final double[] angles = this.coords.getRotationAngles();
        final TransformDialog dlg = new TransformDialog(editor.getParentFrame(), Translate.text("selectTransformProperties"), new double[]{orig.x, orig.y, orig.z, angles[0], angles[1], angles[2], this.xscale, this.yscale, this.zscale}, true, false, false);
        dlg.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                double[] values = dlg.getValues();
                if (!Double.isNaN(values[0])) {
                    orig.x = values[0];
                }
                if (!Double.isNaN(values[1])) {
                    orig.y = values[1];
                }
                if (!Double.isNaN(values[2])) {
                    orig.z = values[2];
                }
                if (!Double.isNaN(values[3])) {
                    angles[0] = values[3];
                }
                if (!Double.isNaN(values[4])) {
                    angles[1] = values[4];
                }
                if (!Double.isNaN(values[5])) {
                    angles[2] = values[5];
                }
                if (!Double.isNaN(values[6])) {
                    TransformModule.this.xscale = values[6];
                }
                if (!Double.isNaN(values[7])) {
                    TransformModule.this.yscale = values[7];
                }
                if (!Double.isNaN(values[8])) {
                    TransformModule.this.zscale = values[8];
                }
                TransformModule.this.coords.setOrigin(orig);
                TransformModule.this.coords.setOrientation(angles[0], angles[1], angles[2]);
                TransformModule.this.updateTransforms();
                editor.updatePreview();
            }
        });
        dlg.setVisible(true);
        return dlg.clickedOk();
    }

    @Override
    public Module duplicate() {
        TransformModule mod = new TransformModule(new Point(this.bounds.x, this.bounds.y));
        mod.coords = this.coords.duplicate();
        mod.xscale = this.xscale;
        mod.yscale = this.yscale;
        mod.zscale = this.zscale;
        mod.updateTransforms();
        return mod;
    }

    @Override
    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        this.coords.writeToFile(out);
        out.writeDouble(this.xscale);
        out.writeDouble(this.yscale);
        out.writeDouble(this.zscale);
    }

    @Override
    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.coords = new CoordinateSystem(in);
        this.xscale = in.readDouble();
        this.yscale = in.readDouble();
        this.zscale = in.readDouble();
        this.updateTransforms();
    }
}

