/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.script;

import artofillusion.script.ObjectScript;
import artofillusion.script.ScriptEngine;
import artofillusion.script.ScriptException;
import artofillusion.script.ToolScript;
import bsh.EvalError;
import bsh.Interpreter;
import java.io.PrintStream;
import java.util.Map;

public class BeanshellScriptEngine
implements ScriptEngine {
    Interpreter interp = new Interpreter();

    public BeanshellScriptEngine(ClassLoader parent) {
        this.interp.setClassLoader(parent);
    }

    @Override
    public String getName() {
        return "BeanShell";
    }

    @Override
    public String getFilenameExtension() {
        return "bsh";
    }

    @Override
    public void setOutput(PrintStream out) {
        this.interp.setOut(out);
        this.interp.setErr(out);
    }

    @Override
    public void addImport(String packageOrClass) throws Exception {
        this.interp.eval("import " + packageOrClass);
    }

    @Override
    public void executeScript(String script, Map<String, Object> variables) throws ScriptException {
        try {
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                this.interp.set(entry.getKey(), entry.getValue());
            }
            this.interp.eval(script);
        }
        catch (EvalError e) {
            throw new ScriptException(e.getErrorText(), e.getErrorLineNumber(), e);
        }
    }

    @Override
    public ToolScript createToolScript(String script) throws ScriptException {
        String prefix = "return new ToolScript() {void execute(LayoutWindow window) {\n";
        String suffix = "\n;}}";
        try {
            return (ToolScript)this.interp.eval(prefix + script + suffix);
        }
        catch (EvalError e) {
            throw new ScriptException(e.getMessage(), e.getErrorLineNumber() - 1, e);
        }
    }

    @Override
    public ObjectScript createObjectScript(String script) throws ScriptException {
        String prefix = "return new ObjectScript() {void execute(ScriptedObjectController script) {\n";
        String suffix = "\n;}}";
        try {
            return (ObjectScript)this.interp.eval(prefix + script + suffix);
        }
        catch (EvalError e) {
            throw new ScriptException(e.getMessage(), e.getErrorLineNumber() - 1, e);
        }
    }
}

