/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.script;

import artofillusion.LayoutWindow;
import artofillusion.script.ObjectScript;
import artofillusion.script.ScriptEngine;
import artofillusion.script.ScriptException;
import artofillusion.script.ScriptedObjectController;
import artofillusion.script.ToolScript;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;

public class GroovyScriptEngine
implements ScriptEngine {
    private CompilerConfiguration config = new CompilerConfiguration();
    private GroovyShell shell;
    private StringBuilder imports;
    private int numImports = 0;

    public GroovyScriptEngine(ClassLoader parent) {
        this.shell = new GroovyShell(parent, new Binding(), this.config);
        this.imports = new StringBuilder();
    }

    @Override
    public String getName() {
        return "Groovy";
    }

    @Override
    public String getFilenameExtension() {
        return "groovy";
    }

    @Override
    public void setOutput(PrintStream out) {
        this.config.setOutput(new PrintWriter(out, true));
    }

    @Override
    public void addImport(String packageOrClass) throws Exception {
        this.imports.append("import ").append(packageOrClass).append(";\n");
        ++this.numImports;
    }

    @Override
    public void executeScript(String script, Map<String, Object> variables) throws ScriptException {
        try {
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                this.shell.setVariable(entry.getKey(), entry.getValue());
            }
            this.shell.evaluate(this.imports.toString() + script);
        }
        catch (CompilationFailedException e) {
            throw new ScriptException(e.getMessage(), -1);
        }
    }

    @Override
    public ToolScript createToolScript(String script) throws ScriptException {
        try {
            return new CompiledToolScript(this.shell.parse(this.imports.toString() + script));
        }
        catch (CompilationFailedException e) {
            throw new ScriptException(e.getMessage(), -1);
        }
    }

    @Override
    public ObjectScript createObjectScript(String script) throws ScriptException {
        try {
            return new CompiledObjectScript(this.shell.parse(this.imports.toString() + script));
        }
        catch (CompilationFailedException e) {
            throw new ScriptException(e.getMessage(), -1, e);
        }
    }

    private class CompiledObjectScript
    implements ObjectScript {
        private Script script;

        public CompiledObjectScript(Script script) {
            this.script = script;
            script.setProperty("out", (Object)GroovyScriptEngine.this.config.getOutput());
        }

        @Override
        public void execute(ScriptedObjectController controller) throws ScriptException {
            this.script.setProperty("script", (Object)controller);
            this.script.run();
        }
    }

    private class CompiledToolScript
    implements ToolScript {
        private Script script;

        public CompiledToolScript(Script script) {
            this.script = script;
            script.setProperty("out", (Object)GroovyScriptEngine.this.config.getOutput());
        }

        @Override
        public void execute(LayoutWindow window) throws ScriptException {
            this.script.setProperty("window", (Object)window);
            try {
                this.script.run();
            }
            catch (Exception ex) {
                int line = -1;
                for (StackTraceElement element : ex.getStackTrace()) {
                    if (!element.getClassName().equals(this.script.getClass().getName())) continue;
                    line = element.getLineNumber() - GroovyScriptEngine.this.numImports;
                    break;
                }
                throw new ScriptException(ex.getMessage(), line, ex);
            }
        }
    }
}

