/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.ArtOfIllusion;
import artofillusion.MaterialPreviewer;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.LayeredTriangle;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Constructor;
import java.util.Vector;

public class LayeredMapping
extends TextureMapping {
    Object3D theObject;
    LayeredTexture theTexture;
    Texture[] texture;
    TextureMapping[] mapping;
    int[] blendMode;
    int[] fractParamIndex;
    int[] paramStartIndex;
    int[] numParams;
    int[] fractParamID;
    int maxParams;
    public static final int BLEND = 0;
    public static final int OVERLAY_BLEND_BUMPS = 1;
    public static final int OVERLAY_ADD_BUMPS = 2;

    public LayeredMapping(Object3D obj, Texture tex) {
        this.theObject = obj;
        this.theTexture = (LayeredTexture)tex;
        this.texture = new Texture[0];
        this.mapping = new TextureMapping[0];
        this.blendMode = new int[0];
        this.fractParamID = new int[0];
    }

    public int getNumLayers() {
        return this.texture.length;
    }

    public Texture[] getLayers() {
        return this.texture;
    }

    public Texture getLayer(int which) {
        return this.texture[which];
    }

    public void setLayer(int which, Texture tex) {
        this.texture[which] = tex;
    }

    public TextureMapping getLayerMapping(int which) {
        return this.mapping[which];
    }

    public void setLayerMapping(int which, TextureMapping map) {
        this.mapping[which] = map;
    }

    public int getLayerMode(int which) {
        return this.blendMode[which];
    }

    public void setLayerMode(int which, int mode) {
        this.blendMode[which] = mode;
    }

    @Override
    public TextureParameter[] getParameters() {
        TextureParameter[] p;
        int i;
        Vector<TextureParameter> param = new Vector<TextureParameter>();
        this.fractParamIndex = new int[this.texture.length];
        this.paramStartIndex = new int[this.texture.length];
        this.numParams = new int[this.texture.length];
        this.maxParams = 0;
        for (i = 0; i < this.texture.length; ++i) {
            this.fractParamIndex[i] = param.size();
            TextureParameter fractParam = new TextureParameter(this, this.texture[i].getName() + " fraction", 0.0, 1.0, 1.0);
            fractParam.setID(this.fractParamID[i]);
            param.addElement(fractParam);
            p = this.mapping[i].getParameters();
            if (p == null) continue;
            this.numParams[i] = p.length;
            this.paramStartIndex[i] = param.size();
            for (int j = 0; j < p.length; ++j) {
                param.addElement(p[j].duplicate());
                if (p[j].identifier == -1) continue;
                ((TextureParameter)param.lastElement()).setID(System.identityHashCode(this.mapping[i]) + p[j].identifier * 1025);
            }
            if (p.length <= this.maxParams) continue;
            this.maxParams = p.length;
        }
        p = new TextureParameter[param.size()];
        for (i = 0; i < p.length; ++i) {
            p[i] = (TextureParameter)param.elementAt(i);
        }
        return p;
    }

    public TextureParameter[] getLayerParameters(int which) {
        TextureParameter[] p = this.getParameters();
        TextureParameter[] param = new TextureParameter[this.numParams[which] + 1];
        param[0] = p[this.fractParamIndex[which]];
        for (int i = 1; i < param.length; ++i) {
            param[i] = p[i + this.paramStartIndex[which] - 1];
        }
        return param;
    }

    public TextureParameter getLayerBlendingParameter(int layer) {
        return this.getParameters()[this.fractParamIndex[layer]];
    }

    public TextureParameter getParameterForLayer(TextureParameter parameter, int layer) {
        TextureParameter[] originalParams = this.mapping[layer].getParameters();
        TextureParameter[] newParams = this.getLayerParameters(layer);
        for (int i = 0; i < originalParams.length; ++i) {
            if (!parameter.equals(originalParams[i])) continue;
            return newParams[i + 1];
        }
        return null;
    }

    public void addLayer(Texture tex) {
        Texture[] newtexture = new Texture[this.texture.length + 1];
        TextureMapping[] newmapping = new TextureMapping[this.texture.length + 1];
        int[] newblendMode = new int[this.texture.length + 1];
        int[] newFractParamID = new int[this.texture.length + 1];
        newtexture[0] = tex;
        newmapping[0] = tex.getDefaultMapping(this.theObject);
        newblendMode[0] = 0;
        newFractParamID[0] = TextureParameter.getUniqueID();
        for (int i = 0; i < this.texture.length; ++i) {
            newtexture[i + 1] = this.texture[i];
            newmapping[i + 1] = this.mapping[i];
            newblendMode[i + 1] = this.blendMode[i];
            newFractParamID[i + 1] = this.fractParamID[i];
        }
        this.texture = newtexture;
        this.mapping = newmapping;
        this.blendMode = newblendMode;
        this.fractParamID = newFractParamID;
    }

    public void addLayer(int index, Texture tex, TextureMapping map, int mode) {
        Texture[] newtexture = new Texture[this.texture.length + 1];
        TextureMapping[] newmapping = new TextureMapping[this.texture.length + 1];
        int[] newblendMode = new int[this.texture.length + 1];
        int[] newFractParamID = new int[this.texture.length + 1];
        newtexture[index] = tex;
        newmapping[index] = map;
        newblendMode[index] = mode;
        newFractParamID[index] = TextureParameter.getUniqueID();
        for (int i = 0; i < this.texture.length; ++i) {
            int j = i < index ? i : i + 1;
            newtexture[j] = this.texture[i];
            newmapping[j] = this.mapping[i];
            newblendMode[j] = this.blendMode[i];
            newFractParamID[j] = this.fractParamID[i];
        }
        this.texture = newtexture;
        this.mapping = newmapping;
        this.blendMode = newblendMode;
        this.fractParamID = newFractParamID;
    }

    public void deleteLayer(int which) {
        Texture[] newtexture = new Texture[this.texture.length - 1];
        TextureMapping[] newmapping = new TextureMapping[this.texture.length - 1];
        int[] newblendMode = new int[this.texture.length - 1];
        int[] newFractParamID = new int[this.texture.length - 1];
        int j = 0;
        for (int i = 0; i < this.texture.length; ++i) {
            if (i == which) continue;
            newtexture[j] = this.texture[i];
            newmapping[j] = this.mapping[i];
            newblendMode[j] = this.blendMode[i];
            newFractParamID[j] = this.fractParamID[i];
            ++j;
        }
        this.texture = newtexture;
        this.mapping = newmapping;
        this.blendMode = newblendMode;
        this.fractParamID = newFractParamID;
    }

    public void moveLayer(int which, int pos) {
        Texture[] newtexture = new Texture[this.texture.length];
        TextureMapping[] newmapping = new TextureMapping[this.texture.length];
        int[] newblendMode = new int[this.texture.length];
        int[] newFractParamID = new int[this.texture.length];
        int j = 0;
        for (int i = 0; i < newtexture.length; ++i) {
            if (j == which) {
                ++j;
            }
            if (i == pos) {
                newtexture[i] = this.texture[which];
                newmapping[i] = this.mapping[which];
                newblendMode[i] = this.blendMode[which];
                newFractParamID[i] = this.fractParamID[which];
                continue;
            }
            newtexture[i] = this.texture[j];
            newmapping[i] = this.mapping[j];
            newblendMode[i] = this.blendMode[j];
            newFractParamID[i] = this.fractParamID[j];
            ++j;
        }
        this.texture = newtexture;
        this.mapping = newmapping;
        this.blendMode = newblendMode;
        this.fractParamID = newFractParamID;
    }

    public void readFromFile(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        int numTextures = in.readInt();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.texture = new Texture[numTextures];
        this.mapping = new TextureMapping[numTextures];
        this.blendMode = new int[numTextures];
        this.fractParamID = new int[numTextures];
        for (int i = 0; i < this.texture.length; ++i) {
            this.texture[i] = theScene.getTexture(in.readInt());
            this.blendMode[i] = in.readInt();
            this.fractParamID[i] = TextureParameter.getUniqueID();
            try {
                Class mapClass = ArtOfIllusion.getClass(in.readUTF());
                Constructor con = mapClass.getConstructor(DataInputStream.class, Object3D.class, Texture.class);
                this.mapping[i] = (TextureMapping)con.newInstance(in, this.theObject, this.texture[i]);
                continue;
            }
            catch (Exception ex) {
                throw new IOException();
            }
        }
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(0);
        out.writeInt(this.texture.length);
        for (int i = 0; i < this.texture.length; ++i) {
            out.writeInt(theScene.indexOf(this.texture[i]));
            out.writeInt(this.blendMode[i]);
            out.writeUTF(this.mapping[i].getClass().getName());
            this.mapping[i].writeToFile(out);
        }
    }

    @Override
    public void writeToFile(DataOutputStream out) throws IOException {
        throw new IllegalStateException();
    }

    public static String getName() {
        return "Layered";
    }

    @Override
    public RenderingTriangle mapTriangle(int v1, int v2, int v3, int n1, int n2, int n3, Vec3[] vert) {
        return new LayeredTriangle(v1, v2, v3, n1, n2, n3, vert[v1].x, vert[v1].y, vert[v1].z, vert[v2].x, vert[v2].y, vert[v2].z, vert[v3].x, vert[v3].y, vert[v3].z, this, this.theTexture, vert);
    }

    @Override
    public void setParameters(RenderingTriangle tri, double[] p1, double[] p2, double[] p3, RenderingMesh mesh) {
        LayeredTriangle lt = (LayeredTriangle)tri;
        for (int i = 0; i < lt.layerTriangle.length; ++i) {
            if (lt.layerTriangle[i] == null || this.numParams[i] <= 0) continue;
            double[] t1 = new double[this.numParams[i]];
            double[] t2 = new double[this.numParams[i]];
            double[] t3 = new double[this.numParams[i]];
            for (int j = 0; j < this.numParams[i]; ++j) {
                t1[j] = p1[this.paramStartIndex[i] + j];
                t2[j] = p2[this.paramStartIndex[i] + j];
                t3[j] = p3[this.paramStartIndex[i] + j];
            }
            this.mapping[i].setParameters(lt.layerTriangle[i], t1, t2, t3, mesh);
        }
    }

    @Override
    public void getTextureSpec(Vec3 pos, TextureSpec spec, double angle, double size, double t, double[] param) {
        float rt = 1.0f;
        float gt = 1.0f;
        float bt = 1.0f;
        double ft = 1.0;
        boolean front = angle > 0.0;
        spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
        spec.specular.setRGB(0.0f, 0.0f, 0.0f);
        spec.hilight.setRGB(0.0f, 0.0f, 0.0f);
        spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
        spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
        spec.cloudiness = 0.0;
        spec.roughness = 0.0;
        spec.bumpGrad.set(0.0, 0.0, 0.0);
        TextureSpec tempSpec = new TextureSpec();
        double[] paramTemp = new double[this.maxParams];
        for (int i = 0; i < this.texture.length; ++i) {
            if (!this.mapping[i].appliesToFace(front)) continue;
            double f = param[this.fractParamIndex[i]];
            if (this.numParams[i] > 0) {
                for (int j = 0; j < this.numParams[i]; ++j) {
                    paramTemp[j] = param[this.paramStartIndex[i] + j];
                }
            }
            this.mapping[i].getTextureSpec(pos, tempSpec, angle, size, t, paramTemp);
            float r = rt * (float)f;
            float g = gt * (float)f;
            float b = bt * (float)f;
            spec.diffuse.add(r * tempSpec.diffuse.red, g * tempSpec.diffuse.green, b * tempSpec.diffuse.blue);
            spec.specular.add(r * tempSpec.specular.red, g * tempSpec.specular.green, b * tempSpec.specular.blue);
            spec.hilight.add(r * tempSpec.hilight.red, g * tempSpec.hilight.green, b * tempSpec.hilight.blue);
            spec.emissive.add(r * tempSpec.emissive.red, g * tempSpec.emissive.green, b * tempSpec.emissive.blue);
            if (this.blendMode[i] == 0) {
                spec.transparent.subtract(r * (1.0f - tempSpec.transparent.red), g * (1.0f - tempSpec.transparent.green), b * (1.0f - tempSpec.transparent.blue));
                f = ft * f;
            } else {
                spec.transparent.subtract(r *= 1.0f - tempSpec.transparent.red, g *= 1.0f - tempSpec.transparent.green, b *= 1.0f - tempSpec.transparent.blue);
                f = Math.max(Math.max(r, g), b);
            }
            spec.roughness += f * tempSpec.roughness;
            spec.cloudiness += f * tempSpec.cloudiness;
            if (this.blendMode[i] == 2) {
                tempSpec.bumpGrad.scale(param[this.fractParamIndex[i]]);
            } else {
                tempSpec.bumpGrad.scale(f);
            }
            spec.bumpGrad.add(tempSpec.bumpGrad);
            rt -= r;
            gt -= g;
            bt -= b;
            ft -= f;
            if (!(rt <= 0.0f) || !(gt <= 0.0f) || !(bt <= 0.0f)) continue;
            return;
        }
    }

    public void getAverageSpec(TextureSpec spec, double time, double[] param) {
        float rt = 1.0f;
        float gt = 1.0f;
        float bt = 1.0f;
        double ft = 1.0;
        spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
        spec.specular.setRGB(0.0f, 0.0f, 0.0f);
        spec.hilight.setRGB(0.0f, 0.0f, 0.0f);
        spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
        spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
        spec.cloudiness = 0.0;
        spec.roughness = 0.0;
        spec.bumpGrad.set(0.0, 0.0, 0.0);
        TextureSpec tempSpec = new TextureSpec();
        double[] paramTemp = new double[this.maxParams];
        for (int i = 0; i < this.texture.length; ++i) {
            double f = param[this.fractParamIndex[i]];
            if (this.numParams[i] > 0) {
                for (int j = 0; j < this.numParams[i]; ++j) {
                    paramTemp[j] = param[this.paramStartIndex[i] + j];
                }
            }
            this.texture[i].getAverageSpec(tempSpec, time, paramTemp);
            float r = rt * (float)f;
            float g = gt * (float)f;
            float b = bt * (float)f;
            spec.diffuse.add(r * tempSpec.diffuse.red, g * tempSpec.diffuse.green, b * tempSpec.diffuse.blue);
            spec.specular.add(r * tempSpec.specular.red, g * tempSpec.specular.green, b * tempSpec.specular.blue);
            spec.hilight.add(r * tempSpec.hilight.red, g * tempSpec.hilight.green, b * tempSpec.hilight.blue);
            spec.emissive.add(r * tempSpec.emissive.red, g * tempSpec.emissive.green, b * tempSpec.emissive.blue);
            if (this.blendMode[i] == 0) {
                spec.transparent.subtract(r * (1.0f - tempSpec.transparent.red), g * (1.0f - tempSpec.transparent.green), b * (1.0f - tempSpec.transparent.blue));
                f = ft * f;
            } else {
                spec.transparent.subtract(r *= 1.0f - tempSpec.transparent.red, g *= 1.0f - tempSpec.transparent.green, b *= 1.0f - tempSpec.transparent.blue);
                f = Math.max(Math.max(r, g), b);
            }
            spec.roughness += ft * tempSpec.roughness;
            spec.cloudiness += ft * tempSpec.cloudiness;
            if (this.blendMode[i] == 2) {
                tempSpec.bumpGrad.scale(param[this.fractParamIndex[i]]);
            } else {
                tempSpec.bumpGrad.scale(f);
            }
            spec.bumpGrad.add(tempSpec.bumpGrad);
            rt -= r;
            gt -= g;
            bt -= b;
            ft -= f;
            if (!(rt <= 0.0f) || !(gt <= 0.0f) || !(bt <= 0.0f)) continue;
            return;
        }
    }

    @Override
    public void getTransparency(Vec3 pos, RGBColor trans, double angle, double size, double t, double[] param) {
        float rt = 1.0f;
        float gt = 1.0f;
        float bt = 1.0f;
        RGBColor tempColor = new RGBColor();
        boolean front = angle > 0.0;
        double[] paramTemp = new double[this.maxParams];
        trans.setRGB(1.0f, 1.0f, 1.0f);
        for (int i = 0; i < this.texture.length; ++i) {
            if (!this.mapping[i].appliesToFace(front)) continue;
            double f = param[this.fractParamIndex[i]];
            if (this.numParams[i] > 0) {
                for (int j = 0; j < this.numParams[i]; ++j) {
                    paramTemp[j] = param[this.paramStartIndex[i] + j];
                }
            }
            this.mapping[i].getTransparency(pos, tempColor, angle, size, t, paramTemp);
            float r = rt * (float)f;
            float g = gt * (float)f;
            float b = bt * (float)f;
            if (this.blendMode[i] == 0) {
                trans.subtract(r * (1.0f - tempColor.red), g * (1.0f - tempColor.green), b * (1.0f - tempColor.blue));
            } else {
                trans.subtract(r *= 1.0f - tempColor.red, g *= 1.0f - tempColor.green, b *= 1.0f - tempColor.blue);
            }
            rt -= r;
            gt -= g;
            bt -= b;
            if (!(rt <= 0.0f) || !(gt <= 0.0f) || !(bt <= 0.0f)) continue;
            return;
        }
    }

    @Override
    public double getDisplacement(Vec3 pos, double size, double t, double[] param) {
        double ft = 1.0;
        double height = 0.0;
        RGBColor tempColor = new RGBColor();
        double[] paramTemp = new double[this.maxParams];
        for (int i = 0; i < this.texture.length; ++i) {
            double f = param[this.fractParamIndex[i]];
            if (this.numParams[i] > 0) {
                for (int j = 0; j < this.numParams[i]; ++j) {
                    paramTemp[j] = param[this.paramStartIndex[i] + j];
                }
            }
            double temp = this.mapping[i].getDisplacement(pos, size, t, paramTemp);
            f *= ft;
            if (this.blendMode[i] == 1) {
                this.mapping[i].getTransparency(pos, tempColor, 1.0, size, t, paramTemp);
                float min = tempColor.red;
                if (min > tempColor.green) {
                    min = tempColor.green;
                }
                if (min > tempColor.blue) {
                    min = tempColor.blue;
                }
                f *= ft * (double)(1.0f - min);
            }
            if (this.blendMode[i] != 2) {
                ft -= f;
            }
            height += temp * f;
            if (!(ft <= 0.0)) continue;
            return height;
        }
        return height;
    }

    @Override
    public Texture getTexture() {
        return this.theTexture;
    }

    @Override
    public Object3D getObject() {
        return this.theObject;
    }

    @Override
    public TextureMapping duplicate() {
        return this.duplicate(this.theObject, this.theTexture);
    }

    @Override
    public TextureMapping duplicate(Object3D obj, Texture tex) {
        LayeredMapping map = new LayeredMapping(obj, null);
        int layers = this.texture.length;
        map.theTexture = new LayeredTexture(map);
        map.texture = new Texture[layers];
        map.mapping = new TextureMapping[layers];
        map.blendMode = new int[layers];
        map.fractParamID = new int[layers];
        for (int i = 0; i < layers; ++i) {
            map.texture[i] = this.texture[i];
            map.mapping[i] = this.mapping[i].duplicate();
            map.blendMode[i] = this.blendMode[i];
            map.fractParamID[i] = this.fractParamID[i];
        }
        map.getParameters();
        return map;
    }

    @Override
    public void copy(TextureMapping theMap) {
        LayeredMapping map = (LayeredMapping)theMap;
        int layers = map.texture.length;
        this.texture = new Texture[layers];
        this.mapping = new TextureMapping[layers];
        this.blendMode = new int[layers];
        this.fractParamID = new int[layers];
        for (int i = 0; i < layers; ++i) {
            this.texture[i] = map.texture[i];
            this.mapping[i] = map.mapping[i].duplicate();
            this.blendMode[i] = map.blendMode[i];
            this.fractParamID[i] = map.fractParamID[i];
        }
        this.getParameters();
    }

    @Override
    public Widget getEditingPanel(Object3D obj, MaterialPreviewer preview) {
        return null;
    }
}

