/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.math.BoundingBox;
import artofillusion.math.RGBColor;
import artofillusion.texture.ProjectionMapping;
import artofillusion.texture.Texture2D;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;

public class Linear2DTriangle
extends RenderingTriangle {
    private double x1;
    private double x2;
    private double x3;
    private double y1;
    private double y2;
    private double y3;
    private boolean bumpMapped;
    private ProjectionMapping map;

    public Linear2DTriangle(int v1, int v2, int v3, int n1, int n2, int n3, double t1x, double t1y, double t2x, double t2y, double t3x, double t3y) {
        super(v1, v2, v3, n1, n2, n3);
        this.x1 = t1x;
        this.y1 = t1y;
        this.x2 = t2x;
        this.y2 = t2y;
        this.x3 = t3x;
        this.y3 = t3y;
    }

    @Override
    public void setMesh(RenderingMesh mesh, TextureMapping map, int index) {
        super.setMesh(mesh, map, index);
        this.map = (ProjectionMapping)map;
        this.bumpMapped = map.getTexture().hasComponent(5);
    }

    @Override
    public void getTextureSpec(TextureSpec spec, double angle, double u, double v, double w, double size, double time) {
        if (!this.map.appliesToFace(angle > 0.0)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        double sizex = size;
        double sizey = size;
        double sizez = size;
        if (this.map.scaleToObject) {
            double scale;
            BoundingBox bounds = this.map.getObject().getBounds();
            if (bounds.maxx > bounds.minx) {
                scale = 1.0 / (bounds.maxx - bounds.minx);
                sizex = size * scale;
            }
            if (bounds.maxy > bounds.miny) {
                scale = 1.0 / (bounds.maxy - bounds.miny);
                sizey = size * scale;
            }
            if (bounds.maxz > bounds.minz) {
                scale = 1.0 / (bounds.maxz - bounds.minz);
                sizez = size * scale;
            }
        }
        ((Texture2D)this.map.getTexture()).getTextureSpec(spec, this.x1 * u + this.x2 * v + this.x3 * w, this.y1 * u + this.y2 * v + this.y3 * w, this.length(this.map.ax * sizex, this.map.bx * sizey, this.map.cx * sizez), this.length(this.map.ay * sizex, this.map.by * sizey, this.map.cy * sizez), angle, time, this.getParameters(u, v, w));
        if (this.bumpMapped) {
            double s = spec.bumpGrad.x;
            double t = spec.bumpGrad.y;
            spec.bumpGrad.set(s * this.map.ax + t * this.map.ay, s * this.map.bx + t * this.map.by, s * this.map.cx + t * this.map.cy);
        }
    }

    @Override
    public void getTransparency(RGBColor trans, double angle, double u, double v, double w, double size, double time) {
        if (!this.map.appliesToFace(angle > 0.0)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        double sizex = size;
        double sizey = size;
        double sizez = size;
        if (this.map.scaleToObject) {
            double scale;
            BoundingBox bounds = this.map.getObject().getBounds();
            if (bounds.maxx > bounds.minx) {
                scale = 1.0 / (bounds.maxx - bounds.minx);
                sizex = size * scale;
            }
            if (bounds.maxy > bounds.miny) {
                scale = 1.0 / (bounds.maxy - bounds.miny);
                sizey = size * scale;
            }
            if (bounds.maxz > bounds.minz) {
                scale = 1.0 / (bounds.maxz - bounds.minz);
                sizez = size * scale;
            }
        }
        ((Texture2D)this.map.getTexture()).getTransparency(trans, this.x1 * u + this.x2 * v + this.x3 * w, this.y1 * u + this.y2 * v + this.y3 * w, this.length(this.map.ax * sizex, this.map.bx * sizey, this.map.cx * sizez), this.length(this.map.ay * sizex, this.map.by * sizey, this.map.cy * sizez), angle, time, this.getParameters(u, v, w));
    }

    @Override
    public double getDisplacement(double u, double v, double w, double size, double time) {
        double sizex = size;
        double sizey = size;
        double sizez = size;
        if (this.map.scaleToObject) {
            double scale;
            BoundingBox bounds = this.map.getObject().getBounds();
            if (bounds.maxx > bounds.minx) {
                scale = 1.0 / (bounds.maxx - bounds.minx);
                sizex = size * scale;
            }
            if (bounds.maxy > bounds.miny) {
                scale = 1.0 / (bounds.maxy - bounds.miny);
                sizey = size * scale;
            }
            if (bounds.maxz > bounds.minz) {
                scale = 1.0 / (bounds.maxz - bounds.minz);
                sizez = size * scale;
            }
        }
        return ((Texture2D)this.map.getTexture()).getDisplacement(this.x1 * u + this.x2 * v + this.x3 * w, this.y1 * u + this.y2 * v + this.y3 * w, this.length(this.map.ax * sizex, this.map.bx * sizey, this.map.cx * sizez), this.length(this.map.ay * sizex, this.map.by * sizey, this.map.cy * sizez), time, this.getParameters(u, v, w));
    }

    private double length(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }
}

