/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.image.ImageMap;
import artofillusion.math.RGBColor;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.ImageModule;
import artofillusion.procedural.Link;
import artofillusion.procedural.Module;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.ParameterModule;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.Procedure;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.procedural.ProcedureOwner;
import artofillusion.texture.Texture;
import artofillusion.texture.Texture2D;
import artofillusion.texture.TextureSpec;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSelector;
import buoy.event.ValueChangedEvent;
import buoy.widget.BDialog;
import buoy.widget.BorderContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ProceduralTexture2D
extends Texture2D
implements ProcedureOwner {
    private Procedure proc;
    private double antialiasing;
    private ThreadLocal renderingProc;

    public ProceduralTexture2D() {
        this.proc = this.createProcedure();
        this.antialiasing = 1.0;
        this.initThreadLocal();
    }

    private Procedure createProcedure() {
        return new Procedure(new OutputModule[]{new OutputModule(Translate.text("Diffuse"), Translate.text("white"), 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule(Translate.text("Specular"), Translate.text("white"), 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule(Translate.text("Transparent"), Translate.text("white"), 0.0, new RGBColor(1.0f, 1.0f, 1.0f), 1), new OutputModule(Translate.text("Emissive"), Translate.text("black"), 0.0, new RGBColor(0.0f, 0.0f, 0.0f), 1), new OutputModule(Translate.text("Transparency"), "0", 0.0, null, 0), new OutputModule(Translate.text("Specularity"), "0", 0.0, null, 0), new OutputModule(Translate.text("Shininess"), "0", 0.0, null, 0), new OutputModule(Translate.text("Roughness"), "0", 0.0, null, 0), new OutputModule(Translate.text("Cloudiness"), "0", 0.0, null, 0), new OutputModule(Translate.text("BumpHeight"), "0", 0.0, null, 0), new OutputModule(Translate.text("Displacement"), "0", 0.0, null, 0)});
    }

    private void initThreadLocal() {
        this.renderingProc = new ThreadLocal(){

            protected Object initialValue() {
                Procedure localProc = ProceduralTexture2D.this.createProcedure();
                localProc.copy(ProceduralTexture2D.this.proc);
                return localProc;
            }
        };
    }

    public static String getTypeName() {
        return "Procedural 2D";
    }

    @Override
    public void getAverageSpec(TextureSpec spec, double time, double[] param) {
        this.getTextureSpec(spec, 0.0, 0.0, 1000.0, 1000.0, 1.0, time, param);
    }

    @Override
    public void getTextureSpec(TextureSpec spec, double x, double y, double xsize, double ysize, double angle, double t, double[] param) {
        Procedure pr = (Procedure)this.renderingProc.get();
        OutputModule[] output = pr.getOutputModules();
        PointInfo info = new PointInfo();
        info.x = x;
        info.y = y;
        info.z = 0.0;
        info.xsize = xsize * this.antialiasing;
        info.ysize = ysize * this.antialiasing;
        info.zsize = 0.0;
        info.viewangle = angle;
        info.t = t;
        info.param = param;
        pr.initForPoint(info);
        double transparency = output[4].getAverageValue(0, 0.0);
        double specularity = output[5].getAverageValue(0, 0.0);
        double shininess = output[6].getAverageValue(0, 0.0);
        if (transparency < 0.0) {
            transparency = 0.0;
        }
        if (transparency > 1.0) {
            transparency = 1.0;
        }
        if (specularity < 0.0) {
            specularity = 0.0;
        }
        if (specularity > 1.0) {
            specularity = 1.0;
        }
        if (shininess < 0.0) {
            shininess = 0.0;
        }
        if (shininess > 1.0) {
            shininess = 1.0;
        }
        output[0].getColor(0, spec.diffuse, 0.0);
        output[1].getColor(0, spec.specular, 0.0);
        output[2].getColor(0, spec.transparent, 0.0);
        output[3].getColor(0, spec.emissive, 0.0);
        spec.hilight.copy(spec.specular);
        spec.diffuse.scale((1.0 - transparency) * (1.0 - specularity));
        spec.specular.scale((1.0 - transparency) * specularity);
        spec.hilight.scale((1.0 - transparency) * shininess);
        spec.transparent.scale(transparency);
        spec.roughness = output[7].getAverageValue(0, 0.0);
        spec.cloudiness = output[8].getAverageValue(0, 0.0);
        if (spec.roughness < 0.0) {
            spec.roughness = 0.0;
        }
        if (spec.roughness > 1.0) {
            spec.roughness = 1.0;
        }
        if (spec.cloudiness < 0.0) {
            spec.cloudiness = 0.0;
        }
        if (spec.cloudiness > 1.0) {
            spec.cloudiness = 1.0;
        }
        output[9].getValueGradient(0, spec.bumpGrad, 0.0);
        spec.bumpGrad.scale(0.04);
    }

    @Override
    public void getTransparency(RGBColor trans, double x, double y, double xsize, double ysize, double angle, double t, double[] param) {
        Procedure pr = (Procedure)this.renderingProc.get();
        OutputModule[] output = pr.getOutputModules();
        PointInfo info = new PointInfo();
        info.x = x;
        info.y = y;
        info.z = 0.0;
        info.xsize = xsize * this.antialiasing;
        info.ysize = ysize * this.antialiasing;
        info.zsize = 0.0;
        info.viewangle = angle;
        info.t = t;
        info.param = param;
        pr.initForPoint(info);
        double transparency = output[4].getAverageValue(0, 0.0);
        if (transparency < 0.0) {
            transparency = 0.0;
        }
        if (transparency > 1.0) {
            transparency = 1.0;
        }
        output[2].getColor(0, trans, 0.0);
        trans.scale(transparency);
    }

    public Procedure getProcedure() {
        return this.proc;
    }

    @Override
    public boolean usesImage(ImageMap image) {
        Module[] modules = this.proc.getModules();
        for (int i = 0; i < modules.length; ++i) {
            if (!(modules[i] instanceof ImageModule) || ((ImageModule)modules[i]).getMap() != image) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getDisplacement(double x, double y, double xsize, double ysize, double t, double[] param) {
        Procedure pr = (Procedure)this.renderingProc.get();
        OutputModule[] output = pr.getOutputModules();
        PointInfo info = new PointInfo();
        info.x = x;
        info.y = y;
        info.z = 0.0;
        info.xsize = xsize * this.antialiasing;
        info.ysize = ysize * this.antialiasing;
        info.zsize = 0.0;
        info.viewangle = 1.0;
        info.t = t;
        info.param = param;
        pr.initForPoint(info);
        return output[10].getAverageValue(0, 0.0);
    }

    @Override
    public Texture duplicate() {
        ProceduralTexture2D tex = new ProceduralTexture2D();
        tex.proc.copy(this.proc);
        tex.setName(this.getName());
        tex.antialiasing = this.antialiasing;
        return tex;
    }

    @Override
    public TextureParameter[] getParameters() {
        Module[] module = this.proc.getModules();
        int count = 0;
        for (int i = 0; i < module.length; ++i) {
            if (!(module[i] instanceof ParameterModule)) continue;
            ++count;
        }
        TextureParameter[] params = new TextureParameter[count];
        count = 0;
        for (int i = 0; i < module.length; ++i) {
            if (!(module[i] instanceof ParameterModule)) continue;
            params[count] = ((ParameterModule)module[i]).getParameter(this);
            ((ParameterModule)module[i]).setIndex(count++);
        }
        return params;
    }

    @Override
    public boolean hasComponent(int component) {
        OutputModule[] output = this.proc.getOutputModules();
        switch (component) {
            case 0: {
                return true;
            }
            case 1: {
                return output[5].inputConnected(0);
            }
            case 2: {
                return output[4].inputConnected(0);
            }
            case 3: {
                return output[6].inputConnected(0);
            }
            case 4: {
                return output[3].inputConnected(0);
            }
            case 5: {
                return output[9].inputConnected(0);
            }
            case 6: {
                return output[10].inputConnected(0);
            }
        }
        return false;
    }

    @Override
    public void edit(WindowWidget fr, Scene sc) {
        new ProcedureEditor(this.proc, this, sc);
    }

    public ProceduralTexture2D(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.setName(in.readUTF());
        this.antialiasing = in.readDouble();
        this.proc = this.createProcedure();
        this.proc.readFromStream(in, theScene);
        if (version == 0) {
            int i;
            OutputModule[] output = this.proc.getOutputModules();
            Module[] input = new Module[output.length];
            int[] index = new int[output.length];
            for (int i2 = 0; i2 < output.length; ++i2) {
                int j = i2 < 6 ? i2 : i2 - 1;
                input[i2] = output[j].linkFrom[0];
                index[i2] = output[j].linkFromIndex[0];
            }
            Link[] link = this.proc.getLinks();
            for (i = 0; i < link.length; ++i) {
                if (!(link[i].to.getModule() instanceof OutputModule)) continue;
                this.proc.deleteLink(i--);
                link = this.proc.getLinks();
            }
            for (i = 0; i < input.length; ++i) {
                if (input[i] == null) continue;
                IOPort to = output[i].getInputPorts()[0];
                IOPort from = input[i].getOutputPorts()[index[i]];
                this.proc.addLink(new Link(from, to));
            }
        }
        this.initThreadLocal();
    }

    @Override
    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(1);
        out.writeUTF(this.getName());
        out.writeDouble(this.antialiasing);
        this.proc.writeToStream(out, theScene);
    }

    @Override
    public String getWindowTitle() {
        return "Procedural 2D Texture";
    }

    @Override
    public Object getPreview(ProcedureEditor editor) {
        BDialog dlg = new BDialog(editor.getParentFrame(), "Preview", false);
        BorderContainer content = new BorderContainer();
        final MaterialPreviewer preview = new MaterialPreviewer(this, null, 200, 160);
        content.add(preview, BorderContainer.CENTER);
        RowContainer row = new RowContainer();
        content.add(row, BorderContainer.SOUTH, new LayoutInfo());
        row.add(Translate.label("Time", ":"));
        final ValueSelector value = new ValueSelector(0.0, -1.7976931348623157E308, Double.MAX_VALUE, 0.01);
        final ActionProcessor processor = new ActionProcessor();
        row.add(value);
        value.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                processor.addEvent(new Runnable(){

                    @Override
                    public void run() {
                        preview.getScene().setTime(value.getValue());
                        preview.render();
                    }
                });
            }
        });
        dlg.setContent(content);
        dlg.pack();
        Rectangle parentBounds = editor.getParentFrame().getBounds();
        Rectangle location = dlg.getBounds();
        location.y = parentBounds.y;
        location.x = parentBounds.x + parentBounds.width;
        dlg.setBounds(location);
        dlg.setVisible(true);
        return preview;
    }

    @Override
    public void updatePreview(Object preview) {
        this.initThreadLocal();
        ((MaterialPreviewer)preview).render();
    }

    @Override
    public void disposePreview(Object preview) {
        UIUtilities.findWindow((MaterialPreviewer)preview).dispose();
    }

    @Override
    public boolean allowParameters() {
        return true;
    }

    @Override
    public boolean allowViewAngle() {
        return true;
    }

    @Override
    public boolean canEditName() {
        return true;
    }

    @Override
    public void acceptEdits(ProcedureEditor editor) {
        this.initThreadLocal();
        int i = editor.getScene().indexOf(this);
        if (i > -1) {
            editor.getScene().changeTexture(i);
        }
    }

    @Override
    public void editProperties(ProcedureEditor editor) {
        ValueField aliasField = new ValueField(this.antialiasing, 3);
        ComponentsDialog dlg = new ComponentsDialog(editor.getParentFrame(), Translate.text("editTextureTitle"), new Widget[]{aliasField}, new String[]{Translate.text("Antialiasing")});
        if (!dlg.clickedOk()) {
            return;
        }
        editor.saveState(false);
        this.antialiasing = aliasField.getValue();
        editor.updatePreview();
    }
}

