/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.TextureParameter;
import artofillusion.animation.Actor;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.FastMath;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.texture.Nonlinear2DTriangle;
import artofillusion.texture.NonlinearMapping2D;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Insets;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class SphericalMapping
extends NonlinearMapping2D {
    CoordinateSystem coords;
    double xscale;
    double yscale;
    double offset;
    double ax;
    double ay;
    double dy;
    Mat4 toLocal;
    Mat4 fromLocal;
    boolean transform;
    TextureParameter xparam;
    TextureParameter yparam;
    TextureParameter zparam;

    public SphericalMapping(Object3D theObject, Texture theTexture) {
        super(theObject, theTexture);
        this.coords = new CoordinateSystem(new Vec3(), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 1.0, 0.0));
        this.xscale = 360.0;
        this.yscale = 180.0;
        this.findCoefficients();
    }

    public static String getName() {
        return "Spherical";
    }

    void findCoefficients() {
        this.ax = -180.0 / (Math.PI * this.xscale);
        this.ay = -180.0 / (Math.PI * this.yscale);
        this.dy = this.offset * (Math.PI / 180);
        this.toLocal = this.coords.toLocal();
        this.fromLocal = this.coords.fromLocal();
        this.transform = this.fromLocal.m11 != 1.0 || this.fromLocal.m22 != 1.0 || this.fromLocal.m33 != 1.0;
    }

    public Vec2 getScale() {
        return new Vec2(this.xscale, this.yscale);
    }

    public void setScale(Vec2 scale) {
        this.xscale = scale.x;
        this.yscale = scale.y;
        this.findCoefficients();
    }

    public Vec3 getRotations() {
        double[] angles = this.coords.getRotationAngles();
        return new Vec3(angles[0], angles[1], angles[2]);
    }

    public void setRotations(Vec3 angles) {
        this.coords.setOrientation(angles.x, angles.y, angles.z);
        this.findCoefficients();
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double degrees) {
        this.offset = degrees;
    }

    @Override
    public RenderingTriangle mapTriangle(int v1, int v2, int v3, int n1, int n2, int n3, Vec3[] vert) {
        Vec3 c1 = this.toLocal.timesDirection(vert[v1]);
        Vec3 c2 = this.toLocal.timesDirection(vert[v2]);
        Vec3 c3 = this.toLocal.timesDirection(vert[v3]);
        return new Nonlinear2DTriangle(v1, v2, v3, n1, n2, n3, c1, c2, c3);
    }

    @Override
    public void setParameters(RenderingTriangle tri, double[] p1, double[] p2, double[] p3, RenderingMesh mesh) {
        ((Nonlinear2DTriangle)tri).setParameters(p1, p2, p3, mesh);
    }

    @Override
    public void getTextureSpec(Vec3 pos, TextureSpec spec, double angle, double size, double time, double[] param) {
        double pz;
        double py;
        double px;
        if (!this.appliesToFace(angle > 0.0)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        if (this.coordsFromParams && this.numTextureParams < param.length && param[this.numTextureParams] != Double.MAX_VALUE) {
            px = param[this.numTextureParams];
            py = param[this.numTextureParams + 1];
            pz = param[this.numTextureParams + 2];
        } else {
            px = pos.x;
            py = pos.y;
            pz = pos.z;
        }
        double x = this.toLocal.m11 * px + this.toLocal.m12 * py + this.toLocal.m13 * pz;
        double y = this.toLocal.m21 * px + this.toLocal.m22 * py + this.toLocal.m23 * pz;
        double z = this.toLocal.m31 * px + this.toLocal.m32 * py + this.toLocal.m33 * pz;
        double theta = FastMath.atan(z / x);
        if (x < 0.0) {
            theta += Math.PI;
        }
        double r1 = x * x + z * z;
        double r2 = Math.sqrt(r1 + y * y);
        r1 = Math.sqrt(r1);
        double phi = Math.acos(y / r2);
        this.texture.getTextureSpec(spec, theta * this.ax, phi * this.ay + this.dy, Math.abs(size * this.ax / r1), Math.abs(size * this.ay / r2), angle, time, param);
        if (this.texture.hasComponent(5)) {
            double s = spec.bumpGrad.x * this.ax / r1;
            double t = spec.bumpGrad.y * this.ay / (r1 * r2);
            spec.bumpGrad.set(-s * z + t * x * y, -t * r1 * r1, s * x + t * z * y);
            if (this.transform) {
                this.fromLocal.transform(spec.bumpGrad);
            }
        }
    }

    @Override
    public double getDisplacement(Vec3 pos, double size, double time, double[] param) {
        double pz;
        double py;
        double px;
        if (this.coordsFromParams && this.numTextureParams < param.length && param[this.numTextureParams] != Double.MAX_VALUE) {
            px = param[this.numTextureParams];
            py = param[this.numTextureParams + 1];
            pz = param[this.numTextureParams + 2];
        } else {
            px = pos.x;
            py = pos.y;
            pz = pos.z;
        }
        double x = this.toLocal.m11 * px + this.toLocal.m12 * py + this.toLocal.m13 * pz;
        double y = this.toLocal.m21 * px + this.toLocal.m22 * py + this.toLocal.m23 * pz;
        double z = this.toLocal.m31 * px + this.toLocal.m32 * py + this.toLocal.m33 * pz;
        double theta = FastMath.atan(z / x);
        if (x < 0.0) {
            theta += Math.PI;
        }
        double r1 = x * x + z * z;
        double r2 = Math.sqrt(r1 + y * y);
        r1 = Math.sqrt(r1);
        double phi = Math.acos(y / r2);
        return this.texture.getDisplacement(theta * this.ax, phi * this.ay + this.dy, Math.abs(size * this.ax / r1), Math.abs(size * this.ay / r2), time, param);
    }

    @Override
    public void getTransparency(Vec3 pos, RGBColor trans, double angle, double size, double time, double[] param) {
        double pz;
        double py;
        double px;
        if (!this.appliesToFace(angle > 0.0)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        if (this.coordsFromParams && this.numTextureParams < param.length && param[this.numTextureParams] != Double.MAX_VALUE) {
            px = param[this.numTextureParams];
            py = param[this.numTextureParams + 1];
            pz = param[this.numTextureParams + 2];
        } else {
            px = pos.x;
            py = pos.y;
            pz = pos.z;
        }
        double x = this.toLocal.m11 * px + this.toLocal.m12 * py + this.toLocal.m13 * pz;
        double y = this.toLocal.m21 * px + this.toLocal.m22 * py + this.toLocal.m23 * pz;
        double z = this.toLocal.m31 * px + this.toLocal.m32 * py + this.toLocal.m33 * pz;
        double theta = FastMath.atan(z / x);
        if (x < 0.0) {
            theta += Math.PI;
        }
        double r1 = x * x + z * z;
        double r2 = Math.sqrt(r1 + y * y);
        r1 = Math.sqrt(r1);
        double phi = Math.acos(y / r2);
        this.texture.getTransparency(trans, theta * this.ax, phi * this.ay + this.dy, Math.abs(size * this.ax / r1), Math.abs(size * this.ay / r2), angle, time, param);
    }

    @Override
    public Mat4 getPreTransform() {
        return this.toLocal;
    }

    @Override
    public void getSpecIntermed(TextureSpec spec, double x, double y, double z, double size, double angle, double time, double[] param) {
        double theta = FastMath.atan(z / x);
        if (x < 0.0) {
            theta += Math.PI;
        } else if (Double.isNaN(theta)) {
            theta = z > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        double r1 = x * x + z * z;
        double r2 = Math.sqrt(r1 + y * y);
        r1 = Math.sqrt(r1);
        double phi = Math.acos(y / r2);
        this.texture.getTextureSpec(spec, theta * this.ax, phi * this.ay + this.dy, Math.abs(size * this.ax / r1), Math.abs(size * this.ay / r2), angle, time, param);
        if (this.texture.hasComponent(5)) {
            double s = spec.bumpGrad.x * this.ax / r1;
            double t = spec.bumpGrad.y * this.ay / (r1 * r2);
            spec.bumpGrad.set(-s * z + t * x * y, -t * r1 * r1, s * x + t * z * y);
            if (this.transform) {
                this.fromLocal.transform(spec.bumpGrad);
            }
        }
    }

    @Override
    public void getTransIntermed(RGBColor trans, double x, double y, double z, double size, double angle, double time, double[] param) {
        double theta = FastMath.atan(z / x);
        if (x < 0.0) {
            theta += Math.PI;
        } else if (Double.isNaN(theta)) {
            theta = z > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        double r1 = x * x + z * z;
        double r2 = Math.sqrt(r1 + y * y);
        r1 = Math.sqrt(r1);
        double phi = Math.acos(y / r2);
        this.texture.getTransparency(trans, theta * this.ax, phi * this.ay + this.dy, Math.abs(size * this.ax / r1), Math.abs(size * this.ay / r2), angle, time, param);
    }

    @Override
    public double getDisplaceIntermed(double x, double y, double z, double size, double time, double[] param) {
        double theta = FastMath.atan(z / x);
        if (x < 0.0) {
            theta += Math.PI;
        } else if (Double.isNaN(theta)) {
            theta = z > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        double r1 = x * x + z * z;
        double r2 = Math.sqrt(r1 + y * y);
        r1 = Math.sqrt(r1);
        double phi = Math.acos(y / r2);
        return this.texture.getDisplacement(theta * this.ax, phi * this.ay + this.dy, Math.abs(size * this.ax / r1), Math.abs(size * this.ay / r2), time, param);
    }

    @Override
    public Vec2[] findTextureCoordinates(Mesh mesh) {
        ParameterValue[] paramValue = mesh.getParameterValues();
        TextureParameter[] param = mesh.getParameters();
        VertexParameterValue xval = null;
        VertexParameterValue yval = null;
        VertexParameterValue zval = null;
        if (this.coordsFromParams) {
            for (int i = 0; i < param.length; ++i) {
                if (param[i].equals(this.xparam)) {
                    xval = (VertexParameterValue)paramValue[i];
                    continue;
                }
                if (param[i].equals(this.yparam)) {
                    yval = (VertexParameterValue)paramValue[i];
                    continue;
                }
                if (!param[i].equals(this.zparam)) continue;
                zval = (VertexParameterValue)paramValue[i];
            }
        }
        MeshVertex[] vert = mesh.getVertices();
        Vec2[] uv = new Vec2[vert.length];
        for (int i = 0; i < vert.length; ++i) {
            double z;
            double y;
            double x;
            if (xval == null) {
                x = vert[i].r.x;
                y = vert[i].r.y;
                z = vert[i].r.z;
            } else {
                x = xval.getValue()[i];
                y = yval.getValue()[i];
                z = zval.getValue()[i];
            }
            double theta = FastMath.atan(z / x);
            if (x < 0.0) {
                theta += Math.PI;
            }
            double r2 = Math.sqrt(x * x + y * y + z * z);
            double phi = Math.acos(y / r2);
            if (Double.isNaN(theta)) {
                theta = 0.0;
            }
            if (Double.isNaN(phi)) {
                phi = 0.0;
            }
            uv[i] = new Vec2(theta * this.ax, phi * this.ay + this.dy);
        }
        return uv;
    }

    @Override
    public TextureMapping duplicate() {
        return this.duplicate(this.object, this.texture);
    }

    @Override
    public TextureMapping duplicate(Object3D obj, Texture tex) {
        SphericalMapping map = new SphericalMapping(obj, tex);
        map.coords = this.coords.duplicate();
        map.offset = this.offset;
        map.xscale = this.xscale;
        map.yscale = this.yscale;
        map.findCoefficients();
        map.coordsFromParams = this.coordsFromParams;
        map.numTextureParams = this.numTextureParams;
        map.setAppliesTo(this.appliesTo());
        map.xparam = this.xparam;
        map.yparam = this.yparam;
        map.zparam = this.zparam;
        return map;
    }

    @Override
    public void copy(TextureMapping mapping) {
        SphericalMapping map = (SphericalMapping)mapping;
        this.coords = map.coords.duplicate();
        this.offset = map.offset;
        this.xscale = map.xscale;
        this.yscale = map.yscale;
        this.findCoefficients();
        this.coordsFromParams = map.coordsFromParams;
        this.numTextureParams = map.numTextureParams;
        this.setAppliesTo(map.appliesTo());
        this.xparam = map.xparam;
        this.yparam = map.yparam;
        this.zparam = map.zparam;
    }

    @Override
    public TextureParameter[] getParameters() {
        if (!this.coordsFromParams) {
            return this.getTexture().getParameters();
        }
        TextureParameter[] tp = this.getTexture().getParameters();
        this.numTextureParams = tp.length;
        TextureParameter[] p = new TextureParameter[this.numTextureParams + 3];
        System.arraycopy(tp, 0, p, 0, this.numTextureParams);
        if (this.xparam == null) {
            this.xparam = new TextureParameter(this, "X", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
            this.yparam = new TextureParameter(this, "Y", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
            this.zparam = new TextureParameter(this, "Z", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
            this.xparam.type = 1;
            this.yparam.type = 2;
            this.zparam.type = 3;
            this.xparam.assignNewID();
            this.yparam.assignNewID();
            this.zparam.assignNewID();
        }
        p[this.numTextureParams] = this.xparam;
        p[this.numTextureParams + 1] = this.yparam;
        p[this.numTextureParams + 2] = this.zparam;
        return p;
    }

    @Override
    public Widget getEditingPanel(Object3D obj, MaterialPreviewer preview) {
        return new Editor(obj, preview);
    }

    public SphericalMapping(DataInputStream in, Object3D theObject, Texture theTexture) throws IOException, InvalidObjectException {
        super(theObject, theTexture);
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.coords = new CoordinateSystem(in);
        this.offset = in.readDouble();
        this.xscale = in.readDouble();
        this.yscale = in.readDouble();
        this.findCoefficients();
        this.coordsFromParams = in.readBoolean();
        if (version == 1) {
            this.setAppliesTo(in.readShort());
        }
    }

    @Override
    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeShort(1);
        this.coords.writeToFile(out);
        out.writeDouble(this.offset);
        out.writeDouble(this.xscale);
        out.writeDouble(this.yscale);
        out.writeBoolean(this.coordsFromParams);
        out.writeShort(this.appliesTo());
    }

    class Editor
    extends FormContainer {
        ValueField xrotField;
        ValueField yrotField;
        ValueField zrotField;
        ValueField xscaleField;
        ValueField yscaleField;
        ValueField ytransField;
        BCheckBox coordsFromParamsBox;
        BComboBox applyToChoice;
        Object3D theObject;
        MaterialPreviewer preview;

        public Editor(Object3D obj, MaterialPreviewer preview) {
            super(3, 8);
            this.theObject = obj;
            this.preview = preview;
            LayoutInfo leftLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null);
            LayoutInfo rightLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(0, 5, 0, 0), null);
            this.add(Translate.label("Width"), 0, 0, leftLayout);
            this.xscaleField = new ValueField(SphericalMapping.this.xscale, 2, 5);
            this.add(this.xscaleField, 1, 0);
            this.add(new BLabel("(" + Translate.text("degrees") + ")"), 2, 0, rightLayout);
            this.add(Translate.label("Height"), 0, 1, leftLayout);
            this.yscaleField = new ValueField(SphericalMapping.this.yscale, 2, 5);
            this.add(this.yscaleField, 1, 1);
            this.add(new BLabel("(" + Translate.text("degrees") + ")"), 2, 1, rightLayout);
            this.add(Translate.label("Offset"), 0, 2, leftLayout);
            this.ytransField = new ValueField(SphericalMapping.this.offset, 0, 5);
            this.add(this.ytransField, 1, 2);
            this.add(new BLabel("(" + Translate.text("degrees") + ")"), 2, 2, rightLayout);
            this.add(new BLabel(Translate.text("Rotation") + ":"), 0, 3, 3, 1);
            double[] angles = SphericalMapping.this.coords.getRotationAngles();
            RowContainer rotationRow = new RowContainer();
            rotationRow.add(new BLabel("X"));
            this.xrotField = new ValueField(angles[0], 0, 5);
            rotationRow.add(this.xrotField);
            rotationRow.add(new BLabel("Y"));
            this.yrotField = new ValueField(angles[1], 0, 5);
            rotationRow.add(this.yrotField);
            rotationRow.add(new BLabel("Z"));
            this.zrotField = new ValueField(angles[2], 0, 5);
            rotationRow.add(this.zrotField);
            this.add(rotationRow, 0, 4, 3, 1);
            RowContainer applyRow = new RowContainer();
            applyRow.add(new BLabel(Translate.text("applyTo") + ":"));
            this.applyToChoice = new BComboBox(new String[]{Translate.text("frontAndBackFaces"), Translate.text("frontFacesOnly"), Translate.text("backFacesOnly")});
            applyRow.add(this.applyToChoice);
            this.add(applyRow, 0, 5, 3, 1);
            this.applyToChoice.setSelectedIndex(SphericalMapping.this.appliesTo());
            this.coordsFromParamsBox = new BCheckBox(Translate.text("bindTexToSurface"), SphericalMapping.this.coordsFromParams);
            this.add(this.coordsFromParamsBox, 0, 7, 3, 1);
            this.coordsFromParamsBox.setEnabled(this.theObject instanceof Mesh || this.theObject instanceof Actor);
            this.xscaleField.addEventLink(ValueChangedEvent.class, this);
            this.yscaleField.addEventLink(ValueChangedEvent.class, this);
            this.ytransField.addEventLink(ValueChangedEvent.class, this);
            this.xrotField.addEventLink(ValueChangedEvent.class, this);
            this.yrotField.addEventLink(ValueChangedEvent.class, this);
            this.zrotField.addEventLink(ValueChangedEvent.class, this);
            this.coordsFromParamsBox.addEventLink(ValueChangedEvent.class, this);
            this.applyToChoice.addEventLink(ValueChangedEvent.class, this);
        }

        private void processEvent() {
            SphericalMapping.this.xscale = this.xscaleField.getValue();
            SphericalMapping.this.yscale = this.yscaleField.getValue();
            SphericalMapping.this.offset = this.ytransField.getValue();
            SphericalMapping.this.coords.setOrientation(this.xrotField.getValue(), this.yrotField.getValue(), this.zrotField.getValue());
            SphericalMapping.this.findCoefficients();
            SphericalMapping.this.coordsFromParams = this.coordsFromParamsBox.getState();
            SphericalMapping.this.setAppliesTo((short)this.applyToChoice.getSelectedIndex());
            this.preview.setTexture(SphericalMapping.this.getTexture(), SphericalMapping.this);
            this.preview.render();
        }
    }
}

