/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.math.RGBColor;
import artofillusion.object.Object3D;
import artofillusion.texture.ProjectionMapping;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.util.ThreadManager;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;

public abstract class Texture2D
extends Texture {
    public abstract void getTextureSpec(TextureSpec var1, double var2, double var4, double var6, double var8, double var10, double var12, double[] var14);

    public abstract void getTransparency(RGBColor var1, double var2, double var4, double var6, double var8, double var10, double var12, double[] var14);

    @Override
    public TextureMapping getDefaultMapping(Object3D object) {
        return new ProjectionMapping(object, this);
    }

    public double getDisplacement(double x, double y, double xsize, double ysize, double t, double[] param) {
        return Double.NaN;
    }

    public boolean displacementMapped() {
        return !Double.isNaN(this.getDisplacement(0.0, 0.0, 0.0, 0.0, 0.0, null));
    }

    public Image createComponentImage(final double minu, double maxu, double minv, final double maxv, final int width, final int height, final int component, final double time, final double[] param) {
        final int[] pixel = new int[width * height];
        final double uscale = (maxu - minu) / (double)width;
        final double vscale = (maxv - minv) / (double)height;
        final ThreadLocal textureSpec = new ThreadLocal(){

            protected Object initialValue() {
                return new TextureSpec();
            }
        };
        ThreadManager threads = new ThreadManager(width, new ThreadManager.Task(){

            @Override
            public void execute(int i) {
                TextureSpec spec = (TextureSpec)textureSpec.get();
                block7: for (int j = 0; j < height; ++j) {
                    double u = minu + (double)i * uscale;
                    double v = maxv - (double)j * vscale;
                    Texture2D.this.getTextureSpec(spec, u, v, uscale, vscale, 1.0, time, param);
                    int index = i + j * width;
                    switch (component) {
                        case 0: {
                            pixel[index] = spec.diffuse.getARGB();
                            continue block7;
                        }
                        case 1: {
                            pixel[index] = spec.specular.getARGB();
                            continue block7;
                        }
                        case 2: {
                            pixel[index] = spec.transparent.getARGB();
                            continue block7;
                        }
                        case 3: {
                            pixel[index] = spec.hilight.getARGB();
                            continue block7;
                        }
                        case 4: {
                            pixel[index] = spec.emissive.getARGB();
                        }
                    }
                }
            }

            @Override
            public void cleanup() {
            }
        });
        threads.run();
        threads.finish();
        MemoryImageSource src = new MemoryImageSource(width, height, pixel, 0, width);
        return Toolkit.getDefaultToolkit().createImage(src);
    }
}

