/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.MeshViewer;
import artofillusion.MoveViewTool;
import artofillusion.ReshapeMeshTool;
import artofillusion.RotateMeshTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleMeshTool;
import artofillusion.Scene;
import artofillusion.ScrollViewTool;
import artofillusion.SkewMeshTool;
import artofillusion.TaperMeshTool;
import artofillusion.TextureParameter;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec2;
import artofillusion.object.FacetedMesh;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.ObjectWrapper;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.MoveUVViewTool;
import artofillusion.texture.Texture;
import artofillusion.texture.Texture2D;
import artofillusion.texture.UVMapping;
import artofillusion.texture.UVMappingViewer;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.GenericTool;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.ValueChangedEvent;
import buoy.event.WidgetEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BSplitPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;

public class UVMappingWindow
extends BDialog
implements MeshEditController,
EditingWindow {
    private ObjectInfo objInfo;
    private Object3D oldObj;
    private Mesh editObj;
    private UVMapping map;
    private Vec2[] coord;
    private UVMappingViewer mapView;
    private MeshViewer meshView;
    private ToolPalette tools;
    private MaterialPreviewer preview;
    private ValueField minuField;
    private ValueField minvField;
    private ValueField maxuField;
    private ValueField maxvField;
    private ValueField uField;
    private ValueField vField;
    private BComboBox componentChoice;
    private BComboBox resChoice;
    private BCheckBox faceBox;
    private boolean[] selectedVertices;
    private int selectMode;
    boolean[] selected;
    int[] selectionDistance;
    private static int resolution;

    public UVMappingWindow(BDialog parent, Object3D obj, UVMapping map) {
        super(parent, Translate.text("uvCoordsTitle"), true);
        Object3D meshObj = this.oldObj = obj;
        while (meshObj instanceof ObjectWrapper) {
            meshObj = ((ObjectWrapper)meshObj).getWrappedObject();
        }
        this.editObj = (Mesh)((Object)meshObj.duplicate());
        this.map = map;
        this.objInfo = new ObjectInfo((Object3D)((Object)this.editObj), new CoordinateSystem(), "");
        this.findTextureVertices();
        this.selected = new boolean[this.editObj.getVertices().length];
        this.selectedVertices = new boolean[0];
        double minu = Double.MAX_VALUE;
        double maxu = -1.7976931348623157E308;
        double minv = Double.MAX_VALUE;
        double maxv = -1.7976931348623157E308;
        for (int i = 0; i < this.coord.length; ++i) {
            if (this.coord[i].x < minu) {
                minu = this.coord[i].x;
            }
            if (this.coord[i].x > maxu) {
                maxu = this.coord[i].x;
            }
            if (this.coord[i].y < minv) {
                minv = this.coord[i].y;
            }
            if (!(this.coord[i].y > maxv)) continue;
            maxv = this.coord[i].y;
        }
        double padu = 0.1 * (maxu - minu);
        double padv = 0.1 * (maxv - minv);
        minu -= padu;
        maxu += padu;
        minv -= padv;
        maxv += padv;
        Texture tex = obj.getTexture();
        if (tex instanceof LayeredTexture) {
            LayeredMapping layered = (LayeredMapping)obj.getTextureMapping();
            for (int i = 0; i < layered.getNumLayers(); ++i) {
                if (layered.getLayerMapping(i) != map) continue;
                tex = layered.getLayer(i);
                break;
            }
        }
        TextureParameter[] param = map.getParameters();
        double[] paramVal = null;
        if (param != null) {
            paramVal = new double[param.length];
            for (int i = 0; i < param.length; ++i) {
                paramVal[i] = param[i].defaultVal;
            }
        }
        FormContainer content = new FormContainer(new double[]{1.0, 1.0}, new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0});
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.setContent(content);
        BorderContainer mapViewPanel = new BorderContainer();
        this.mapView = new UVMappingViewer((Texture2D)tex, this, minu, maxu, minv, maxv, 0, 1 << 2 - resolution, 0.0, paramVal);
        mapViewPanel.add(this.mapView, BorderContainer.CENTER);
        this.mapView.setPreferredSize(new Dimension(200, 200));
        this.tools = new ToolPalette(6, 1);
        mapViewPanel.add(this.tools, BorderContainer.NORTH);
        this.tools.setBackground(this.getBackground());
        ReshapeMeshTool defaultTool = new ReshapeMeshTool(this, this.mapView.getController());
        this.tools.addTool(defaultTool);
        this.tools.addTool(new ScaleMeshTool(this, this.mapView.getController()));
        this.tools.addTool(new RotateMeshTool(this, this.mapView.getController(), true));
        this.tools.addTool(new SkewMeshTool(this, this.mapView.getController()));
        this.tools.addTool(new TaperMeshTool(this, this.mapView.getController()));
        MoveUVViewTool metaTool = new MoveUVViewTool(this);
        this.tools.addTool(metaTool);
        this.mapView.setTool(defaultTool);
        this.mapView.setMetaTool(metaTool);
        this.meshView = this.editObj.createMeshViewer(this, new RowContainer());
        this.meshView.setMeshVisible(true);
        this.meshView.setPreferredSize(new Dimension(150, 150));
        this.meshView.setTool(new GenericTool(this, "movePoints", Translate.text("reshapeMeshTool.tipText")));
        this.meshView.setMetaTool(new MoveViewTool(this));
        this.meshView.setAltTool(new RotateViewTool(this));
        this.meshView.setScrollTool(new ScrollViewTool(this));
        this.preview = new MaterialPreviewer(this.objInfo, 150, 150);
        BSplitPane meshViewPanel = new BSplitPane(BSplitPane.VERTICAL, this.meshView, this.preview);
        meshViewPanel.setResizeWeight(0.7);
        meshViewPanel.setContinuousLayout(true);
        BSplitPane div = new BSplitPane(BSplitPane.HORIZONTAL, mapViewPanel, meshViewPanel);
        div.setResizeWeight(0.5);
        div.setContinuousLayout(true);
        content.add(div, 0, 0, 2, 1);
        RowContainer row = new RowContainer();
        content.add(row, 0, 1);
        row.add(Translate.label("displayedComponent"));
        this.componentChoice = new BComboBox(new String[]{Translate.text("Diffuse"), Translate.text("Specular"), Translate.text("Transparent"), Translate.text("Hilight"), Translate.text("Emissive")});
        row.add(this.componentChoice);
        this.componentChoice.addEventLink(ValueChangedEvent.class, (Object)this, "rebuildImage");
        content.add(Translate.label("selectedVertexCoords"), 0, 2);
        row = new RowContainer();
        content.add(row, 0, 3);
        row.add(new BLabel("U:"));
        this.uField = new ValueField(Double.NaN, 0, 5);
        row.add(this.uField);
        row.add(new BLabel(" V:"));
        this.vField = new ValueField(Double.NaN, 0, 5);
        row.add(this.vField);
        this.faceBox = new BCheckBox(Translate.text("mapFacesIndependently"), false);
        if (this.editObj instanceof FacetedMesh) {
            this.faceBox.setState(map.isPerFaceVertex((FacetedMesh)this.editObj));
            if (this.faceBox.getState()) {
                this.selectMode = 2;
                this.selected = new boolean[((FacetedMesh)this.editObj).getFaceCount()];
            }
            content.add(this.faceBox, 0, 4);
        }
        this.faceBox.addEventLink(ValueChangedEvent.class, (Object)this, "faceModeChanged");
        row = new RowContainer();
        content.add(row, 1, 1);
        row.add(new BLabel(Translate.text("Resolution") + ":"));
        this.resChoice = new BComboBox(new String[]{Translate.text("Low"), Translate.text("Medium"), Translate.text("High")});
        row.add(this.resChoice);
        this.resChoice.setSelectedIndex(resolution);
        this.resChoice.addEventLink(ValueChangedEvent.class, (Object)this, "rebuildImage");
        content.add(Translate.label("displayedCoordRange"), 1, 2);
        row = new RowContainer();
        content.add(row, 1, 3);
        row.add(new BLabel("U:"));
        this.minuField = new ValueField(minu, 0, 5);
        row.add(this.minuField);
        row.add(Translate.label("to"), new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(0, 5, 0, 5), null));
        this.maxuField = new ValueField(maxu, 0, 5);
        row.add(this.maxuField);
        row = new RowContainer();
        content.add(row, 1, 4);
        row.add(new BLabel("V:"));
        this.minvField = new ValueField(minv, 0, 5);
        row.add(this.minvField);
        row.add(Translate.label("to"), new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(0, 5, 0, 5), null));
        this.maxvField = new ValueField(maxv, 0, 5);
        row.add(this.maxvField);
        this.minuField.addEventLink(ValueChangedEvent.class, (Object)this, "rebuildImage");
        this.minvField.addEventLink(ValueChangedEvent.class, (Object)this, "rebuildImage");
        this.maxuField.addEventLink(ValueChangedEvent.class, (Object)this, "rebuildImage");
        this.maxvField.addEventLink(ValueChangedEvent.class, (Object)this, "rebuildImage");
        this.uField.addEventLink(ValueChangedEvent.class, (Object)this, "coordsChanged");
        this.vField.addEventLink(ValueChangedEvent.class, (Object)this, "coordsChanged");
        row = new RowContainer();
        content.add(row, 0, 5, 2, 1, new LayoutInfo());
        row.add(Translate.button("ok", this, "doOk"));
        row.add(Translate.button("cancel", this, "dispose"));
        this.pack();
        UIUtilities.centerDialog(this, parent);
        this.setVisible(true);
    }

    @Override
    public ObjectInfo getObject() {
        return this.objInfo;
    }

    @Override
    public void setMesh(Mesh mesh) {
        this.objInfo.setObject((Object3D)((Object)mesh));
        this.objInfo.clearCachedMeshes();
    }

    @Override
    public int getSelectionMode() {
        return this.selectMode;
    }

    @Override
    public void setSelectionMode(int mode) {
        this.selectMode = mode;
    }

    @Override
    public boolean[] getSelection() {
        return this.selected;
    }

    @Override
    public void setSelection(boolean[] selected) {
        this.selected = selected;
        this.meshView.repaint();
    }

    @Override
    public int[] getSelectionDistance() {
        if (this.selectionDistance == null) {
            this.findSelectionDistance();
        }
        return this.selectionDistance;
    }

    private void findSelectionDistance() {
        this.selectionDistance = new int[this.selected.length];
        for (int i = 0; i < this.selected.length; ++i) {
            this.selectionDistance[i] = this.selected[i] ? 0 : -1;
        }
    }

    @Override
    public double getMeshTension() {
        return 1.0;
    }

    @Override
    public int getTensionDistance() {
        return 0;
    }

    private void findTextureVertices() {
        boolean isPerFace = false;
        if (this.editObj instanceof FacetedMesh) {
            isPerFace = this.map.isPerFaceVertex((FacetedMesh)this.editObj);
        }
        if (isPerFace) {
            FacetedMesh mesh = (FacetedMesh)this.editObj;
            Vec2[][] faceCoord = this.map.findFaceTextureCoordinates(mesh);
            ArrayList<Vec2> coordList = new ArrayList<Vec2>();
            for (int i = 0; i < faceCoord.length; ++i) {
                for (int j = 0; j < faceCoord[i].length; ++j) {
                    coordList.add(faceCoord[i][j]);
                }
            }
            this.coord = coordList.toArray(new Vec2[coordList.size()]);
        } else {
            this.coord = this.map.findTextureCoordinates(this.editObj);
        }
    }

    private boolean findSelectedVertices() {
        int i;
        boolean[] newSelection;
        if (this.faceBox.getState()) {
            int faces = ((FacetedMesh)this.editObj).getFaceCount();
            newSelection = new boolean[faces * 3];
            for (i = 0; i < this.selected.length; ++i) {
                if (!this.selected[i]) continue;
                newSelection[3 * i + 2] = true;
                newSelection[3 * i + 1] = true;
                newSelection[3 * i] = true;
            }
        } else {
            newSelection = new boolean[this.selected.length];
            for (int i2 = 0; i2 < this.selected.length; ++i2) {
                newSelection[i2] = this.selected[i2];
            }
        }
        boolean changed = this.selectedVertices.length != newSelection.length;
        for (i = 0; i < newSelection.length && !changed; ++i) {
            if (this.selectedVertices[i] == newSelection[i]) continue;
            changed = true;
        }
        this.selectedVertices = newSelection;
        return changed;
    }

    @Override
    public void objectChanged() {
        this.mapView.objectChanged();
    }

    private void rebuildImage() {
        resolution = this.resChoice.getSelectedIndex();
        int res = 1 << 2 - resolution;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.mapView.setParameters(this.minuField.getValue(), this.maxuField.getValue(), this.minvField.getValue(), this.maxvField.getValue(), this.componentChoice.getSelectedIndex(), res);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void doOk() {
        if (this.faceBox.getState()) {
            int faces = ((FacetedMesh)this.editObj).getFaceCount();
            Vec2[][] texCoord = new Vec2[faces][];
            int index = 0;
            for (int i = 0; i < faces; ++i) {
                texCoord[i] = new Vec2[((FacetedMesh)this.editObj).getFaceVertexCount(i)];
                for (int j = 0; j < texCoord[i].length; ++j) {
                    texCoord[i][j] = this.coord[index++];
                }
            }
            this.map.setFaceTextureCoordinates(this.oldObj, texCoord);
        } else {
            this.map.setTextureCoordinates(this.oldObj, this.coord);
        }
        this.dispose();
    }

    private void faceModeChanged() {
        FacetedMesh mesh = (FacetedMesh)this.editObj;
        if (this.faceBox.getState()) {
            ArrayList<Vec2> coordList = new ArrayList<Vec2>();
            for (int i = 0; i < mesh.getFaceCount(); ++i) {
                for (int j = 0; j < mesh.getFaceVertexCount(i); ++j) {
                    coordList.add(new Vec2(this.coord[mesh.getFaceVertexIndex(i, j)]));
                }
            }
            this.setTextureCoords(coordList.toArray(new Vec2[coordList.size()]));
            this.selected = new boolean[mesh.getFaceCount()];
        } else {
            boolean consistent = true;
            Vec2[] newcoord = new Vec2[mesh.getVertices().length];
            int index = 0;
            for (int i = 0; i < mesh.getFaceCount(); ++i) {
                for (int j = 0; j < mesh.getFaceVertexCount(i); ++j) {
                    Vec2 v = new Vec2(this.coord[index++]);
                    int vertIndex = mesh.getFaceVertexIndex(i, j);
                    if (newcoord[vertIndex] != null && !newcoord[vertIndex].equals(v)) {
                        consistent = false;
                    }
                    newcoord[vertIndex] = v;
                }
            }
            if (!consistent) {
                String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
                int choice = new BStandardDialog("", UIUtilities.breakString("Disabling per-face mapping will cause some mapping information to be lost.  Are you sure you want to do this?"), BStandardDialog.QUESTION).showOptionDialog(this, options, options[1]);
                if (choice == 1) {
                    this.faceBox.setState(true);
                    return;
                }
            }
            this.setTextureCoords(newcoord);
            this.selected = new boolean[newcoord.length];
        }
        this.mapView.setDisplayedVertices(this.coord, new boolean[this.coord.length]);
        this.selectMode = this.faceBox.getState() ? 2 : 0;
        this.findSelectedVertices();
        this.rebuildImage();
        this.meshView.repaint();
    }

    private void coordsChanged(WidgetEvent ev) {
        Widget source = ev.getWidget();
        boolean[] sel = this.mapView.getSelection();
        for (int i = 0; i < sel.length; ++i) {
            if (!sel[i]) continue;
            if (source == this.uField && !Double.isNaN(this.uField.getValue())) {
                this.coord[i].x = this.uField.getValue();
            }
            if (source != this.vField || Double.isNaN(this.vField.getValue())) continue;
            this.coord[i].y = this.vField.getValue();
        }
        this.setTextureCoords(this.coord);
        this.mapView.updateVertexPositions(this.coord);
        this.mapView.repaint();
    }

    public void displayRangeChanged() {
        if (this.mapView == null) {
            return;
        }
        this.minuField.setValue(this.mapView.getMinU());
        this.minvField.setValue(this.mapView.getMinV());
        this.maxuField.setValue(this.mapView.getMaxU());
        this.maxvField.setValue(this.mapView.getMaxV());
    }

    public void setTextureCoords(Vec2[] coords) {
        this.coord = coords;
        if (this.faceBox.getState()) {
            FacetedMesh mesh = (FacetedMesh)this.editObj;
            Vec2[][] texCoord = new Vec2[mesh.getFaceCount()][];
            int index = 0;
            for (int i = 0; i < texCoord.length; ++i) {
                texCoord[i] = new Vec2[mesh.getFaceVertexCount(i)];
                for (int j = 0; j < texCoord[i].length; ++j) {
                    texCoord[i][j] = this.coord[index++];
                }
            }
            this.map.setFaceTextureCoordinates((Object3D)((Object)this.editObj), texCoord);
            this.map.setFaceTextureCoordinates(this.preview.getObject().getObject(), texCoord);
        } else {
            this.map.setTextureCoordinates((Object3D)((Object)this.editObj), coords);
            this.map.setTextureCoordinates(this.preview.getObject().getObject(), coords);
        }
        if (!this.mapView.isDragInProgress()) {
            this.preview.getObject().clearCachedMeshes();
            this.preview.render();
        }
    }

    @Override
    public ToolPalette getToolPalette() {
        return this.tools;
    }

    @Override
    public void setTool(EditingTool tool) {
        this.mapView.setTool(tool);
    }

    @Override
    public void setHelpText(String text) {
    }

    @Override
    public BFrame getFrame() {
        return UIUtilities.findFrame(this);
    }

    @Override
    public void updateImage() {
        this.mapView.repaint();
    }

    @Override
    public void updateMenus() {
        boolean selChanged = this.findSelectedVertices();
        if (selChanged) {
            this.mapView.setDisplayedVertices(this.coord, this.selectedVertices);
        }
        this.updateTextFields();
    }

    public void updateTextFields() {
        boolean[] sel = this.mapView.getSelection();
        boolean any = false;
        double u = 0.0;
        double v = 0.0;
        for (int i = 0; i < sel.length; ++i) {
            if (!sel[i]) continue;
            if (!any) {
                u = this.coord[i].x;
                v = this.coord[i].y;
                any = true;
                continue;
            }
            if (u != this.coord[i].x) {
                u = Double.NaN;
            }
            if (v == this.coord[i].y) continue;
            v = Double.NaN;
        }
        this.uField.setValue(any ? u : Double.NaN);
        this.vField.setValue(any ? v : Double.NaN);
        this.uField.setEnabled(any);
        this.vField.setEnabled(any);
    }

    @Override
    public void setUndoRecord(UndoRecord command) {
    }

    @Override
    public void setModified() {
    }

    @Override
    public Scene getScene() {
        return null;
    }

    @Override
    public ViewerCanvas getView() {
        return this.mapView;
    }

    @Override
    public ViewerCanvas[] getAllViews() {
        return new ViewerCanvas[]{this.mapView};
    }

    @Override
    public boolean confirmClose() {
        return true;
    }
}

