/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.math.RGBColor;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformMapping;
import artofillusion.texture.UniformTexture;

public class UniformTriangle
extends RenderingTriangle {
    private UniformMapping map;

    public UniformTriangle(int v1, int v2, int v3, int n1, int n2, int n3) {
        super(v1, v2, v3, n1, n2, n3);
    }

    @Override
    public void setMesh(RenderingMesh mesh, TextureMapping map, int index) {
        super.setMesh(mesh, map, index);
        this.map = (UniformMapping)map;
    }

    @Override
    public void getTextureSpec(TextureSpec spec, double angle, double u, double v, double w, double size, double t) {
        if (!this.map.appliesToFace(angle > 0.0)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        ((UniformTexture)this.map.getTexture()).getTextureSpec(spec);
    }

    @Override
    public void getTransparency(RGBColor trans, double angle, double u, double v, double w, double size, double t) {
        if (!this.map.appliesToFace(angle > 0.0)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        ((UniformTexture)this.map.getTexture()).getTransparency(trans);
    }

    @Override
    public double getDisplacement(double u, double v, double w, double size, double t) {
        return 0.0;
    }
}

