/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ui.ThemeManager;
import artofillusion.ui.ToolButton;
import artofillusion.util.IconGenerator;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class DefaultToolButton
extends ToolButton {
    protected Image icon;
    protected Image selectedIcon;

    public DefaultToolButton(Object owner, ImageIcon image) {
        super(owner);
        ThemeManager.ButtonStyle bstyle = ThemeManager.getButtonStyle(owner);
        if (bstyle != null) {
            try {
                this.icon = this.applyStyle(bstyle, "normal", owner, image);
                this.selectedIcon = this.applyStyle(bstyle, "selected", owner, image);
            }
            catch (Exception e) {
                System.out.println("Applying style: " + e);
            }
        }
        if (this.icon == null || this.icon.getWidth(null) <= 0) {
            this.icon = image.getImage();
        }
        if (this.icon == null || this.icon.getWidth(null) <= 0) {
            this.icon = ThemeManager.getNotFoundIcon(owner).getImage();
        }
        if (this.selectedIcon == null) {
            this.selectedIcon = IconGenerator.copy(this.icon);
            IconGenerator.multiply((BufferedImage)this.selectedIcon, 1.0f, 1.0f, 0.5f, 0.5f);
        }
        this.width = this.icon.getWidth(null);
        this.height = this.icon.getHeight(null);
    }

    public DefaultToolButton(Object owner, ImageIcon icon, ImageIcon selectedIcon) {
        super(owner);
        this.icon = icon.getImage();
        this.selectedIcon = selectedIcon.getImage();
        this.height = icon.getIconHeight();
        this.width = icon.getIconWidth();
    }

    @Override
    public void paint(Graphics2D g) {
        switch (this.state) {
            case 0: 
            case 2: {
                g.drawImage(this.icon, this.position.x, this.position.y, null);
                break;
            }
            case 1: {
                g.drawImage(this.selectedIcon, this.position.x, this.position.y, null);
            }
        }
    }

    public Image applyStyle(ThemeManager.ButtonStyle style, String type, Object owner, ImageIcon image) throws Exception {
        String macro = style.attributes.get(type + ".icon");
        if (macro == null || macro.length() == 0) {
            StringBuilder sb = new StringBuilder(64);
            String att = style.attributes.get(type + ".background");
            if (att == null) {
                att = style.attributes.get("background");
            }
            if (att != null) {
                sb.append(att);
                sb.append("; {icon};");
                att = style.attributes.get(type + ".overlay");
                if (att == null) {
                    att = style.attributes.get("overlay");
                }
                if (att != null) {
                    sb.append(att);
                }
                macro = sb.toString();
            } else {
                return image.getImage();
            }
        }
        HashMap<String, Object> namespace = new HashMap<String, Object>(style.attributes);
        if (image != null) {
            Image img = image.getImage();
            namespace.put("{icon}", (String)((Object)img));
            namespace.put('{' + type + ".icon}", img);
        }
        namespace.put("{owner}", (String)owner);
        ClassLoader loader = ThemeManager.getSelectedTheme().loader;
        return IconGenerator.apply(macro, null, namespace, loader, style.width, style.height);
    }
}

