/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ui.Translate;
import buoy.event.SelectionChangedEvent;
import buoy.widget.BFileChooser;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ImageFileChooser
extends BFileChooser {
    private JLabel preview = new JLabel();
    private static final int PREVIEW_SIZE = 200;
    private static final int INSET = 5;
    private static final Preferences pref = Preferences.userNodeForPackage(ImageFileChooser.class);

    public ImageFileChooser(String title) {
        super(BFileChooser.OPEN_FILE, title);
        this.preview.setPreferredSize(new Dimension(210, 210));
        this.preview.setHorizontalAlignment(0);
        this.preview.setVerticalAlignment(0);
        JFileChooser jfc = this.getComponent();
        jfc.setAccessory(this.preview);
        jfc.addChoosableFileFilter(new FileNameExtensionFilter(Translate.text("fileFilter.images"), "gif", "hdr", "hdri", "jpg", "jpeg", "jpe", "jif", "jfif", "pic", "png", "svg"));
        jfc.addChoosableFileFilter(new FileNameExtensionFilter(Translate.text("fileFilter.gif"), "gif"));
        jfc.addChoosableFileFilter(new FileNameExtensionFilter(Translate.text("fileFilter.hdr"), "hdr", "hdri", "pic"));
        jfc.addChoosableFileFilter(new FileNameExtensionFilter(Translate.text("fileFilter.jpeg"), "jpg", "jpeg", "jpe", "jif", "jfif"));
        jfc.addChoosableFileFilter(new FileNameExtensionFilter(Translate.text("fileFilter.pic"), "pic"));
        jfc.addChoosableFileFilter(new FileNameExtensionFilter(Translate.text("fileFilter.png"), "png"));
        jfc.addChoosableFileFilter(new FileNameExtensionFilter(Translate.text("fileFilter.svg"), "svg"));
        jfc.setAcceptAllFileFilterUsed(true);
        String preferredType = pref.get("LastType", Translate.text("fileFilter.images"));
        FileFilter preferredFilter = null;
        for (FileFilter filter : jfc.getChoosableFileFilters()) {
            if (!filter.getDescription().equals(preferredType)) continue;
            preferredFilter = filter;
        }
        if (preferredFilter == null) {
            preferredFilter = jfc.getAcceptAllFileFilter();
        }
        this.setFileFilter(preferredFilter);
        this.addEventLink(SelectionChangedEvent.class, (Object)this, "selectionChanged");
        this.selectionChanged();
    }

    @Override
    public boolean showDialog(Widget parent) {
        if (super.showDialog(parent)) {
            pref.put("LastType", this.getFileFilter().getDescription());
            return true;
        }
        return false;
    }

    private void selectionChanged() {
        File file = null;
        if (this.isMultipleSelectionEnabled()) {
            File[] files = this.getSelectedFiles();
            if (files.length > 1) {
                this.preview.setIcon(null);
                this.preview.setText(null);
                return;
            }
            if (files.length == 1) {
                file = files[0];
            }
        } else {
            file = this.getSelectedFile();
        }
        if (file == null || !file.isFile()) {
            this.preview.setIcon(null);
            this.preview.setText(Translate.text("noFileSelected"));
        } else {
            ImageIcon image = new ImageIcon(file.getAbsolutePath());
            if (image.getImageLoadStatus() != 8) {
                this.preview.setIcon(null);
                this.preview.setText(Translate.text("noPreviewAvailable"));
            } else {
                this.preview.setText(null);
                int width = image.getIconWidth();
                int height = image.getIconHeight();
                if (width > 200 && width >= height) {
                    image = new ImageIcon(image.getImage().getScaledInstance(200, -1, 1));
                } else if (height > 200) {
                    image = new ImageIcon(image.getImage().getScaledInstance(-1, 200, 1));
                }
                this.preview.setIcon(image);
            }
        }
    }
}

