/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.Camera;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.ui.Manipulator;
import buoy.event.EventSource;
import buoy.event.WidgetMouseEvent;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import javax.imageio.ImageIO;

public class NinePointManipulator
extends EventSource
implements Manipulator {
    private final Image[] images;
    private Rectangle screenBounds;
    private BoundingBox selectionBounds;
    private HandlePosition handle;
    private int imageWidth;
    private int imageHeight;
    public static final Image ARROWS_N_S = NinePointManipulator.loadImage("arrows_N_S.gif");
    public static final Image ARROWS_E_W = NinePointManipulator.loadImage("arrows_E_W.gif");
    public static final Image ARROWS_NW_SE = NinePointManipulator.loadImage("arrows_NW_SE.gif");
    public static final Image ARROWS_NE_SW = NinePointManipulator.loadImage("arrows_NE_SW.gif");
    public static final Image ARROWS_N_W = NinePointManipulator.loadImage("arrows_N_W.gif");
    public static final Image ARROWS_N_E = NinePointManipulator.loadImage("arrows_N_E.gif");
    public static final Image ARROWS_S_W = NinePointManipulator.loadImage("arrows_S_W.gif");
    public static final Image ARROWS_S_E = NinePointManipulator.loadImage("arrows_S_E.gif");
    public static final Image ARROWS_ALL = NinePointManipulator.loadImage("arrows_all.gif");
    public static final Image ROTATE_TOP = NinePointManipulator.loadImage("rotate_top.gif");
    public static final Image ROTATE_BOTTOM = NinePointManipulator.loadImage("rotate_bottom.gif");
    public static final Image ROTATE_LEFT = NinePointManipulator.loadImage("rotate_left.gif");
    public static final Image ROTATE_RIGHT = NinePointManipulator.loadImage("rotate_right.gif");
    public static final Image ROTATE_TOPLEFT = NinePointManipulator.loadImage("rotate_topleft.gif");
    public static final Image ROTATE_TOPRIGHT = NinePointManipulator.loadImage("rotate_topright.gif");
    public static final Image ROTATE_BOTTOMLEFT = NinePointManipulator.loadImage("rotate_bottomleft.gif");
    public static final Image ROTATE_BOTTOMRIGHT = NinePointManipulator.loadImage("rotate_bottomright.gif");
    public static final HandlePosition NW = new HandlePosition(0, 0);
    public static final HandlePosition N = new HandlePosition(1, 0);
    public static final HandlePosition NE = new HandlePosition(2, 0);
    public static final HandlePosition W = new HandlePosition(0, 1);
    public static final HandlePosition CENTER = new HandlePosition(1, 1);
    public static final HandlePosition E = new HandlePosition(2, 1);
    public static final HandlePosition SW = new HandlePosition(0, 2);
    public static final HandlePosition S = new HandlePosition(1, 2);
    public static final HandlePosition SE = new HandlePosition(2, 2);
    private static final HandlePosition[] ALL_HANDLES = new HandlePosition[]{NW, N, NE, W, CENTER, E, SW, S, SE};
    private static final int MARGIN = 4;

    private static Image loadImage(String name) {
        try {
            return ImageIO.read(NinePointManipulator.class.getResource("/artofillusion/ui/manipulatorIcons/" + name));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public NinePointManipulator(Image[] images) {
        this.images = (Image[])images.clone();
        for (int i = 0; i < images.length; ++i) {
            if (images[i] == null) continue;
            this.imageWidth = images[i].getWidth(null);
            this.imageHeight = images[i].getHeight(null);
        }
    }

    @Override
    public void draw(ViewerCanvas view, BoundingBox selectionBounds) {
        Rectangle r = this.findScreenBounds(selectionBounds, view.getCamera());
        if (r == null) {
            return;
        }
        int[] x = new int[]{r.x, r.x + (r.width - this.imageWidth) / 2, r.x + r.width - this.imageWidth};
        int[] y = new int[]{r.y, r.y + (r.height - this.imageHeight) / 2, r.y + r.height - this.imageHeight};
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int index = j * 3 + i;
                if (this.images[index] == null) continue;
                view.drawImage(this.images[index], x[i], y[j]);
            }
        }
    }

    @Override
    public boolean mousePressed(WidgetMouseEvent ev, ViewerCanvas view, BoundingBox selectionBounds) {
        this.handle = null;
        Rectangle r = this.findScreenBounds(selectionBounds, view.getCamera());
        Point pos = ev.getPoint();
        if (r == null || !r.contains(pos)) {
            return false;
        }
        int x = -1;
        int y = -1;
        if (pos.x < r.x + this.imageWidth) {
            x = 0;
        } else if (pos.x > r.x + (r.width - this.imageWidth) / 2 && pos.x < r.x + (r.width + this.imageWidth) / 2) {
            x = 1;
        } else if (pos.x > r.x + r.width - this.imageWidth) {
            x = 2;
        }
        if (pos.y < r.y + this.imageWidth) {
            y = 0;
        } else if (pos.y > r.y + (r.height - this.imageHeight) / 2 && pos.y < r.y + (r.height + this.imageHeight) / 2) {
            y = 1;
        } else if (pos.y > r.y + r.height - this.imageHeight) {
            y = 2;
        }
        if (x == -1 || y == -1 || this.images[x + y * 3] == null) {
            return false;
        }
        this.screenBounds = r;
        this.selectionBounds = selectionBounds;
        this.handle = ALL_HANDLES[y * 3 + x];
        this.dispatchEvent(new HandlePressedEvent(view, this.handle, this.screenBounds, selectionBounds, ev));
        return true;
    }

    @Override
    public void mouseDragged(WidgetMouseEvent ev, ViewerCanvas view) {
        if (this.handle != null) {
            this.dispatchEvent(new HandleDraggedEvent(view, this.handle, this.screenBounds, this.selectionBounds, ev));
        }
    }

    @Override
    public void mouseReleased(WidgetMouseEvent ev, ViewerCanvas view) {
        if (this.handle != null) {
            this.dispatchEvent(new HandleReleasedEvent(view, this.handle, this.screenBounds, this.selectionBounds, ev));
        }
        this.handle = null;
    }

    private Rectangle findScreenBounds(BoundingBox b, Camera cam) {
        Mat4 m = cam.getObjectToWorld();
        cam.setObjectTransform(cam.getViewToWorld());
        Rectangle r = cam.findScreenBounds(b);
        cam.setObjectTransform(m);
        if (r != null) {
            r.setBounds(r.x - this.imageWidth - 4, r.y - this.imageHeight - 4, r.width + 2 * this.imageWidth + 8, r.height + 2 * this.imageHeight + 8);
        }
        return r;
    }

    public class HandleReleasedEvent
    extends HandleEvent {
        private HandleReleasedEvent(ViewerCanvas view, HandlePosition handle, Rectangle screenBounds, BoundingBox selectionBounds, WidgetMouseEvent event) {
            super(view, handle, screenBounds, selectionBounds, event);
        }
    }

    public class HandleDraggedEvent
    extends HandleEvent {
        private HandleDraggedEvent(ViewerCanvas view, HandlePosition handle, Rectangle screenBounds, BoundingBox selectionBounds, WidgetMouseEvent event) {
            super(view, handle, screenBounds, selectionBounds, event);
        }
    }

    public class HandlePressedEvent
    extends HandleEvent {
        private HandlePressedEvent(ViewerCanvas view, HandlePosition handle, Rectangle screenBounds, BoundingBox selectionBounds, WidgetMouseEvent event) {
            super(view, handle, screenBounds, selectionBounds, event);
        }
    }

    public class HandleEvent {
        private ViewerCanvas view;
        private HandlePosition handle;
        private Rectangle screenBounds;
        private BoundingBox selectionBounds;
        private WidgetMouseEvent event;

        private HandleEvent(ViewerCanvas view, HandlePosition handle, Rectangle screenBounds, BoundingBox selectionBounds, WidgetMouseEvent event) {
            this.view = view;
            this.handle = handle;
            this.screenBounds = screenBounds;
            this.selectionBounds = selectionBounds;
            this.event = event;
        }

        public ViewerCanvas getView() {
            return this.view;
        }

        public HandlePosition getHandle() {
            return this.handle;
        }

        public Rectangle getScreenBounds() {
            return new Rectangle(this.screenBounds);
        }

        public BoundingBox getSelectionBounds() {
            return new BoundingBox(this.selectionBounds);
        }

        public WidgetMouseEvent getMouseEvent() {
            return this.event;
        }

        public NinePointManipulator getManipulator() {
            return NinePointManipulator.this;
        }
    }

    public static class HandlePosition {
        private int x;
        private int y;

        private HandlePosition(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean isWest() {
            return this.x == 0;
        }

        public boolean isEast() {
            return this.x == 2;
        }

        public boolean isNorth() {
            return this.y == 0;
        }

        public boolean isSouth() {
            return this.y == 2;
        }
    }
}

