/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ui.ToolButton;
import buoy.event.MouseEnteredEvent;
import buoy.event.MouseExitedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.RepaintEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.CustomWidget;
import java.awt.Dimension;

public class ToolButtonWidget
extends CustomWidget {
    private ToolButton button;

    public ToolButtonWidget(ToolButton button) {
        this.button = button;
        this.addEventLink(MousePressedEvent.class, (Object)this, "doButtonPressed");
        this.addEventLink(MouseEnteredEvent.class, (Object)this, "doMouseEntered");
        this.addEventLink(MouseExitedEvent.class, (Object)this, "doMouseExited");
        this.addEventLink(RepaintEvent.class, (Object)this, "paint");
    }

    @Override
    public Dimension getMinimumSize() {
        return this.button.getSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.button.getSize();
    }

    public void setSelected(boolean selected) {
        this.button.setSelected(selected);
        this.repaint();
    }

    public boolean isSelected() {
        return this.button.isSelected();
    }

    private void doButtonPressed() {
        this.button.setSelected(!this.button.isSelected());
        this.dispatchEvent(new ValueChangedEvent(this));
        this.repaint();
    }

    private void doMouseEntered() {
        this.button.setHighlighted(true);
        this.repaint();
    }

    private void doMouseExited() {
        this.button.setHighlighted(false);
        this.repaint();
    }

    public void paint(RepaintEvent ev) {
        this.button.paint(ev.getGraphics());
    }
}

