/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.LayoutWindow;
import artofillusion.ObjectEditorWindow;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ThemeManager;
import buoy.event.KeyPressedEvent;
import buoy.event.MouseClickedEvent;
import buoy.event.MouseEnteredEvent;
import buoy.event.MouseExitedEvent;
import buoy.event.MouseMovedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.RepaintEvent;
import buoy.event.ToolTipEvent;
import buoy.widget.BToolTip;
import buoy.widget.CustomWidget;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;

public class ToolPalette
extends CustomWidget {
    private int width;
    private int height;
    private int numTools;
    private int selected;
    private int lastSelected;
    private int defaultTool;
    private EditingTool[] tool;
    private Dimension maxsize;
    private EditingWindow window;

    public ToolPalette(int w, int h) {
        this(w, h, null);
    }

    public ToolPalette(int w, int h, EditingWindow win) {
        this.width = w;
        this.height = h;
        this.window = win;
        this.tool = new EditingTool[w * h];
        this.numTools = 0;
        this.selected = 0;
        this.defaultTool = 0;
        this.maxsize = new Dimension(0, 0);
        this.addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
        this.addEventLink(MouseClickedEvent.class, (Object)this, "mouseClicked");
        this.addEventLink(MouseEnteredEvent.class, (Object)this, "mouseEntered");
        this.addEventLink(MouseExitedEvent.class, (Object)this, "mouseExited");
        this.addEventLink(MouseMovedEvent.class, (Object)this, "mouseMoved");
        this.addEventLink(RepaintEvent.class, (Object)this, "paint");
        this.addEventLink(ToolTipEvent.class, (Object)this, "showToolTip");
        this.setBackground(ThemeManager.getPaletteBackgroundColor());
    }

    public void addTool(EditingTool t) {
        this.addTool(this.numTools, t);
    }

    public void addTool(int position, EditingTool t) {
        if (this.numTools == this.tool.length) {
            ++this.height;
            EditingTool[] newTool = new EditingTool[this.width * this.height];
            System.arraycopy(this.tool, 0, newTool, 0, this.tool.length);
            this.tool = newTool;
            this.invalidateSize();
        }
        for (int i = this.numTools; i > position; --i) {
            this.tool[i] = this.tool[i - 1];
        }
        this.tool[position] = t;
        ++this.numTools;
        int buttonMargin = ThemeManager.getButtonMargin();
        int paletteMargin = ThemeManager.getPaletteMargin();
        int w = t.getButton().getWidth() + 2 * buttonMargin;
        int h = t.getButton().getHeight() + 2 * buttonMargin;
        if (w > this.maxsize.width) {
            this.maxsize.width = w;
        }
        if (h > this.maxsize.height) {
            this.maxsize.height = h;
        }
        for (int i = 0; i < this.numTools; ++i) {
            this.tool[i].getButton().setPosition(i % this.width * this.maxsize.width + paletteMargin + buttonMargin, i / this.width * this.maxsize.height + paletteMargin + buttonMargin);
        }
        if (this.numTools == 1) {
            t.activate();
        }
    }

    public int getNumTools() {
        return this.numTools;
    }

    public EditingTool getTool(int index) {
        return this.tool[index];
    }

    public EditingTool getDefaultTool() {
        return this.tool[this.defaultTool];
    }

    public void setDefaultTool(EditingTool t) {
        for (int i = 0; i < this.tool.length; ++i) {
            if (this.tool[i] != t) continue;
            this.defaultTool = i;
        }
    }

    public int getSelection() {
        return this.selected;
    }

    public EditingTool getSelectedTool() {
        return this.tool[this.selected];
    }

    private void paint(RepaintEvent ev) {
        int i;
        Graphics2D g = ev.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int paletteMargin = ThemeManager.getPaletteMargin();
        g.setColor(ThemeManager.getPaletteBackgroundColor());
        g.fillRoundRect(0, 0, this.width * this.maxsize.width + 2 * paletteMargin, this.height * this.maxsize.height + 2 * paletteMargin, 8, 8);
        for (i = 0; i < this.numTools; ++i) {
            if (this.tool[i].getButton().isSelected() || this.tool[i].getButton().isHighlighted()) continue;
            this.tool[i].getButton().paint(g);
        }
        for (i = 0; i < this.numTools; ++i) {
            if (this.tool[i].getButton().isSelected() || !this.tool[i].getButton().isHighlighted()) continue;
            this.tool[i].getButton().paint(g);
        }
        for (i = 0; i < this.numTools; ++i) {
            if (!this.tool[i].getButton().isSelected()) continue;
            this.tool[i].getButton().paint(g);
        }
    }

    private void showToolTip(ToolTipEvent ev) {
        int i = this.findClickedTool(ev.getPoint());
        if (i > -1 && i < this.numTools) {
            String text = this.tool[i].getToolTipText();
            if (text == null) {
                BToolTip.hide();
            } else {
                new BToolTip(text).processEvent(ev);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int paletteMargin = ThemeManager.getPaletteMargin();
        return new Dimension(this.width * this.maxsize.width + 2 * paletteMargin, this.height * this.maxsize.height + 2 * paletteMargin);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private void mousePressed(MousePressedEvent e) {
        int i = this.findClickedTool(e.getPoint());
        if (i > -1 && i < this.numTools && i != this.selected) {
            if (this.selected < this.tool.length) {
                this.tool[this.selected].deactivate();
            }
            this.selected = this.lastSelected = i;
            this.repaint();
            this.tool[i].activate();
        }
        if (this.window != null) {
            if (this.window instanceof LayoutWindow) {
                ((LayoutWindow)this.window).toolChanged(this.tool[i]);
            }
            if (this.window instanceof ObjectEditorWindow) {
                ((ObjectEditorWindow)this.window).toolChanged(this.tool[i]);
            }
        }
    }

    private void mouseClicked(MouseClickedEvent e) {
        int i = this.findClickedTool(e.getPoint());
        if (i > -1 && i < this.numTools && e.getClickCount() == 2) {
            this.tool[i].iconDoubleClicked();
        }
    }

    private void mouseEntered(MouseEnteredEvent ev) {
        int t = this.findClickedTool(ev.getPoint());
        for (int i = 0; i < this.numTools; ++i) {
            this.tool[i].getButton().setHighlighted(t == i);
        }
        this.repaint();
    }

    private void mouseExited() {
        for (int i = 0; i < this.numTools; ++i) {
            this.tool[i].getButton().setHighlighted(false);
        }
        this.repaint();
    }

    private void mouseMoved(MouseMovedEvent ev) {
        int t = this.findClickedTool(ev.getPoint());
        for (int i = 0; i < this.numTools; ++i) {
            this.tool[i].getButton().setHighlighted(t == i);
        }
        this.repaint();
    }

    private int findClickedTool(Point p) {
        Rectangle r = new Rectangle();
        for (int i = 0; i < this.numTools; ++i) {
            Point pos = this.tool[i].getButton().getPosition();
            r.x = pos.x;
            r.y = pos.y;
            r.width = this.tool[i].getButton().getWidth();
            r.height = this.tool[i].getButton().getHeight();
            if (!r.contains(p)) continue;
            return i;
        }
        return -1;
    }

    public void selectTool(EditingTool which) {
        this.selectToolInternal(which);
        this.lastSelected = this.selected;
    }

    private void selectToolInternal(EditingTool which) {
        for (int i = 0; i < this.numTools; ++i) {
            if (this.tool[i] != which) continue;
            this.tool[this.selected].deactivate();
            this.selected = i;
            this.repaint();
            this.tool[i].activate();
        }
    }

    public void keyPressed(KeyPressedEvent ev) {
        int newtool;
        int code = ev.getKeyCode();
        if (code == 37) {
            newtool = this.selected - 1;
        } else if (code == 39) {
            newtool = this.selected + 1;
        } else if (code == 38) {
            newtool = this.selected - this.width;
        } else if (code == 40) {
            newtool = this.selected + this.width;
        } else {
            return;
        }
        if (newtool < 0) {
            newtool += this.numTools;
        }
        if (newtool >= this.numTools) {
            newtool -= this.numTools;
        }
        this.tool[this.selected].deactivate();
        this.selected = this.lastSelected = newtool;
        this.repaint();
        this.tool[this.selected].activate();
    }

    public void toggleDefaultTool() {
        this.selectToolInternal(this.tool[this.selected == this.lastSelected ? this.defaultTool : this.lastSelected]);
    }
}

