/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.view;

import artofillusion.ObjectViewer;
import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.ViewerCanvas;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.TriangleMath;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import java.awt.Point;

public class ClickedPointFinder {
    private double[] bary;
    private Mat4 modelToScreen;
    private int w;
    private int h;
    private Vec3 cameraOrigin;
    private Vec3 cameraZ;
    private boolean perspective;

    public Vec3 newPoint(ViewerCanvas v, Point point) {
        Vec3 clickedPoint = v.getCamera().convertScreenToWorld(point, v.getDistToPlane());
        boolean inSpace = true;
        this.bary = new double[3];
        this.cameraOrigin = v.getCamera().getCameraCoordinates().getOrigin();
        this.cameraZ = v.getCamera().getCameraCoordinates().getZDirection();
        this.perspective = v.isPerspective();
        this.w = v.getBounds().width;
        this.h = v.getBounds().height;
        this.modelToScreen = v instanceof ObjectViewer && !((ObjectViewer)v).getUseWorldCoords() ? v.getCamera().getObjectToScreen() : v.getCamera().getWorldToScreen();
        ObjectInfo[] objList = this.renderableObjects(v);
        Vec3[] corner3D = new Vec3[3];
        Vec2[] corner2D = new Vec2[3];
        Vec2[] corner2DS = new Vec2[3];
        CoordinateSystem localCoords = this.getLocalCoords(v);
        Mat4 toThisObject = localCoords.toLocal();
        for (int i = 0; i < objList.length; ++i) {
            RenderingMesh rMesh = objList[i].getPreviewMesh();
            Mat4 toScene = objList[i].getCoords().fromLocal();
            Mat4 fromExtToLocal = toThisObject.times(toScene);
            for (int j = 0; j < rMesh.triangle.length; ++j) {
                corner3D[0] = new Vec3(fromExtToLocal.times(rMesh.vert[rMesh.triangle[j].v1]));
                corner3D[1] = new Vec3(fromExtToLocal.times(rMesh.vert[rMesh.triangle[j].v2]));
                corner3D[2] = new Vec3(fromExtToLocal.times(rMesh.vert[rMesh.triangle[j].v3]));
                corner2D[0] = this.modelToScreen.timesXY(corner3D[0]);
                corner2D[1] = this.modelToScreen.timesXY(corner3D[1]);
                corner2D[2] = this.modelToScreen.timesXY(corner3D[2]);
                if (!this.onTriangle(corner2D, point)) continue;
                corner3D[0] = corner3D[0];
                corner3D[0].scale(this.bary[0]);
                corner3D[1] = corner3D[1];
                corner3D[1].scale(this.bary[1]);
                corner3D[2] = corner3D[2];
                corner3D[2].scale(this.bary[2]);
                Vec3 pointOnTriangle = new Vec3(corner3D[0].plus(corner3D[1].plus(corner3D[2])));
                if (!this.onScreen(pointOnTriangle)) continue;
                if (inSpace) {
                    clickedPoint = pointOnTriangle;
                    inSpace = false;
                    continue;
                }
                if (!this.closer(pointOnTriangle, clickedPoint) || !this.onFrontSide(pointOnTriangle)) continue;
                clickedPoint = pointOnTriangle;
            }
        }
        return clickedPoint;
    }

    private boolean closer(Vec3 p1, Vec3 p2) {
        return p1.minus(this.cameraOrigin).dot(this.cameraZ) < p2.minus(this.cameraOrigin).dot(this.cameraZ);
    }

    private boolean onFrontSide(Vec3 p) {
        if (!this.perspective) {
            return true;
        }
        return p.minus(this.cameraOrigin).dot(this.cameraZ) > 0.0;
    }

    private boolean onTriangle(Vec2[] corner2D, Point point) {
        this.bary = TriangleMath.baryCoordinates(corner2D, point);
        return this.bary[0] >= 0.0 && this.bary[1] >= 0.0 && this.bary[2] >= 0.0;
    }

    private boolean onScreen(Vec3 p3D) {
        Vec2 p2D = this.modelToScreen.timesXY(p3D);
        return p2D.x > 0.0 && p2D.x < (double)this.w && p2D.y > 0.0 && p2D.y < (double)this.h;
    }

    private ObjectInfo[] renderableObjects(ViewerCanvas v) {
        Scene scene = v.getScene();
        int n = scene.getNumObjects();
        int m = 0;
        ObjectInfo[] rObjI = new ObjectInfo[n];
        for (int i = 0; i < n; ++i) {
            ObjectInfo oi = scene.getObject(i);
            if (!oi.isVisible() || !oi.getObject().canSetTexture()) continue;
            rObjI[m] = oi;
            ++m;
        }
        ObjectInfo[] vObjI = new ObjectInfo[m];
        for (int i = 0; i < m; ++i) {
            vObjI[i] = rObjI[i];
        }
        return vObjI;
    }

    CoordinateSystem getLocalCoords(ViewerCanvas v) {
        if (v instanceof ObjectViewer && !((ObjectViewer)v).getUseWorldCoords()) {
            ((ObjectViewer)v).setUseWorldCoords(true);
            CoordinateSystem c = ((ObjectViewer)v).getDisplayCoordinates().duplicate();
            ((ObjectViewer)v).setUseWorldCoords(false);
            return c;
        }
        return new CoordinateSystem();
    }
}

