/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.view;

import artofillusion.ViewerCanvas;
import artofillusion.ui.Translate;
import artofillusion.view.ViewChangedEvent;
import artofillusion.view.ViewerControl;
import buoy.event.ValueChangedEvent;
import buoy.widget.BComboBox;
import buoy.widget.Widget;

public class ViewerNavigationControl
implements ViewerControl {
    @Override
    public Widget createWidget(ViewerCanvas view) {
        return new NavigationChoice(view);
    }

    @Override
    public String getName() {
        return Translate.text("Navigation");
    }

    public Object getItem(int index) {
        return this.getItem(index);
    }

    public static class NavigationChoice
    extends BComboBox {
        private final ViewerCanvas view;

        private NavigationChoice(ViewerCanvas view) {
            super(new String[]{Translate.text("ModelSpace"), Translate.text("ModelLandscape"), Translate.text("TravelSpace"), Translate.text("TravelLandscape")});
            this.view = view;
            this.setSelectedIndex(0);
            this.addEventLink(ValueChangedEvent.class, (Object)this, "valueChanged");
            view.addEventLink(ViewChangedEvent.class, (Object)this, "viewChanged");
            this.setPreferredVisibleRows(4);
        }

        private void valueChanged() {
            int selectedValue = this.getSelectedIndex();
            this.view.perspectiveControlEnabled = selectedValue <= 1;
            this.view.lastSetNavigation = selectedValue;
            this.view.setNavigationMode(selectedValue);
        }

        private void viewChanged() {
            if (this.view.getNavigationMode() != this.getSelectedIndex()) {
                this.setSelectedIndex(this.view.getNavigationMode());
            }
        }
    }
}

