/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.view;

import artofillusion.ViewerCanvas;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.view.ViewChangedEvent;
import artofillusion.view.ViewerControl;
import buoy.event.ValueChangedEvent;
import buoy.widget.Widget;

public class ViewerScaleControl
implements ViewerControl {
    private ViewerCanvas view;
    private ValueField scaleField;
    private double newScale;

    @Override
    public Widget createWidget(final ViewerCanvas view) {
        ValueField scaleField;
        this.view = view;
        this.scaleField = scaleField = new ValueField(100.0, 3, 5);
        scaleField.setText("100");
        scaleField.setMinDecimalPlaces(1);
        view.addEventLink(ViewChangedEvent.class, new Object(){

            void processEvent() {
                if (view.isPerspective() || view.getBoundCamera() != null) {
                    scaleField.setValue(view.getDistToPlane());
                } else {
                    scaleField.setEnabled(true);
                    if (view.getScale() != scaleField.getValue()) {
                        scaleField.setValue(view.getScale());
                    }
                }
            }
        });
        scaleField.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                if (!view.isPerspective()) {
                    view.getViewAnimation().start(view.getCamera().getCameraCoordinates(), view.getRotationCenter(), scaleField.getValue(), view.getOrientation(), view.getNavigationMode());
                } else {
                    view.setDistToPlane(scaleField.getValue());
                    if (view.getNavigationMode() == 0 || view.getNavigationMode() == 1) {
                        CoordinateSystem coords = view.getCamera().getCameraCoordinates().duplicate();
                        Vec3 rc = view.getRotationCenter();
                        Vec3 cc = rc.plus(coords.getZDirection().times(-view.getDistToPlane()));
                        coords.setOrigin(cc);
                        view.getViewAnimation().start(coords, rc, view.getScale(), view.getOrientation(), view.getNavigationMode());
                    } else {
                        CoordinateSystem coords = view.getCamera().getCameraCoordinates().duplicate();
                        Vec3 rc = coords.getOrigin().plus(coords.getZDirection().times(view.getDistToPlane()));
                        view.getViewAnimation().start(coords, rc, view.getScale(), view.getOrientation(), view.getNavigationMode());
                    }
                }
            }
        });
        return scaleField;
    }

    @Override
    public String getName() {
        return Translate.text("Magnification");
    }
}

