/*
 * Decompiled with CFR 0.152.
 */
package nik777.chat;

import artofillusion.ui.Translate;
import buoy.widget.BCheckBox;
import buoy.widget.BStandardDialog;
import buoy.widget.Widget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sourceforge.helpgui.gui.TestRolloverButton;
import net.sourceforge.helpgui.util.BrowserControl;
import nik777.chat.ChatFrame;

public class WebTextPane
extends Container
implements HyperlinkListener,
ActionListener {
    protected static HashMap cache = new HashMap(1024);
    protected static ArrayList cacheIndex = new ArrayList(1024);
    protected JToolBar toolbar;
    protected JTextPane text;
    protected JButton jbPrev;
    protected JButton jbNext;
    protected JButton jbHome;
    protected JButton jbPrint;
    protected JButton jbBookmarks;
    protected JButton jbCancel;
    protected JButton jbSave;
    protected JButton jbSettings;
    protected ArrayList history;
    protected int pos = -1;
    protected int maxCache = 1024;
    protected boolean caching = false;
    protected static String[] selections = new String[]{Translate.text("HelpPlugin:Ok"), Translate.text("HelpPlugin:Save"), Translate.text("HelpPlugin:Cancel")};

    public WebTextPane() {
        this.history = null;
        this.text = null;
        this.init();
    }

    public WebTextPane(JTextPane txtPane) {
        this.history = null;
        this.text = txtPane;
        this.init();
    }

    public WebTextPane(URL url) {
        this.history = new ArrayList(100);
        this.text = null;
        this.init();
        this.display(url);
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.toolbar.setRollover(true);
        this.toolbar.setFloatable(false);
        this.toolbar.setBorderPainted(true);
        this.jbPrev = new TestRolloverButton((Icon)new ImageIcon(this.getClass().getResource("/net/sourceforge/helpgui/icons/" + ChatFrame.iconsPath + "/previous.gif")));
        this.jbNext = new TestRolloverButton((Icon)new ImageIcon(this.getClass().getResource("/net/sourceforge/helpgui/icons/" + ChatFrame.iconsPath + "/next.gif")));
        this.jbHome = new TestRolloverButton((Icon)new ImageIcon(this.getClass().getResource("/net/sourceforge/helpgui/icons/" + ChatFrame.iconsPath + "/home.gif")));
        this.jbBookmarks = new TestRolloverButton((Icon)new ImageIcon(this.getClass().getResource("/net/sourceforge/helpgui/icons/" + ChatFrame.iconsPath + "/addbookmarks.gif")));
        this.jbPrint = new TestRolloverButton((Icon)new ImageIcon(this.getClass().getResource("/net/sourceforge/helpgui/icons/" + ChatFrame.iconsPath + "/print.gif")));
        this.jbSave = new TestRolloverButton((Icon)new ImageIcon(this.getClass().getResource("/net/sourceforge/helpgui/icons/" + ChatFrame.iconsPath + "/filesave.png")));
        this.jbCancel = new TestRolloverButton((Icon)new ImageIcon(this.getClass().getResource("/net/sourceforge/helpgui/icons/" + ChatFrame.iconsPath + "/button_cancel.png")));
        this.jbSettings = new TestRolloverButton((Icon)new ImageIcon(this.getClass().getResource("/net/sourceforge/helpgui/icons/" + ChatFrame.iconsPath + "/settings.png")));
        this.jbPrev.addActionListener(this);
        this.jbNext.addActionListener(this);
        this.jbHome.addActionListener(this);
        this.jbPrint.addActionListener(this);
        this.jbBookmarks.addActionListener(this);
        this.jbSave.addActionListener(this);
        this.jbCancel.addActionListener(this);
        this.jbSettings.addActionListener(this);
        this.toolbar.add(this.jbPrint);
        if (this.history != null) {
            this.toolbar.add(this.jbPrev);
            this.toolbar.add(this.jbNext);
            this.toolbar.add(this.jbHome);
            this.toolbar.add(this.jbSettings);
            this.toolbar.add(this.jbCancel);
        } else {
            this.toolbar.add(this.jbSave);
            this.toolbar.add(this.jbSettings);
        }
        this.add((Component)this.toolbar, "North");
        if (this.text == null) {
            this.text = new JTextPane();
            this.text.setEditable(false);
            this.text.setContentType("text/html");
            if (this.history != null) {
                this.text.addHyperlinkListener(this);
            }
        }
        JScrollPane scroll = new JScrollPane(this.text);
        scroll.setVerticalScrollBarPolicy(22);
        this.add((Component)scroll, "Center");
    }

    public void setCache(boolean tf, int max) {
        this.caching = tf;
        if (max >= 0) {
            this.maxCache = Math.max(64, max);
        }
    }

    public void home() {
        this.pos = 0;
        this.display((URL)this.history.get(this.pos));
    }

    public void prev() {
        if (this.pos > 0 && this.history.size() > this.pos) {
            this.display((URL)this.history.get(--this.pos));
        }
    }

    public void next() {
        if (this.pos < this.history.size() - 1) {
            this.display((URL)this.history.get(++this.pos));
        }
    }

    public void print() {
        try {
            this.text.print();
        }
        catch (Exception e) {
            System.out.println("WebTextPane.print: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        File home = new File(System.getProperty("user.home"));
        Writer out = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setSelectedFile(new File(home, "chatlog.html"));
        if (chooser.showSaveDialog(null) == 0) {
            try {
                out = new FileWriter(chooser.getSelectedFile());
                this.text.write(out);
                out.flush();
            }
            catch (IOException e) {
                System.out.println("WebTextPane.save: " + e);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void settings() {
        BCheckBox browseBox = new BCheckBox(Translate.text("HelpPlugin:browseExternal"), ChatFrame.browseExternal);
        Widget[] widgets = new Widget[]{browseBox};
        int sel = new BStandardDialog(Translate.text("HelpPlugin:Settings"), (Object)widgets, BStandardDialog.PLAIN).showOptionDialog(null, selections, selections[0]);
        if (sel == 2) {
            return;
        }
        ChatFrame.browseExternal = browseBox.getState();
        System.out.println("setting browseExternal=" + ChatFrame.browseExternal);
        if (sel == 1) {
            // empty if block
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            if (e.getSource().equals(this.jbPrev)) {
                this.prev();
            } else if (e.getSource().equals(this.jbNext)) {
                this.next();
            } else if (e.getSource().equals(this.jbHome)) {
                this.home();
            } else if (e.getSource().equals(this.jbPrint)) {
                this.print();
            } else if (e.getSource().equals(this.jbCancel)) {
                this.getParent().remove(this);
            } else if (e.getSource().equals(this.jbSave)) {
                this.save();
            } else if (e.getSource().equals(this.jbSettings)) {
                this.settings();
            }
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent ev) {
        if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.pos = -1;
            this.display(ev.getURL());
        }
    }

    public void display(URL url) {
        String urlKey = url.toString();
        if (ChatFrame.browseExternal || "mailto".equals(url.getProtocol())) {
            BrowserControl.displayURL((String)url.toString());
            return;
        }
        if (this.pos == -1) {
            if (this.history.size() > 100) {
                for (int i = 0; i < 10; ++i) {
                    this.history.remove(0);
                }
            }
            this.history.add(url);
            this.pos = this.history.size() - 1;
        }
        String content = (String)cache.get(urlKey);
        try {
            if (content != null) {
                this.text.read(new StringReader(content), null);
            } else {
                this.text.setPage(url);
                if (this.caching) {
                    System.out.println("WebTextPane.cache: " + this.text.getText());
                    cache.put(urlKey, this.text.getText());
                    cacheIndex.add(urlKey);
                }
            }
        }
        catch (Exception e) {
            System.out.println("WebTextPane.display: " + e);
            cache.remove(urlKey);
        }
    }
}

