/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.helpgui.parser;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import net.sourceforge.helpgui.page.Page;
import net.sourceforge.helpgui.page.PageRoot;

public class DocSet {
    protected PageRoot root;
    protected Page home;
    protected HashMap params;
    protected SoftReference cacheRef;
    protected ClassLoader loader;
    protected Locale local;
    protected static ArrayList parser;

    public static void registerParser(Parser p) {
        if (parser == null) {
            parser = new ArrayList(32);
        }
        parser.add(p);
    }

    public DocSet() {
        this(Locale.getDefault());
    }

    public DocSet(Locale local) {
        this.local = local;
        this.params = new HashMap(128);
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public PageRoot getRoot() {
        return this.root;
    }

    public String getProperty(String name) {
        return (String)this.params.get(name);
    }

    public Page addSection(String name, Page parent) {
        Page result = new Page(name, "", "", false, parent != null ? parent : null);
        this.add(result, parent);
        return result;
    }

    public void add(String path, Page parent) {
        int i;
        Page[] result = null;
        for (i = 0; result == null && i < parser.size(); ++i) {
            try {
                result = ((Parser)parser.get(i)).parse(path, this.loader, this.local, this.params);
                continue;
            }
            catch (Exception e) {
                System.out.println("DocSet.add (skipping parser): " + e);
            }
        }
        if (result != null) {
            for (i = 0; i < result.length; ++i) {
                this.add((Page)result[i], parent);
            }
        } else {
            System.out.println("DocSet.add: could not load " + path);
        }
    }

    public void add(Page page, Page parent) {
        if (page != null) {
            if (this.root == null) {
                this.root = new PageRoot();
            }
            if (parent != null) {
                page.setParent(parent);
            } else {
                page.setParent(this.root);
            }
            if (this.home == null && page.getHome()) {
                this.home = page;
            }
        }
    }

    public Page get(String path) {
        Page result;
        HashMap<String, Page> cache = this.cacheRef != null ? this.cacheRef.get() : null;
        if (cache == null) {
            cache = new HashMap<String, Page>(1024);
            this.cacheRef = new SoftReference(cache);
        }
        if ((result = (Page)cache.get(path)) != null) {
            return result;
        }
        ArrayList<Enumeration> kids = new ArrayList<Enumeration>(256);
        kids.add(this.root.children());
        Enumeration e = null;
        Page p = null;
        for (int i = 0; result == null && i < kids.size(); ++i) {
            e = (Enumeration)kids.get(i);
            while (result == null && e.hasMoreElements()) {
                p = (Page)e.nextElement();
                if (path.equals(p.getTarget())) {
                    result = p;
                }
                kids.add(result.children());
            }
        }
        if (result != null) {
            cache.put(path, result);
        }
        return result;
    }

    public Iterator iterator() {
        return new Iterator(){
            ArrayList kids = new ArrayList(256);
            Enumeration enumer;
            {
                this.enumer = DocSet.this.root.children();
            }

            public boolean hasNext() {
                return this.enumer != null && this.enumer.hasMoreElements();
            }

            public Object next() {
                Page result;
                if (!this.enumer.hasMoreElements() && this.kids.size() > 0) {
                    this.enumer = (Enumeration)this.kids.remove(0);
                }
                if ((result = (Page)(this.enumer != null ? this.enumer.nextElement() : null)) != null && result.getChildCount() > 0) {
                    this.kids.add(result.children());
                }
                return result;
            }

            public void remove() {
                throw new UnsupportedOperationException("DocSet.Iterator.remove");
            }
        };
    }

    public Page getHomepage() {
        if (this.home == null) {
            String homekey = (String)this.params.get("homepage");
            System.out.println("homekey=" + homekey);
            if (homekey != null) {
                String target = (String)this.params.get(homekey);
                System.out.println("home target=" + target);
                if (target != null && target.length() > 0) {
                    this.home = new Page("Home", "", target, true, (Page)null);
                }
            }
            if (this.home == null) {
                ArrayList<Enumeration> kids = new ArrayList<Enumeration>(256);
                kids.add(this.root.children());
                Enumeration e = null;
                Page p = null;
                for (int i = 0; this.home == null && i < kids.size(); ++i) {
                    e = (Enumeration)kids.get(i);
                    while (this.home == null && e.hasMoreElements()) {
                        p = (Page)e.nextElement();
                        if (p.getHome()) {
                            this.home = p;
                        }
                        if (p.getChildCount() <= 0) continue;
                        kids.add(p.children());
                    }
                }
            }
        }
        if (this.home == null) {
            this.home = (Page)this.root.getChildAt(0);
        }
        return this.home;
    }

    public static abstract class Parser {
        public abstract Page[] parse(String var1, ClassLoader var2, Locale var3, HashMap var4) throws IOException;

        protected URL getResource(String path, ClassLoader loader, Locale local) throws IOException {
            String suffix;
            URL result = null;
            String string = suffix = local != null ? "_" + local.getLanguage() : null;
            if (suffix != null) {
                int point = path.lastIndexOf(46);
                String localpath = point > 0 ? path.substring(0, point) + suffix + path.substring(point) : path + suffix;
                System.out.println("DocSet.Parser.getResource: trying " + localpath);
                result = loader.getResource(localpath);
                if (result != null) {
                    return result;
                }
            }
            System.out.println("DocSet.Parser.getResource: trying " + path);
            return loader.getResource(path);
        }
    }
}

