/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.CSGDialog;
import artofillusion.LayoutWindow;
import artofillusion.ModellingTool;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.Track;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.CSGObject;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.widget.BStandardDialog;
import buoy.widget.Widget;
import java.util.Vector;

public class CSGTool
implements ModellingTool {
    private static int counter = 1;

    public String getName() {
        return Translate.text((String)"menu.boolean");
    }

    public void commandSelected(LayoutWindow window) {
        Scene scene = window.getScene();
        int[] selection = window.getSelectedIndices();
        int closedCount = 0;
        Vector<ObjectInfo> inputObj = new Vector<ObjectInfo>();
        for (int i = 0; i < selection.length; ++i) {
            ObjectInfo obj = scene.getObject(selection[i]);
            if (!obj.getObject().canSetTexture() || !(obj.getObject() instanceof TriangleMesh) && obj.getObject().canConvertToTriangleMesh() == 0) continue;
            inputObj.addElement(obj);
            if (!obj.getObject().isClosed()) continue;
            ++closedCount;
        }
        if (inputObj.size() < 2 || closedCount < 1) {
            new BStandardDialog("", (Object)UIUtilities.breakString((String)"You must select two objects for boolean modelling, at least one of which must be solid."), BStandardDialog.INFORMATION).showMessageDialog((Widget)window.getFrame());
            return;
        }
        CSGObject newobj = new CSGObject((ObjectInfo)inputObj.elementAt(0), (ObjectInfo)inputObj.elementAt(1), 0);
        Vec3 center = newobj.centerObjects();
        CSGDialog dial = new CSGDialog((EditingWindow)window, newobj);
        if (!dial.clickedOk()) {
            return;
        }
        ObjectInfo info = new ObjectInfo((Object3D)newobj, new CoordinateSystem(center, Vec3.vz(), Vec3.vy()), "Boolean " + counter++);
        info.addTrack((Track)new PositionTrack(info), 0);
        info.addTrack((Track)new RotationTrack(info), 1);
        window.addObject(info, null);
        window.setSelection(scene.getNumObjects() - 1);
        window.setUndoRecord(new UndoRecord((EditingWindow)window, false, 5, new Object[]{scene.getNumObjects() - 1}));
        window.updateImage();
    }
}

