/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.LayoutWindow;
import artofillusion.ObjectPreviewCanvas;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.Keyframe;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.NullObject;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectCollection;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.tools.TextTool;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BList;
import buoy.widget.BTextField;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class TextDialog
extends BDialog {
    private final LayoutWindow window;
    private final BTextField text;
    private final BComboBox typeChoice;
    private final BList fontsList;
    private final BCheckBox boldBox;
    private final BCheckBox italicBox;
    private final ValueField thicknessValue;
    private final ObjectPreviewCanvas preview;
    private final BButton okButton;
    private final BButton cancelButton;
    private ArrayList<ObjectInfo> objects;

    public TextDialog(LayoutWindow window) {
        super((WindowWidget)window, Translate.text((String)"Text"), true);
        this.window = window;
        this.text = new BTextField("Text");
        this.typeChoice = new BComboBox(new Object[]{Translate.text((String)"Outline"), Translate.text((String)"Tubes"), Translate.text((String)"Surface"), Translate.text((String)"Solid")});
        this.typeChoice.setSelectedIndex(2);
        Object[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.fontsList = new BList(fonts);
        this.fontsList.setPreferredVisibleRows(10);
        this.fontsList.setMultipleSelectionEnabled(false);
        int selectedFontIndex = 0;
        for (int i = 0; i < fonts.length; ++i) {
            if (!((String)fonts[i]).equals("Serif")) continue;
            selectedFontIndex = i;
        }
        this.fontsList.setSelected(selectedFontIndex, true);
        this.boldBox = new BCheckBox(Translate.text((String)"Bold"), false);
        this.italicBox = new BCheckBox(Translate.text((String)"Italic"), false);
        this.thicknessValue = new ValueField(0.1, 3);
        this.createObjects();
        this.preview = new ObjectPreviewCanvas(new ObjectInfo((Object3D)new TextCollection(), new CoordinateSystem(), ""));
        final ActionProcessor actionProcessor = new ActionProcessor();
        Object listener = new Object(){

            void processEvent() {
                actionProcessor.addEvent(new Runnable(){

                    @Override
                    public void run() {
                        TextDialog.this.createObjects();
                    }
                });
            }
        };
        this.boldBox.addEventLink(ValueChangedEvent.class, listener);
        this.italicBox.addEventLink(ValueChangedEvent.class, listener);
        this.fontsList.addEventLink(SelectionChangedEvent.class, listener);
        this.text.addEventLink(ValueChangedEvent.class, listener);
        this.typeChoice.addEventLink(ValueChangedEvent.class, listener);
        this.thicknessValue.addEventLink(ValueChangedEvent.class, listener);
        FormContainer content = new FormContainer(new double[]{0.0, 1.0}, new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0});
        this.setContent((Widget)content);
        content.add((Widget)this.text, 0, 0, 2, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL));
        RowContainer typeRow = new RowContainer();
        typeRow.add((Widget)Translate.label((String)"objectType"));
        typeRow.add((Widget)this.typeChoice);
        content.add((Widget)typeRow, 0, 1);
        content.add((Widget)Translate.label((String)"Font"), 0, 2);
        content.add((Widget)UIUtilities.createScrollingList((BList)this.fontsList), 0, 3, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH));
        RowContainer styleRow = new RowContainer();
        styleRow.add((Widget)this.boldBox);
        styleRow.add((Widget)this.italicBox);
        content.add((Widget)styleRow, 0, 4);
        RowContainer thicknessRow = new RowContainer();
        thicknessRow.add((Widget)Translate.label((String)"Thickness"));
        thicknessRow.add((Widget)this.thicknessValue);
        content.add((Widget)thicknessRow, 0, 5);
        content.add((Widget)this.preview, 1, 1, 1, 5, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH));
        RowContainer buttonsRow = new RowContainer();
        this.okButton = Translate.button((String)"ok", (Object)((Object)this), (String)"doOk");
        buttonsRow.add((Widget)this.okButton);
        this.cancelButton = Translate.button((String)"cancel", (Object)((Object)this), (String)"dispose");
        buttonsRow.add((Widget)this.cancelButton);
        content.add((Widget)buttonsRow, 0, 6, 2, 1);
        this.pack();
        UIUtilities.centerDialog((BDialog)this, (WindowWidget)window);
        this.updateComponents();
        this.fontsList.scrollToItem(selectedFontIndex);
        this.setDefaultButton(this.okButton);
        this.updatePreview();
        this.setVisible(true);
    }

    private void updateComponents() {
        int typeIndex = this.typeChoice.getSelectedIndex();
        this.thicknessValue.setEnabled(typeIndex == 1 || typeIndex == 3);
        this.okButton.setEnabled(this.text.getText().length() > 0);
    }

    private void createObjects() {
        TextTool.TextType[] types = new TextTool.TextType[]{TextTool.TextType.Outline, TextTool.TextType.Tube, TextTool.TextType.Surface, TextTool.TextType.Solid};
        TextTool.TextType type = types[this.typeChoice.getSelectedIndex()];
        this.objects = TextTool.createText(this.text.getText(), this.fontsList.getSelectedValue().toString(), type, this.boldBox.getState(), this.italicBox.getState(), this.thicknessValue.getValue(), this.window.getScene().getDefaultTexture());
        if (this.preview != null) {
            this.updatePreview();
            this.updateComponents();
        }
    }

    private void updatePreview() {
        this.preview.setObject((Object3D)new TextCollection());
        this.preview.objectChanged();
        BoundingBox bounds = this.preview.getObject().getBounds();
        bounds.outset((bounds.maxx - bounds.minx) / 10.0);
        this.preview.frameBox(bounds);
        this.preview.repaint();
    }

    private void doOk() {
        if (this.objects.size() > 0) {
            UndoRecord undo = new UndoRecord((EditingWindow)this.window, false);
            if (this.objects.get(0).getObject() instanceof TriangleMesh) {
                TriangleMesh mesh = new TextCollection().convertToTriangleMesh(1.0);
                mesh.setSmoothingMethod(3);
                mesh.setTexture(this.window.getScene().getDefaultTexture(), this.window.getScene().getDefaultTexture().getDefaultMapping((Object3D)mesh));
                this.window.addObject(new ObjectInfo((Object3D)mesh, new CoordinateSystem(), this.text.getText()), undo);
                this.window.setSelection(this.window.getScene().getNumObjects() - 1);
            } else {
                ObjectInfo parent = new ObjectInfo((Object3D)new NullObject(), new CoordinateSystem(), this.text.getText());
                this.window.clearSelection();
                this.window.addObject(parent, undo);
                this.window.addToSelection(this.window.getScene().getNumObjects() - 1);
                for (ObjectInfo obj : this.objects) {
                    this.window.addObject(obj, undo);
                    parent.addChild(obj, parent.getChildren().length);
                    this.window.addToSelection(this.window.getScene().getNumObjects() - 1);
                }
                this.window.rebuildItemList();
            }
            this.window.setUndoRecord(undo);
            this.window.updateImage();
        }
        this.dispose();
    }

    private class TextCollection
    extends ObjectCollection {
        private TextCollection() {
        }

        protected Enumeration<ObjectInfo> enumerateObjects(ObjectInfo info, boolean interactive, Scene scene) {
            return Collections.enumeration(TextDialog.this.objects);
        }

        public Object3D duplicate() {
            return new TextCollection();
        }

        public void copyObject(Object3D obj) {
        }

        public void setSize(double xsize, double ysize, double zsize) {
        }

        public Keyframe getPoseKeyframe() {
            return null;
        }

        public void applyPoseKeyframe(Keyframe k) {
        }
    }
}

