/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.raytracer.PhotonMap;
import artofillusion.raytracer.PhotonSource;
import artofillusion.raytracer.Ray;
import artofillusion.util.ThreadManager;

public class DirectionalPhotonSource
implements PhotonSource {
    private CoordinateSystem coords;
    private RGBColor color;
    private float lightIntensity;
    private double minx;
    private double maxx;
    private double miny;
    private double maxy;
    private Vec3 center;

    public DirectionalPhotonSource(DirectionalLight light, CoordinateSystem coords, PhotonMap map) {
        this.coords = coords;
        BoundingBox bounds = map.getBounds().transformAndOutset(coords.toLocal());
        this.minx = bounds.minx;
        this.maxx = bounds.maxx;
        this.miny = bounds.miny;
        this.maxy = bounds.maxy;
        this.center = coords.fromLocal().times(new Vec3(0.5 * (this.minx + this.maxx), 0.5 * (this.miny + this.maxy), bounds.minz - 1.0));
        this.color = new RGBColor();
        light.getLight(this.color, new Vec3());
        this.lightIntensity = this.color.getRed() + this.color.getGreen() + this.color.getBlue();
        if (this.lightIntensity == 0.0f) {
            return;
        }
        this.color.scale(1.0f / this.lightIntensity);
        this.lightIntensity *= (float)((this.maxx - this.minx) * (this.maxy - this.miny));
    }

    @Override
    public double getTotalIntensity() {
        return this.lightIntensity;
    }

    @Override
    public void generatePhotons(final PhotonMap map, double intensity, ThreadManager threads) {
        int n;
        final Thread currentThread = Thread.currentThread();
        final Vec3 xdir = this.coords.fromLocal().timesDirection(Vec3.vx());
        final Vec3 ydir = this.coords.fromLocal().timesDirection(Vec3.vy());
        final double xsize = this.maxx - this.minx;
        final double ysize = this.maxy - this.miny;
        for (int num = (int)intensity; num > 0; num -= n * n) {
            n = Math.max((int)Math.sqrt(num), 1);
            final double dx = xsize / (double)n;
            final double dy = ysize / (double)n;
            threads.setNumIndices(n * n);
            threads.setTask(new ThreadManager.Task(){

                public void execute(int index) {
                    if (map.getRenderer().renderThread != currentThread) {
                        return;
                    }
                    int i = index / n;
                    int j = index - i * n;
                    double basex = -0.5 * xsize + (double)i * dx;
                    double basey = -0.5 * ysize + (double)j * dy;
                    Ray r = new Ray(map.getWorkspace().context);
                    Vec3 orig = r.getOrigin();
                    r.getDirection().set(DirectionalPhotonSource.this.coords.getZDirection());
                    double x = basex + map.random.nextDouble() * dx;
                    double y = basey + map.random.nextDouble() * dy;
                    orig.set(((DirectionalPhotonSource)DirectionalPhotonSource.this).center.x + x * xdir.x + y * ydir.x, ((DirectionalPhotonSource)DirectionalPhotonSource.this).center.y + x * xdir.y + y * ydir.y, ((DirectionalPhotonSource)DirectionalPhotonSource.this).center.z + x * xdir.z + y * ydir.z);
                    r.newID();
                    map.spawnPhoton(r, DirectionalPhotonSource.this.color, false);
                }

                public void cleanup() {
                    map.getWorkspace().cleanup();
                }
            });
            threads.run();
        }
    }
}

