/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.BoundingBox;
import artofillusion.math.Vec3;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;
import java.util.ArrayList;

public class OctreeNode {
    public OctreeNode parent;
    public OctreeNode[] child;
    public RTObject[] obj;
    public float minx;
    public float maxx;
    public float miny;
    public float maxy;
    public float minz;
    public float maxz;
    public float midx;
    public float midy;
    public float midz;
    private static final int CELLS = 64;
    private static final RTObject[] EMPTY_OBJECT_LIST = new RTObject[0];
    private static int[] leftCount = new int[66];
    private static int[] rightCount = new int[66];

    public OctreeNode(float minx, float maxx, float miny, float maxy, float minz, float maxz, RTObject[] tri, BoundingBox[] bb, OctreeNode parentNode) {
        int i;
        this.minx = minx;
        this.maxx = maxx;
        this.miny = miny;
        this.maxy = maxy;
        this.minz = minz;
        this.maxz = maxz;
        boolean[] inside = new boolean[tri.length];
        this.parent = parentNode;
        int count = 0;
        for (i = 0; i < tri.length; ++i) {
            if (!this.intersects(bb[i]) || !tri[i].intersectsNode(this)) continue;
            inside[i] = true;
            ++count;
        }
        if (count == 0) {
            this.obj = EMPTY_OBJECT_LIST;
            return;
        }
        this.obj = new RTObject[count];
        BoundingBox[] objBounds = new BoundingBox[count];
        count = 0;
        for (i = 0; i < tri.length; ++i) {
            if (!inside[i]) continue;
            this.obj[count] = tri[i];
            objBounds[count++] = bb[i];
        }
        this.subdivide(objBounds);
    }

    private void subdivide(BoundingBox[] objBounds) {
        if (this.obj.length > 9) {
            boolean splitz;
            this.findMidpoints(objBounds);
            boolean splitx = this.midx != this.maxx;
            boolean splity = this.midy != this.maxy;
            boolean bl = splitz = this.midz != this.maxz;
            if (!(splitx || splity || splitz)) {
                return;
            }
            this.child = new OctreeNode[8];
            this.child[0] = new OctreeNode(this.minx, this.midx, this.miny, this.midy, this.minz, this.midz, this.obj, objBounds, this);
            if (splitz) {
                this.child[1] = new OctreeNode(this.minx, this.midx, this.miny, this.midy, this.midz, this.maxz, this.obj, objBounds, this);
            }
            if (splity) {
                this.child[2] = new OctreeNode(this.minx, this.midx, this.midy, this.maxy, this.minz, this.midz, this.obj, objBounds, this);
                if (splitz) {
                    this.child[3] = new OctreeNode(this.minx, this.midx, this.midy, this.maxy, this.midz, this.maxz, this.obj, objBounds, this);
                }
            }
            if (splitx) {
                this.child[4] = new OctreeNode(this.midx, this.maxx, this.miny, this.midy, this.minz, this.midz, this.obj, objBounds, this);
                if (splitz) {
                    this.child[5] = new OctreeNode(this.midx, this.maxx, this.miny, this.midy, this.midz, this.maxz, this.obj, objBounds, this);
                }
                if (splity) {
                    this.child[6] = new OctreeNode(this.midx, this.maxx, this.midy, this.maxy, this.minz, this.midz, this.obj, objBounds, this);
                    if (splitz) {
                        this.child[7] = new OctreeNode(this.midx, this.maxx, this.midy, this.maxy, this.midz, this.maxz, this.obj, objBounds, this);
                    }
                }
            }
            this.obj = null;
        }
    }

    public OctreeNode[] findChildNodes() {
        ArrayList<OctreeNode> nodes = new ArrayList<OctreeNode>();
        if (this.child != null) {
            for (int i = 0; i < this.child.length; ++i) {
                if (this.child[i] == null) continue;
                nodes.add(this.child[i]);
            }
        }
        return nodes.toArray(new OctreeNode[nodes.size()]);
    }

    public RTObject[] getObjects() {
        return this.obj;
    }

    public OctreeNode findNode(Vec3 pos) {
        if (!this.contains(pos)) {
            return null;
        }
        OctreeNode current = this;
        while (current.obj == null) {
            if (pos.x > (double)current.midx) {
                if (pos.y > (double)current.midy) {
                    if (pos.z > (double)current.midz) {
                        current = current.child[7];
                        continue;
                    }
                    current = current.child[6];
                    continue;
                }
                if (pos.z > (double)current.midz) {
                    current = current.child[5];
                    continue;
                }
                current = current.child[4];
                continue;
            }
            if (pos.y > (double)current.midy) {
                if (pos.z > (double)current.midz) {
                    current = current.child[3];
                    continue;
                }
                current = current.child[2];
                continue;
            }
            if (pos.z > (double)current.midz) {
                current = current.child[1];
                continue;
            }
            current = current.child[0];
        }
        return current;
    }

    public OctreeNode findNextNode(Ray r) {
        double t;
        double maxt = Double.MAX_VALUE;
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        if (this.parent == null) {
            return null;
        }
        if (dir.x > 1.0E-12) {
            dx = 1.0E-12;
            t = ((double)this.maxx - orig.x) / dir.x;
            if (t < maxt) {
                maxt = t;
            }
        } else if (dir.x < -1.0E-12) {
            dx = -1.0E-12;
            t = ((double)this.minx - orig.x) / dir.x;
            if (t < maxt) {
                maxt = t;
            }
        }
        if (dir.y > 1.0E-12) {
            dy = 1.0E-12;
            t = ((double)this.maxy - orig.y) / dir.y;
            if (t < maxt) {
                maxt = t;
            }
        } else if (dir.y < -1.0E-12) {
            dy = -1.0E-12;
            t = ((double)this.miny - orig.y) / dir.y;
            if (t < maxt) {
                maxt = t;
            }
        }
        if (dir.z > 1.0E-12) {
            dz = 1.0E-12;
            t = ((double)this.maxz - orig.z) / dir.z;
            if (t < maxt) {
                maxt = t;
            }
        } else if (dir.z < -1.0E-12) {
            dz = -1.0E-12;
            t = ((double)this.minz - orig.z) / dir.z;
            if (t < maxt) {
                maxt = t;
            }
        }
        Vec3 nextPos = r.tempVec1;
        nextPos.set(orig.x + dir.x * maxt + dx, orig.y + dir.y * maxt + dy, orig.z + dir.z * maxt + dz);
        OctreeNode current = this.parent;
        while (!current.contains(nextPos)) {
            current = current.parent;
            if (current != null) continue;
            return null;
        }
        while (current.obj == null) {
            if (nextPos.x > (double)current.midx) {
                if (nextPos.y > (double)current.midy) {
                    if (nextPos.z > (double)current.midz) {
                        current = current.child[7];
                        continue;
                    }
                    current = current.child[6];
                    continue;
                }
                if (nextPos.z > (double)current.midz) {
                    current = current.child[5];
                    continue;
                }
                current = current.child[4];
                continue;
            }
            if (nextPos.y > (double)current.midy) {
                if (nextPos.z > (double)current.midz) {
                    current = current.child[3];
                    continue;
                }
                current = current.child[2];
                continue;
            }
            if (nextPos.z > (double)current.midz) {
                current = current.child[1];
                continue;
            }
            current = current.child[0];
        }
        return current;
    }

    public OctreeNode findFirstNode(Ray r) {
        double t2;
        double t1;
        double mint = -1.7976931348623157E308;
        double maxt = Double.MAX_VALUE;
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        if (dir.x == 0.0) {
            if (orig.x < (double)this.minx || orig.x > (double)this.maxx) {
                return null;
            }
        } else {
            t1 = ((double)this.minx - orig.x) / dir.x;
            t2 = ((double)this.maxx - orig.x) / dir.x;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return null;
            }
        }
        if (dir.y == 0.0) {
            if (orig.y < (double)this.miny || orig.y > (double)this.maxy) {
                return null;
            }
        } else {
            t1 = ((double)this.miny - orig.y) / dir.y;
            t2 = ((double)this.maxy - orig.y) / dir.y;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return null;
            }
        }
        if (dir.z == 0.0) {
            if (orig.z < (double)this.minz || orig.z > (double)this.maxz) {
                return null;
            }
        } else {
            t1 = ((double)this.minz - orig.z) / dir.z;
            t2 = ((double)this.maxz - orig.z) / dir.z;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return null;
            }
        }
        Vec3 nextPos = r.tempVec1;
        nextPos.set(orig.x + dir.x * (mint += 1.0E-12), orig.y + dir.y * mint, orig.z + dir.z * mint);
        return this.findNode(nextPos);
    }

    private void findMidpoints(BoundingBox[] objBounds) {
        float zsize = this.maxz - this.minz;
        float xsize = this.maxx - this.minx;
        float ysize = this.maxy - this.miny;
        double cutoff = xsize > ysize ? xsize : ysize;
        if ((double)zsize > cutoff) {
            cutoff = zsize;
        }
        if ((cutoff *= 0.1) < 0.01) {
            cutoff = 0.01;
        }
        this.midx = (double)xsize > cutoff ? this.findAxisMidpoint(objBounds, 0) : this.maxx;
        this.midy = (double)ysize > cutoff ? this.findAxisMidpoint(objBounds, 1) : this.maxy;
        this.midz = (double)zsize > cutoff ? this.findAxisMidpoint(objBounds, 2) : this.maxz;
    }

    private float findAxisMidpoint(BoundingBox[] objBounds, int axis) {
        int i;
        for (int i2 = 0; i2 < 66; ++i2) {
            OctreeNode.rightCount[i2] = 0;
            OctreeNode.leftCount[i2] = 0;
        }
        float min = OctreeNode.findMinimum(this, axis);
        float max = OctreeNode.findMaximum(this, axis);
        float invwidth = 64.0f / (max - min);
        for (int i3 = 0; i3 < objBounds.length; ++i3) {
            float objmin = OctreeNode.findMinimum(objBounds[i3], axis);
            float objmax = OctreeNode.findMaximum(objBounds[i3], axis);
            if (objmin <= min) {
                leftCount[0] = leftCount[0] + 1;
            } else {
                int n = (int)((objmin - min) * invwidth) + 1;
                leftCount[n] = leftCount[n] + 1;
            }
            if (!(objmax < max)) continue;
            int n = (int)((objmax - min) * invwidth) + 1;
            rightCount[n] = rightCount[n] + 1;
        }
        int numToLeft = 0;
        int numToRight = objBounds.length;
        int minCost = numToRight * 48;
        int j = -1;
        for (int i4 = 0; i4 < 64; ++i4) {
            int cost = (numToLeft += leftCount[i4]) * i4 + (numToRight -= rightCount[i4]) * (64 - i4);
            if (cost >= minCost) continue;
            minCost = cost;
            j = i4;
        }
        if (j == -1) {
            return max;
        }
        float mid = min + (float)j / invwidth;
        float limit = mid + 1.0f / invwidth;
        boolean found = false;
        for (i = 0; i < objBounds.length; ++i) {
            float objmin = OctreeNode.findMinimum(objBounds[i], axis);
            if (!(objmin > mid) || !(objmin < limit)) continue;
            limit = objmin;
            found = true;
        }
        if (found) {
            return (float)((double)limit - 1.0E-12);
        }
        limit = mid - 1.0f / invwidth;
        found = false;
        for (i = 0; i < objBounds.length; ++i) {
            float objmax = OctreeNode.findMaximum(objBounds[i], axis);
            if (!(objmax < mid) || !(objmax > limit)) continue;
            limit = objmax;
            found = true;
        }
        if (found) {
            return (float)((double)limit + 1.0E-12);
        }
        return mid;
    }

    public BoundingBox getBounds() {
        return new BoundingBox((double)this.minx, (double)this.maxx, (double)this.miny, (double)this.maxy, (double)this.minz, (double)this.maxz);
    }

    public boolean contains(Vec3 p) {
        return !(p.x < (double)this.minx || p.x > (double)this.maxx || p.y < (double)this.miny || p.y > (double)this.maxy || p.z < (double)this.minz) && !(p.z > (double)this.maxz);
    }

    public boolean intersects(BoundingBox b) {
        return !((double)this.minx > b.maxx || (double)this.maxx < b.minx || (double)this.miny > b.maxy || (double)this.maxy < b.miny || (double)this.minz > b.maxz) && !((double)this.maxz < b.minz);
    }

    private static float findMinimum(OctreeNode box, int axis) {
        switch (axis) {
            case 0: {
                return box.minx;
            }
            case 1: {
                return box.miny;
            }
        }
        return box.minz;
    }

    private static float findMaximum(OctreeNode box, int axis) {
        switch (axis) {
            case 0: {
                return box.maxx;
            }
            case 1: {
                return box.maxy;
            }
        }
        return box.maxz;
    }

    private static float findMinimum(BoundingBox box, int axis) {
        double val;
        switch (axis) {
            case 0: {
                val = box.minx;
                break;
            }
            case 1: {
                val = box.miny;
                break;
            }
            default: {
                val = box.minz;
            }
        }
        return Math.nextAfter((float)val, Double.NEGATIVE_INFINITY);
    }

    private static float findMaximum(BoundingBox box, int axis) {
        double val;
        switch (axis) {
            case 0: {
                val = box.maxx;
                break;
            }
            case 1: {
                val = box.maxy;
                break;
            }
            default: {
                val = box.maxz;
            }
        }
        return Math.nextAfter((float)val, Double.POSITIVE_INFINITY);
    }
}

